<?php 

extract(shortcode_atts(array(
	'title'            => 'Column title', 
	'highlight'        => 'disable',
	'highlight_text' => '',
	'price'            => '',
	'currency_symbol'  => '',
	'interval'         => '',
	'highlight_color' => '#32B2C3',
	'title_color' => '#32B2C3',
	'highlight_title_color' => '#fff',
	'background_color' => '#f7f7f7',	
	'highlight_background_color' => '#fff',
	'text_color' => '#747474',
	'border' => 'enable',
	'border_color' => '#e7e7e7',
), $atts) );

$border_class = null;

if ( $border == 'enable' ) {
	$border_class = ' price-column-border';
}

if ( $highlight == 'enable' ) {
	$bg_color = $highlight_background_color; 
} else {	
	$bg_color = $background_color;	
}
	
ob_start(); ?>

<div class="pricing-column<?php echo $border_class; ?>" style="background-color: <?php echo $bg_color; ?>; border-color: <?php echo $border_color; ?>; color: <?php echo $text_color; ?>;">

	<div class="pricing-column-inner">

		<?php if ( $highlight == 'enable' ) { ?>
	
			<div class="pricing-column-highlight-text" style="background-color: <?php echo $highlight_color; ?>; color: <?php echo $highlight_title_color; ?>;">
				<?php echo $highlight_text; ?>		
			</div>
	
			<div class="pricing-column-title" style="background-color: <?php echo $highlight_color; ?>; color: <?php echo $highlight_title_color; ?>;">
				<?php echo $title; ?>
			</div>

		<?php } else { ?>

			<div class="pricing-column-title" style="color: <?php echo $title_color; ?>;">
				<?php echo $title; ?>
			</div>
	
		<?php } ?>

		<div class="pricing-column-costs" style="border-color: <?php echo $border_color; ?>;">
			<span class="pricing-column-symbol"><?php echo $currency_symbol; ?></span>
			<span class="pricing-column-price"><?php echo $price; ?></span>
			<div class="pricing-column-interval"><?php echo $interval; ?></div>
		</div>

		<div class="pricing-column-content" style="border-color: <?php echo $border_color; ?>;"><?php echo do_shortcode( $content ); ?></div>

	</div>

</div>

<div class="pricing-row"></div>

<?php

$output_string = ob_get_contents();
ob_end_clean(); 
echo $output_string;

?>