<?php

if ( ! function_exists( 'gp_portfolio' ) ) {

	function gp_portfolio( $atts, $content = null ) {
	
		extract( shortcode_atts( array(
			'type' => 'portfolio-columns-3',
			'cats' => '',
			'filter' => 'enable',
			'per_page' => '10',
			'pages' => 'enable',
			'class' => '',
		), $atts ) );

		// Unique Name
		STATIC $i = 0;
		$i++;
		$name = 'portfolio_' . $i;
		
		require( gp_inc . 'options.php' );
		
		ob_start(); ?>

		<?php if ( $filter == 'enable' ) { ?>
			<div id="<?php echo $name; ?>-filters" class="portfolio-filters portfolio-shortcode">
				<ul>
				   <li><a href="#" data-filter="*" class="gp-active"><?php echo __( 'All', 'gp_lang' ); ?></a></li>
					<?php 
					$terms = get_terms( 'gp_portfolios' );
					if ( !empty( $terms ) ) {
						foreach ( $terms as $term ) {
							echo '<li><a href="#" data-filter=".' . strtolower(preg_replace('/\s+/', '-', $term->slug ) ) . '">' . $term->name . '</a></li>';
						}
					}
					?>
				</ul>
			</div>
		<?php } ?><!-- END PORTFOLIO FILTERS -->
	
		<?php if ( get_query_var('paged') ) {
			$paged = get_query_var('paged');
		} elseif ( get_query_var('page') ) {
			$paged = get_query_var('page');
		} else {
			$paged = 1;
		}

		if ( preg_match( '/-/', $cats ) ) {
			$operator = 'NOT IN';
		} else {
			$operator = 'IN';
		}
		
		$cat_ids = preg_replace('/-/', '', $cats );

		if ( $cats != '' ) {
			$cats = array( 'relation' => 'OR', array( 'operator' => $operator, 'taxonomy' => 'gp_portfolios', 'terms' => explode(',', $cat_ids ) ), 'field' => 'id' );
		} else {
			$cats = null;
		}
				
		$args = array(
		'post_type'      => 'gp_portfolio_item',
		'tax_query' => $cats,
		'posts_per_page' => $per_page,
		'paged'          => $paged,
		);

		$featured_query = new wp_query( $args ); if ( $featured_query->have_posts() ) : ?>

			<div id="<?php echo $name; ?>" class="portfolio-wrapper <?php echo $type; ?>">

				<?php while ( $featured_query->have_posts() ) : $featured_query->the_post(); ?>

					<?php 
					
					// Portfolio Categories
					$terms = get_the_terms( get_the_ID(), 'gp_portfolios' );
					$gp_portfolio_cats = null;
					if ( !empty( $terms ) ) {
						foreach ( $terms as $term ) {
							$gp_portfolio_cats .= strtolower( $term->slug ) . ' ';
						}
					} ?>

					<article <?php post_class( 'portfolio-loop ' . $gp_portfolio_cats . get_post_meta( get_the_ID(), '_gp_image_size', true ) ); ?> data-portfolio-cat="<?php echo $gp_portfolio_cats; ?>">

						<?php if( has_post_thumbnail() ) { ?>

							<div class="post-thumbnail">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
									
									<?php if ( $type != 'portfolio-masonry' ) {
									
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 700, 500, true, false, true );
									
									} elseif ( get_post_meta( get_the_ID(), '_gp_image_size', true ) == 'wide' ) {
									
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 1000, 500, true, false, true );
										
									} elseif ( get_post_meta( get_the_ID(), '_gp_image_size', true ) == 'tall' ) {
									
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 500, 1000, true, false, true );
										
									} elseif ( get_post_meta( get_the_ID(), '_gp_image_size', true ) == 'large' ) {
										
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 1000, 1000, true, false, true );								
									
									} else {
									
										$image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), 500, 500, true, false, true );						
									
									} ?>
									
									<?php if ( $gp_retina == 'enable' ) {
										$retina = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), $image[1] * 2, $image[2] * 2, true, false, true );
									} else {
										$retina = '';
									} ?>
									
									<img src="<?php echo $image[0]; ?>" data-rel="<?php echo $retina[0]; ?>" width="<?php echo $image[1]; ?>" height="<?php echo $image[2]; ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ); } else { the_title_attribute(); } ?>" class="wp-post-image" />
												
								</a>
							</div>

						<?php } ?><!-- END FEATURED IMAGE -->

						<?php if ( $type != 'portfolio-masonry' ) { ?>

							<header class="entry-header">

								<h2 class="loop-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>

							</header>
						
						<?php } ?>
						
					</article><!-- END PORTFOLIO ITEM -->

				<?php endwhile; ?>

			</div><!-- END PORTFOLIO WRAPPER -->

			<?php if ( $pages == 'enable' ) { gp_pagination( $featured_query->max_num_pages ); } ?>

		<?php else : ?>

			<span class="error"><?php _e( 'No portfolio items found.', 'gp_lang' ); ?></span>

		<?php endif; wp_reset_postdata(); ?>
		
		<?php

		// Column Number
		if ( $type == 'portfolio-columns-2' ) {
			$cols = 2;
		} elseif ( $type == 'portfolio-columns-3' ) {
			$cols = 3;
		} elseif ( $type == 'portfolio-columns-4' ) {
			$cols = 4;
		} elseif ( $type == 'portfolio-columns-5' ) {
			$cols = 5;
		} elseif ( $type == 'portfolio-columns-6' ) {
			$cols = 6;		
		} else {
			$cols = 4;
		} ?>

		<script>		
		jQuery( document ).ready( function( $ ) {

			'use strict';

			$( '#<?php echo $name; ?>' ).prepend( '<i class="loader portfolio-loader fa-spin"><i>' );

			var container = $( '#<?php echo $name; ?>' );
			var element = container;

			if ( container.find( 'img' ).length == 0 ) {
				element = $( 'body' );
			}	

			imagesLoaded( element, function( instance ) {

				container.isotope({
					itemSelector: '.portfolio-loop',
					filter: '*',
					masonry: {
						<?php if ( $type != 'portfolio-masonry' ) { ?>columnWidth: container.width() / <?php echo $cols; ?><?php } ?>
					}
				});

				$( '.portfolio-loader' ).stop( true, true ).fadeOut( 300 );

				container.find( '.portfolio-loop' ).css( 'opacity', 0 );
				container.find( '.portfolio-loop' ).each( function( i ) {
					$( this ).delay( i * 150 ).animate( { 'opacity': 1 }, 350 );
				});
		
			});

			$( '#<?php echo $name; ?>-filters ul li a' ).click( function() {

				var selector = $( this ).attr( 'data-filter' );
				container.isotope( { filter: selector } );

				$( '#<?php echo $name; ?>-filters ul li a' ).removeClass( 'gp-active' );
				$( this ).addClass( 'gp-active' );

				return false;

			});

			$( '#<?php echo $name; ?>-filters > a' ).click( function() {
				return false;
			});

			$( window ).smartresize( function() {
				container.isotope({
					masonry: {
						<?php if ( $type != 'portfolio-masonry' ) { ?>columnWidth: container.width() / <?php echo $cols; ?><?php } ?>
					}
				});
			});


			/*--------------------------------------------------------------
			Remove portfolio filters not found on current page
			--------------------------------------------------------------*/
	
			if ( $( 'div' ).hasClass( 'portfolio-filters' ) ) {
	
				var isotopeCatArr = [];
				var $portfolioCatCount = 0;
				$( '#<?php echo $name; ?>-filters ul li' ).each( function( i ) {
					if ( $( this ).find( 'a' ).length > 0 ) {
						isotopeCatArr[$portfolioCatCount] = $( this ).find( 'a' ).attr( 'data-filter' ).substring( 1 );	
						$portfolioCatCount++;
					}
				});
	
				isotopeCatArr.shift();
	
				var itemCats = '';
	
				$( '#<?php echo $name; ?> > .portfolio-loop' ).each( function( i ) {
					itemCats += $( this ).attr( 'data-portfolio-cat' );
				});
				itemCats = itemCats.split( ' ' );
	
				itemCats.pop();
		
				itemCats = $.unique( itemCats );
	
				var notFoundCats = [];
				$.grep( isotopeCatArr, function( el ) {
					if ( $.inArray(el, itemCats ) == -1 ) {
						notFoundCats.push( el  );
					}
				});
	
				if(notFoundCats.length != 0 ) {
					$( '#<?php echo $name; ?>-filters ul li' ).each( function() {
						if ( $( this ).find( 'a' ).length > 0 ) {
							if( $.inArray( $( this ).find( 'a' ).attr( 'data-filter' ).substring( 1 ), notFoundCats ) != -1 ) {
								$( this ).hide();
							}
						}
					});
				}
			
			}
			
		});			
		</script>		

		<?php

		$output_string = ob_get_contents();
		ob_end_clean(); 
		return $output_string;
	
	}
	
}
	
add_shortcode( 'portfolio', 'gp_portfolio' ); ?>