<?php require( gp_inc . 'options.php' );

/*--------------------------------------------------------------
Convert HEX codes to RGB
--------------------------------------------------------------*/

if ( ! function_exists( 'gp_hex2rgb' ) ) {
	function gp_hex2rgb( $hex ) {
		$hex = str_replace( '#', '', $hex );	
		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ).substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ).substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ).substr( $hex, 2, 1 ) );
			$rgb = array( $r, $g, $b );
			return implode( ',', $rgb );
		} elseif ( strlen( $hex ) > 3 ) {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
			$rgb = array( $r, $g, $b );
			return implode( ',', $rgb );
		} else {}
	}
}


/*--------------------------------------------------------------
Custom Classes
--------------------------------------------------------------*/

if ( !function_exists( 'gp_body_classes' ) ) {
	function gp_body_classes( $classes ) {

		global $gp_settings; require( gp_inc . 'options.php' );

		// Parse Variables To URL	
		if ( isset( $_GET['layout'] ) ) {
			$gp_settings['layout'] = $_GET['layout'];	
		}
	
		$classes[] = 'gp-theme';
		$classes[] = $gp_responsive;
		$classes[] = $gp_smooth_scrolling;
		$classes[] = $gp_back_to_top;
		$classes[] = $gp_fixed_header;	
		$classes[] = $gp_header_resize;	
		$classes[] = $gp_theme_layout;
		$classes[] = $gp_header_layout;
		$classes[] = $gp_settings['layout'];
		if ( is_singular() && ! is_page_template() ) { $classes[] = 'gp-singular'; }
		return $classes;
		
	}
}
add_filter( 'body_class', 'gp_body_classes' );


/*--------------------------------------------------------------
Inline Styling
--------------------------------------------------------------*/
					
$custom_css = '';

$gp_nav_line_height = preg_replace('/[^0-9.]+/', '', $gp_nav_line_height);

$custom_css .= '#logo {margin: ' . $gp_logo_top . 'px ' . $gp_logo_right . 'px ' . $gp_logo_bottom . 'px ' . $gp_logo_left . 'px;}
#logo img {width: ' . $gp_logo_width . 'px; height: ' . $gp_logo_height . 'px;}
#header {height: ' . ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom ) . 'px;}
.gp-header-4 #header {height: ' . ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom + $gp_nav_line_height ) . 'px;}
#header .menu > li > a,#search-button,#cart-button,.mobile-button {line-height: ' . ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom ) . 'px;}
.gp-header-4 #header .menu > li > a,.gp-header-4 #search-button,.gp-header-4 #cart-button,.gp-header-4 .mobile-button {line-height: ' . $gp_nav_line_height . 'px;}
.gp-header-1 #fixed-header-padding {padding-top: ' . ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom ) . 'px;}
.gp-header-3 #fixed-header-padding {padding-top: ' . ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom + $gp_top_header_nav_line_height ) . 'px;}
.gp-header-4 #fixed-header-padding {padding-top: ' . ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom + $gp_nav_line_height ) . 'px;}
@media only screen and (max-width: 982px) {
#logo {margin: ' . ( $gp_logo_top / $gp_header_size_reduction ) . 'px ' . ( $gp_logo_right / $gp_header_size_reduction ) . 'px ' . ( $gp_logo_bottom / $gp_header_size_reduction ) . 'px ' . ( $gp_logo_left / $gp_header_size_reduction ) . 'px!important; width: ' . ( $gp_logo_width / $gp_header_size_reduction ) . 'px; height: ' . ( $gp_logo_height / $gp_header_size_reduction ) . 'px;}
#logo img {width: ' . ( $gp_logo_width / $gp_header_size_reduction ) . 'px; height: ' . ( $gp_logo_height / $gp_header_size_reduction ) . 'px;}
#header {height: ' . ( ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom ) / $gp_header_size_reduction ) . 'px !important;}
#header .menu > li > a,#search-button,#cart-button,.mobile-button {line-height: ' . ( ( $gp_logo_height / $gp_header_size_reduction ) + ( $gp_logo_top / $gp_header_size_reduction ) + ( $gp_logo_bottom / $gp_header_size_reduction ) ) . 'px !important;}
.gp-header-1 #fixed-header-padding, .gp-header-4 #fixed-header-padding {padding-top: ' . ( ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom ) / $gp_header_size_reduction ) . 'px !important;}
.gp-header-3 #fixed-header-padding {padding-top: ' . ( ( ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom ) / $gp_header_size_reduction) + $gp_top_header_nav_line_height ) . 'px!important;}
}';


/*--------------------------------------------------------------
Style Settings
--------------------------------------------------------------*/


/* Page Background Color ************************************/
	
$custom_css .= '#page-wrapper,.search-outer,.gp-theme .vc_text_separator div {background: ' . $gp_bg_color . ';}
.sale-triangle {border-right-color: ' . $gp_bg_color . ';}
.gp-theme .woocommerce div.product .woocommerce-tabs ul.tabs li.active a,.gp-theme .woocommerce #content div.product .woocommerce-tabs ul.tabs li.active a,.gp-theme.woocommerce-page div.product .woocommerce-tabs ul.tabs li.active a,.gp-theme.woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active a {border-bottom-color: ' . $gp_bg_color . ';}';

	
/* Primary Color ************************************/

$custom_css .= 'a,.error,.required,.menu li a:hover,#search-button.gp-active,#search-button:hover,#mobile-nav-button.gp-active,#mobile-nav-button:hover,#mobile-cart-button:hover,.no-thumbnail:hover,.portfolio-filters li a.gp-active,.portfolio-filters li a:hover,.team-name,.gp-theme .woocommerce-info a:hover,.gp-theme .woocommerce div.product span.price,.gp-theme .woocommerce div.product p.price,.gp-theme .woocommerce #content div.product span.price,.gp-theme .woocommerce #content div.product p.price,.gp-theme.woocommerce-page div.product span.price,.gp-theme.woocommerce-page div.product p.price,.gp-theme.woocommerce-page #content div.product span.price,.gp-theme.woocommerce-page #content div.product p.price,.gp-theme .woocommerce ul.products li.product .price,.gp-theme.woocommerce-page ul.products li.product .price,.gp-theme .woocommerce .star-rating span:before,.gp-theme.woocommerce-page .star-rating span:before,.gp-theme.woocommerce-page p.stars a:hover:before,.gp-theme.woocommerce-page p.stars a:focus:before,.gp-theme.woocommerce-page p.stars a.active:before,.gp-theme .woocommerce .added:before,.gp-theme.woocommerce-page .added:before,.gp-theme .woocommerce .order_details li strong,.gp-theme.woocommerce-page .order_details li strong,.gp-theme #buddypress div.activity-meta a:hover,.gp-theme #buddypress div.item-list-tabs ul li.selected a span,.gp-theme #buddypress div.item-list-tabs ul li.current a span {color: ' . $gp_primary_color . ';}
.post-loop.sticky:after,#comments .bypostauthor .avatar {border-color: ' . $gp_primary_color . ' !important;}
.border-triangle {border-left-color: ' . $gp_primary_color . ';}
::selection {background: ' . $gp_primary_color . ';}
::-moz-selection {background: ' . $gp_primary_color . ';}
input[type=button],input[type=submit],input[type=reset],button,.button,blockquote,.meta-tags a,.tagcloud a,.mejs-container .mejs-controls .mejs-time-rail .mejs-time-current,#wp-calendar #today,ul.page-numbers .page-numbers:hover,ul.page-numbers .page-numbers.current,ul.page-numbers.single-nav>span.page-numbers,.prettyphoto:hover:before,#toTop:hover,.gp-theme .woocommerce a.button,.gp-theme .woocommerce button.button,.gp-theme .woocommerce input.button,.gp-theme .woocommerce #respond input#submit,.gp-theme .woocommerce #content input.button,.gp-theme.woocommerce-page a.button,.gp-theme.woocommerce-page button.button,.gp-theme.woocommerce-page input.button,.gp-theme.woocommerce-page #respond input#submit,.gp-theme.woocommerce-page #content input.button,.gp-theme .woocommerce .widget_price_filter .ui-slider .ui-slider-handle,.gp-theme.woocommerce-page .widget_price_filter .ui-slider .ui-slider-handle,.gp-theme #buddypress button,.gp-theme #buddypress a.button,.gp-theme #buddypress input[type=submit],.gp-theme #buddypress input[type=button],.gp-theme #buddypress input[type=reset],.gp-theme #buddypress ul.button-nav li a,.gp-theme #buddypress div.generic-button a,.gp-theme #buddypress .comment-reply-link,a.bp-title-button,.gp-theme #buddypress a.bp-primary-action:hover span,.gp-theme #buddypress #reply-title small a:hover span,.gp-theme #buddypress .activity-list li.load-more a,.gp-theme #buddypress div.item-list-tabs ul li.selected a,.gp-theme #buddypress div.item-list-tabs ul li.current a,.gp-theme #buddypress div.item-list-tabs ul li a span {background: ' . $gp_primary_color . ';}';


/* Secondary Color ************************************/

$custom_css .= 'a:hover,pre,code,.post-loop .entry-header h2 a,.portfolio-loop .entry-header h2 a,.post-loop strong a,.related-portfolios h5 a,.gp-theme .woocommerce ul.products li.product h3,.gp-theme #content .woocommerce ul.products li.product h3,.gp-theme.woocommerce-page ul.products li.product h3,.gp-theme.woocommerce-page #content ul.products li.product h3,.gp-theme .woocommerce table.cart a.remove:hover,.gp-theme .woocommerce #content table.cart a.remove:hover,.gp-theme.woocommerce-page table.cart a.remove:hover,.gp-theme.woocommerce-page #content table.cart a.remove:hover,.gp-theme #buddypress div.activity-meta a,.gp-theme #buddypress .acomment-options a,.gp-theme #buddypress .standard-form div.checkbox label,.gp-theme #buddypress .standard-form div.radio label,.gp-theme .widget.buddypress div.item-title a,.gp-theme .widget.buddypress div.item-options a {color: ' . $gp_secondary_color . ';}
input[type=button]:hover,input[type=submit]:hover,input[type=reset]:hover,button:hover,.button:hover,.meta-tags a:hover,.tagcloud a:hover,ul.page-numbers .page-numbers,.prettyphoto:hover,#toTop,.gp-theme .vc-carousel .vc-carousel-indicators li,.gp-theme .woocommerce-info,.gp-theme .woocommerce a.button:hover,.gp-theme .woocommerce button.button:hover,.gp-theme .woocommerce input.button:hover,.gp-theme .woocommerce #respond input#submit:hover,.gp-theme .woocommerce #content input.button:hover,.gp-theme.woocommerce-page a.button:hover,.gp-theme.woocommerce-page button.button:hover,.gp-theme.woocommerce-page input.button:hover,.gp-theme.woocommerce-page #respond input#submit:hover,.gp-theme.woocommerce-page #content input.button:hover,.gp-theme .woocommerce span.onsale,.gp-theme.woocommerce-page span.onsale,.gp-theme .woocommerce .widget_layered_nav_filters ul li a,.gp-theme.woocommerce-page .widget_layered_nav_filters ul li a,.gp-theme #buddypress button:hover,.gp-theme #buddypress a.button:hover,.gp-theme #buddypress a.button:focus,.gp-theme #buddypress input[type=submit]:hover,.gp-theme #buddypress input[type=button]:hover,.gp-theme #buddypress input[type=reset]:hover,.gp-theme #buddypress ul.button-nav li a:hover,.gp-theme #buddypress ul.button-nav li.current a,.gp-theme #buddypress div.generic-button a:hover,.gp-theme #buddypress .comment-reply-link:hover,.gp-theme #buddypress a.bp-primary-action span,.gp-theme #buddypress #reply-title small a span,.gp-theme #buddypress .activity-list li.load-more a:hover,.gp-theme #buddypress div.item-list-tabs ul li:hover a span {
background: ' . $gp_secondary_color . ';}
.gp-theme .woocommerce .widget_layered_nav ul li.chosen a,.gp-theme.woocommerce-page .widget_layered_nav ul li.chosen a {background-color: ' . $gp_secondary_color . ';}';


/* Primary Text Color ************************************/

$custom_css .= 'body,input,textarea,select,.portfolio-filters li a,.gp-theme .woocommerce .quantity .plus,.gp-theme .woocommerce .quantity .minus,.gp-theme .woocommerce #content .quantity .plus,.gp-theme .woocommerce #content .quantity .minus,.gp-theme.woocommerce-page .quantity .plus,.gp-theme.woocommerce-page .quantity .minus,.gp-theme.woocommerce-page #content .quantity .plus,.gp-theme.woocommerce-page #content .quantity .minus,.gp-theme.woocommerce-page.woocommerce-checkout .chzn-container-single .chzn-single,.gp-theme.woocommerce-page .chosen-container-single .chosen-single,.gp-theme .woocommerce .widget_layered_nav ul small.count,.gp-theme.woocommerce-page .widget_layered_nav ul small.count {color: ' . $gp_primary_text_color . ';}';


/* Secondary Text Color ************************************/

$custom_css .= 'input[type=button],input[type=submit],input[type=reset],button,.button,.button:hover,blockquote,.meta-tags a,.tagcloud a,#wp-calendar #today,#wp-calendar #today a .prettyphoto:hover:before,#toTop,ul.page-numbers .page-numbers,ul.page-numbers .page-numbers:hover,ul.page-numbers .page-numbers.current,ul.page-numbers.single-nav>span.page-numbers,.gp-theme .woocommerce-info,.gp-theme .woocommerce-info:before,.gp-theme .woocommerce a.button,.gp-theme .woocommerce button.button,.gp-theme .woocommerce input.button,.gp-theme .woocommerce #respond input#submit,.gp-theme .woocommerce #content input.button,.gp-theme.woocommerce-page a.button,.gp-theme.woocommerce-page button.button,.gp-theme.woocommerce-page input.button,.gp-theme.woocommerce-page #respond input#submit,.gp-theme.woocommerce-page #content input.button,.gp-theme .woocommerce span.onsale,.gp-theme.woocommerce-page span.onsale,.gp-theme .woocommerce .widget_layered_nav ul li.chosen a,.gp-theme.woocommerce-page .widget_layered_nav ul li.chosen a,.gp-theme #buddypress button,.gp-theme #buddypress a.button,.gp-theme #buddypress input[type=submit],.gp-theme #buddypress input[type=button],.gp-theme #buddypress input[type=reset],.gp-theme #buddypress ul.button-nav li a,.gp-theme #buddypress div.generic-button a,.gp-theme #buddypress .comment-reply-link,a.bp-title-button,.gp-theme #buddypress button:hover,.gp-theme #buddypress a.button:hover,.gp-theme #buddypress a.button:focus,.gp-theme #buddypress input[type=submit]:hover,.gp-theme #buddypress input[type=button]:hover,.gp-theme #buddypress input[type=reset]:hover,.gp-theme #buddypress ul.button-nav li a:hover,.gp-theme #buddypress ul.button-nav li.current a,.gp-theme #buddypress div.generic-button a:hover,.gp-theme #buddypress .comment-reply-link:hover #buddypress a.bp-primary-action span,.gp-theme #buddypress .activity-list li.load-more a,.gp-theme #buddypress div.item-list-tabs ul li.selected a,.gp-theme #buddypress div.item-list-tabs ul li.current a,.gp-theme #buddypress div.item-list-tabs ul li a span {color: ' . $gp_secondary_text_color . ';}
::selection {color: ' . $gp_secondary_text_color . ';}
::-moz-selection {color: ' . $gp_secondary_text_color . ';}';


/* Tertiary Text Color ************************************/

$custom_css .= '.wp-caption-text,.entry-meta,.entry-meta span:before,.entry-meta a,.comment-text .meta,.gp-theme .wpb_accordion .wpb_accordion_wrapper .ui-state-default .ui-icon:before,.gp-theme .wpb_toggle:before,.gp-theme #content h4.wpb_toggle:before,.gp-theme.woocommerce-page .product_meta,.gp-theme #buddypress .activity-list .activity-content .activity-header,.gp-theme #buddypress .activity-list .activity-content .comment-header,.gp-theme #buddypress span.activity,.gp-theme #buddypress a.activity-time-since,.gp-theme .widget.buddypress span.activity {color: ' . $gp_tertiary_text_color . ';}';


/* Alternative Background Color ************************************/

$custom_css .= 'pre,input,textarea,#homepage-slider,.blog-masonry .post-loop,.no-thumbnail,.portfolio-loop,.entry-header.page-header,.gp-theme .woocommerce .quantity .plus,.gp-theme .woocommerce .quantity .minus,.gp-theme .woocommerce #content .quantity .plus,.gp-theme .woocommerce #content .quantity .minus,.gp-theme.woocommerce-page .quantity .plus,.gp-theme.woocommerce-page .quantity .minus,.gp-theme.woocommerce-page #content .quantity .plus,.gp-theme.woocommerce-page #content .quantity .minus,.gp-theme .woocommerce div.product .woocommerce-tabs ul.tabs li a,.gp-theme .woocommerce #content div.product .woocommerce-tabs ul.tabs li a,.gp-theme.woocommerce-page div.product .woocommerce-tabs ul.tabs li a,.gp-theme.woocommerce-page #content div.product .woocommerce-tabs ul.tabs li a,.gp-theme.woocommerce-page.woocommerce-checkout .chzn-container-single .chzn-single,.gp-theme.woocommerce-page .chosen-container-single .chosen-single,.gp-theme.woocommerce-page.woocommerce-checkout .chzn-container .chzn-drop,.gp-theme.woocommerce-page .chosen-container .chosen-drop,.gp-theme.woocommerce-page.woocommerce-checkout .chzn-container-single .chzn-search input,.gp-theme.woocommerce-page .chosen-container-single .chosen-search input,.gp-theme #buddypress ul.item-list li,.gp-theme #buddypress div.item-list-tabs,.gp-theme #buddypress div.item-list-tabs ul li.selected a span,.gp-theme #buddypress div.item-list-tabs ul li.current a span,.gp-theme #buddypress .standard-form textarea,.gp-theme #buddypress .standard-form input[type=text],.gp-theme #buddypress .standard-form input[type=text],.gp-theme #buddypress .standard-form input[type=color],.gp-theme #buddypress .standard-form input[type=date],.gp-theme #buddypress .standard-form input[type=datetime],.gp-theme #buddypress .standard-form input[type=datetime-local],.gp-theme #buddypress .standard-form input[type=email],.gp-theme #buddypress .standard-form input[type=month],.gp-theme #buddypress .standard-form input[type=number],.gp-theme #buddypress .standard-form input[type=range],.gp-theme #buddypress .standard-form input[type=search],.gp-theme #buddypress .standard-form input[type=tel],.gp-theme #buddypress .standard-form input[type=time],.gp-theme #buddypress .standard-form input[type=url],.gp-theme #buddypress .standard-form input[type=week],.gp-theme #buddypress .standard-form input[type=password],.gp-theme #buddypress .standard-form input:focus,.gp-theme #buddypress .standard-form textarea:focus,.gp-theme #buddypress .standard-form select:focus,.gp-theme #buddypress .dir-search input[type=search],.gp-theme #buddypress .dir-search input[type=text],.gp-theme #buddypress form#whats-new-form textarea,.gp-theme #buddypress div.activity-comments form .ac-textarea,#bbpress-forums li.bbp-header,#bbpress-forums div.odd,#bbpress-forums ul.odd,#bbpress-forums li.bbp-header,#bbpress-forums li.bbp-footer,#bbpress-forums div.bbp-forum-header,#bbpress-forums div.bbp-topic-header,#bbpress-forums div.bbp-reply-header {background: ' . $gp_alt_bg_color . ';}
select,.gp-theme #buddypress .standard-form select {background-color: ' . $gp_alt_bg_color . ';}';


/* Border Color ************************************/

$custom_css .= 'input,textarea,select,fieldset,.search-outer,.post-loop,.entry-header.post-header,.entry-header.page-header,.author-info,.related-posts,.related-portfolios,#comments,#comments ol.commentlist li .comment_container,#new-search,.portfolio-filters,.widget ul li,.gp-theme .wpb_separator,.gp-theme .vc_text_separator,.gp-theme .vc_separator .vc_sep_holder .vc_sep_line,.gp-theme .woocommerce .quantity .plus,.gp-theme .woocommerce .quantity .minus,.gp-theme .woocommerce #content .quantity .plus,.gp-theme .woocommerce #content .quantity .minus,.gp-theme.woocommerce-page .quantity .plus,.gp-theme.woocommerce-page .quantity .minus,.gp-theme.woocommerce-page #content .quantity .plus,.gp-theme.woocommerce-page #content .quantity .minus,.gp-theme .woocommerce .quantity input.qty,.gp-theme .woocommerce #content .quantity input.qty,.gp-theme.woocommerce-page .quantity input.qty,.gp-theme.woocommerce-page #content .quantity input.qty,.gp-theme .woocommerce div.product .woocommerce-tabs ul.tabs:before,.gp-theme .woocommerce #content div.product .woocommerce-tabs ul.tabs:before,.gp-theme.woocommerce-page div.product .woocommerce-tabs ul.tabs:before,.gp-theme.woocommerce-page #content div.product .woocommerce-tabs ul.tabs:before,.gp-theme .woocommerce div.product .woocommerce-tabs ul.tabs li a,.gp-theme .woocommerce #content div.product .woocommerce-tabs ul.tabs li a,.gp-theme.woocommerce-page div.product .woocommerce-tabs ul.tabs li a,.gp-theme.woocommerce-page #content div.product .woocommerce-tabs ul.tabs li a,#main-nav .dropdowncart li .total,#main-nav .dropdowncart li .dropdowncart-buttons,.gp-theme .woocommerce table.shop_table td,.gp-theme.woocommerce-page table.shop_table td,.gp-theme .woocommerce .cart-collaterals .cart_totals tr td,.gp-theme .woocommerce .cart-collaterals .cart_totals tr th,.gp-theme.woocommerce-page .cart-collaterals .cart_totals tr td,.gp-theme.woocommerce-page .cart-collaterals .cart_totals tr th,.gp-theme.woocommerce-page.woocommerce-checkout .chzn-container-single .chzn-single,.gp-theme.woocommerce-page .chosen-container-single .chosen-single,.gp-theme.woocommerce-page.woocommerce-checkout .chzn-container .chzn-drop,.gp-theme.woocommerce-page .chosen-container .chosen-drop,.gp-theme.woocommerce-page.woocommerce-checkout .chzn-container-single .chzn-search input,.gp-theme.woocommerce-page .chosen-container-single .chosen-search input,.gp-theme .woocommerce form .form-row textarea,.gp-theme.woocommerce-page form .form-row textarea,.gp-theme .woocommerce table.shop_table tfoot td,.gp-theme .woocommerce table.shop_table tfoot th,.gp-theme.woocommerce-page table.shop_table tfoot td,.gp-theme.woocommerce-page table.shop_table tfoot th,.gp-responsive #sidebar,.gp-theme #buddypress .standard-form textarea,.gp-theme #buddypress .standard-form input[type=text],.gp-theme #buddypress .standard-form input[type=text],.gp-theme #buddypress .standard-form input[type=color],.gp-theme #buddypress .standard-form input[type=date],.gp-theme #buddypress .standard-form input[type=datetime],.gp-theme #buddypress .standard-form input[type=datetime-local],.gp-theme #buddypress .standard-form input[type=email],.gp-theme #buddypress .standard-form input[type=month],.gp-theme #buddypress .standard-form input[type=number],.gp-theme #buddypress .standard-form input[type=range],.gp-theme #buddypress .standard-form input[type=search],.gp-theme #buddypress .standard-form input[type=tel],.gp-theme #buddypress .standard-form input[type=time],.gp-theme #buddypress .standard-form input[type=url],.gp-theme #buddypress .standard-form input[type=week],.gp-theme #buddypress .standard-form select,.gp-theme #buddypress .standard-form input[type=password],.gp-theme #buddypress .dir-search input[type=search],.gp-theme #buddypress .dir-search input[type=text],.gp-theme #buddypress div.activity-comments form .ac-textarea,#bbpress-forums ul.bbp-lead-topic,#bbpress-forums ul.bbp-topics,#bbpress-forums ul.bbp-forums,#bbpress-forums ul.bbp-replies,#bbpress-forums ul.bbp-search-results,#bbpress-forums li.bbp-header,#bbpress-forums li.bbp-footer,#bbpress-forums li.bbp-ul.forum,#bbpress-forums li.bbp-ul.topic,#bbpress-forums .bbp-forums-list,#bbpress-forums li.bbp-body ul.forum,#bbpress-forums li.bbp-body ul.topic div.bbp-forum-header,div.bbp-topic-header,div.bbp-reply-header {border-color: ' . $gp_border_color . ';}
@media only screen and (max-width: 320px) {.gp-responsive.gp-theme .woocommerce div.product .woocommerce-tabs ul.tabs li.active a,.gp-responsive.gp-theme .woocommerce #content div.product .woocommerce-tabs ul.tabs li.active a,.gp-responsive.gp-theme.woocommerce-page div.product .woocommerce-tabs ul.tabs li.active a,.gp-responsive.gp-theme.woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active a {border-color: ' . $gp_border_color . ';}}
hr,.gp-theme .woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content,.gp-theme.woocommerce-page .widget_price_filter .price_slider_wrapper .ui-widget-content {background: ' . $gp_border_color . ';}';


/* Header ************************************/

$custom_css .= '#header {background: ' . $gp_header_bg_color . ';}.gp-header-2 #header.header-small {background:' . $gp_header_bg_color . ';background: rgba(' . gp_hex2rgb( $gp_header_bg_color ) . ', 0.9);}
.cart-count {color: ' . $gp_header_text_color . ';}
#header .nav .menu>li>a,#header .nav>.menu>li.fa:before,#search-button,#mobile-nav-button,#mobile-cart-button{color: ' . $gp_header_link_color . ';}
#header .nav .menu>li:hover>a,#header .nav .menu>li.current-menu-item>a,#header .nav .menu>li.fa:hover:before,#header .nav .menu>li.current-menu-item.fa:before,#mobile-nav .menu li a:hover,#search-button.gp-active,#search-button:hover,#mobile-nav-button.gp-active,#mobile-nav-button:hover{color: ' . $gp_header_link_hover_color . ';}
.cart-count{background-color: ' . $gp_header_link_hover_color . ';}';


/* Header Dropdown Menus ************************************/

$custom_css .= '#header .nav .sub-menu,#mobile-nav {background: ' . $gp_header_dropdown_bg_color . ';}
#header .nav .menu li.megamenu>.sub-menu>li>a,#header .nav .menu li.megamenu>.sub-menu>li.fa:before,#mobile-nav .menu li.megamenu>.sub-menu>li>a {color: ' . $gp_header_dropdown_heading_color . ';}
#header .nav .sub-menu li a:hover,#mobile-nav .menu li a:hover {color: ' . $gp_header_dropdown_link_hover_color . ';}
#header .nav .sub-menu a,#header .nav .sub-menu li.fa:before, #mobile-nav .menu li a, #mobile-nav .menu li.fa:before {color: ' . $gp_header_dropdown_link_color . ';}
#header .nav .sub-menu a:hover {background: ' . $gp_header_dropdown_bg_hover_color . ';}
#header .nav .sub-menu,#header .nav .sub-menu a,#header .nav .menu li.megamenu>.sub-menu>li,#mobile-nav,#mobile-nav .menu li a {border-color: ' . $gp_header_dropdown_border_color . ';}';


/* Top Header ************************************/

$custom_css .= '#top-header {background: ' . $gp_top_header_bg_color . ';}
#top-nav .menu>li:before {color: ' . $gp_top_header_text_color . ';}
#top-header .nav .menu>li>a,#top-header.nav>.menu>li.fa:before,#top-header .social-icons a {color: ' . $gp_top_header_link_color . ';}
#top-header .nav .menu>li:hover>a,#top-header.nav .menu>li.current-menu-item>a,#top-header.nav .menu>li.fa:hover:before,#top-header .nav .menu>li.current-menu-item.fa:before,#top-header .social-icons a:hover {color: ' . $gp_top_header_link_hover_color . ';}';


/* Top Header Dropdown Menus ************************************/

$custom_css .= '#top-header .nav .sub-menu {background: ' . $gp_top_header_dropdown_bg_color . ';}
#top-header .nav .menu li.megamenu>.sub-menu>li>a,#top-header .nav .menu li.megamenu>.sub-menu>li.fa:before {color: ' . $gp_top_header_dropdown_heading_color . ';}
#top-header .nav .sub-menu li a:hover {color: ' . $gp_top_header_dropdown_link_hover_color . ';}
#top-header .nav .sub-menu a,#top-header .nav .sub-menu li.fa:before {color: ' . $gp_top_header_dropdown_link_color . ';}
#top-header .nav .sub-menu a:hover {background: ' . $gp_top_header_dropdown_bg_hover_color . ';}
#top-header .nav .sub-menu,#top-header .nav .sub-menu a,#top-header .nav .menu li.megamenu>.sub-menu>li {border-color: ' . $gp_top_header_dropdown_border_color . ';}';


/* Footer ************************************/

$custom_css .= '#footer-widgets {background: ' . $gp_footer_bg_color . ';}
#footer-widgets .widgettitle {color: ' . $gp_footer_heading_color . ';}
#footer-widgets {color: ' . $gp_footer_text_color . ';}
#footer-widgets a {color: ' . $gp_footer_link_color . ';}
#footer-widgets a:hover {color: ' . $gp_footer_link_hover_color . ';}';


/* Bottom Footer ************************************/

$custom_css .= '#footer-bottom {background: ' . $gp_bottom_footer_bg_color . ';}
#footer-bottom {color: ' . $gp_bottom_footer_text_color . ';}
#footer-bottom a {color: ' . $gp_bottom_footer_link_color . ';}
#footer-bottom a:hover {color: ' . $gp_bottom_footer_link_hover_color . ';}';


/* Fonts ************************************/

// Primary Font
if ( $gp_primary_font != 'Open Sans' ) {	
	$gp_primary_font = preg_replace( '/[+]/', ' ', $gp_primary_font );	
	$custom_css .= 'body {font-family: "' . $gp_primary_font . '";}';
}
if ( $gp_primary_font_size != '13px' ) {		
	$custom_css .= 'body {font-size: ' . $gp_primary_font_size . ';}';
}
if ( $gp_primary_line_height != '1.7em' ) {		
	$custom_css .= 'body {line-height: ' . $gp_primary_line_height . ';}';
}
if ( $gp_primary_font_weight != '400' ) {		
	$custom_css .= 'body {font-weight: ' . $gp_primary_font_weight . ';}';
}

// Header Navigation
if ( $gp_nav_font != 'Open Sans' ) {	
	$gp_nav_font = preg_replace( '/[+]/', ' ', $gp_nav_font );	
	$custom_css .= '#header .nav .menu > li > a {font-family: "' . $gp_nav_font . '";}';
}
if ( $gp_nav_font_size != '12px' ) {		
	$custom_css .= '#header .nav .menu > li > a {font-size: ' . $gp_nav_font_size . ';}';
}
if ( $gp_nav_font_weight != '400' ) {		
	$custom_css .= '#header .nav .menu > li > a {font-weight: ' . $gp_nav_font_weight . ';}';
}

// Top Header Navigation
if ( $gp_top_header_nav_font != 'Open Sans' ) {		
	$gp_top_header_nav_font = preg_replace( '/[+]/', ' ', $gp_top_header_nav_font );
	$custom_css .= '#top-header .nav .menu > li > a, #top-nav .menu>li:before {font-family: "' . $gp_top_header_nav_font . '";}';
}
if ( $gp_top_header_nav_font_size != '11px' ) {		
	$custom_css .= '#top-header .nav .menu > li > a, #top-nav .menu>li:before, #top-header .social-icons a {font-size: ' . $gp_top_header_nav_font_size . ';}';
}
if ( $gp_top_header_nav_line_height != '29px' ) {		
	$custom_css .= '#top-header .nav .menu > li, #top-nav .menu>li:before, #top-header .social-icons a {line-height: ' . $gp_top_header_nav_line_height . ';} #top-header {height:  ' . $gp_top_header_nav_line_height . ';} .gp-header-3.gp-fixed-header #header {margin-top:  ' . $gp_top_header_nav_line_height . ';} #top-header .nav .sub-menu {top:  ' . $gp_top_header_nav_line_height . ';}';
}
if ( $gp_top_header_nav_font_weight != '400' ) {		
	$custom_css .= '#top-header .nav .menu > li > a, #top-nav .menu>li:before {font-weight: ' . $gp_top_header_nav_font_weight . ';}';
}

// H1 Heading
if ( $gp_h1_font != 'Open Sans' ) {		
	$gp_h1_font = preg_replace( '/[+]/', ' ', $gp_h1_font );
	$custom_css .= 'h1 {font-family: "' . $gp_h1_font . '";}';
}
if ( $gp_h1_font_size != '36px' ) {		
	$custom_css .= 'h1 {font-size: ' . $gp_h1_font_size . ';}';
}
if ( $gp_h1_line_height != '46px' ) {		
	$custom_css .= 'h1 {line-height: ' . $gp_h1_line_height . ';}';
}
if ( $gp_h1_font_weight != '100' ) {		
	$custom_css .= 'h1 {font-weight: ' . $gp_h1_font_weight . ';}';
}

// H2 Heading
if ( $gp_h2_font != 'Open Sans' ) {	
	$gp_h2_font = preg_replace( '/[+]/', ' ', $gp_h2_font );	
	$custom_css .= 'h2,.gp-theme .loop-title {font-family: "' . $gp_h2_font . '";}';
}
if ( $gp_h2_font_size != '22px' ) {		
	$custom_css .= 'h2,.gp-theme .loop-title {font-size: ' . $gp_h2_font_size . ';}';
}
if ( $gp_h2_line_height != '32px' ) {		
	$custom_css .= 'h2,.gp-theme .loop-title {line-height: ' . $gp_h2_line_height . ';}';
}
if ( $gp_h2_font_weight != '100' ) {		
	$custom_css .= 'h2,.gp-theme .loop-title {font-weight: ' . $gp_h2_font_weight . ';}';
}

// H3 Heading
if ( $gp_h3_font != 'Open Sans' ) {		
	$gp_h3_font = preg_replace( '/[+]/', ' ', $gp_h3_font );	
	$custom_css .= 'h3 {font-family: "' . $gp_h3_font . '";}';
}
if ( $gp_h3_font_size != '20px' ) {		
	$custom_css .= 'h3 {font-size: ' . $gp_h3_font_size . ';}';
}
if ( $gp_h3_line_height != '30px' ) {		
	$custom_css .= 'h3 {line-height: ' . $gp_h3_line_height . ';}';
}
if ( $gp_h3_font_weight != '100' ) {		
	$custom_css .= 'h3 {font-weight: ' . $gp_h3_font_weight . ';}';
}

// H4 Heading
if ( $gp_h4_font != 'Open Sans' ) {	
	$gp_h4_font = preg_replace( '/[+]/', ' ', $gp_h4_font );		
	$custom_css .= 'h4 {font-family: "' . $gp_h4_font . '";}';
}
if ( $gp_h4_font_size != '18px' ) {		
	$custom_css .= 'h4 {font-size: ' . $gp_h4_font_size . ';}';
}
if ( $gp_h4_line_height != '22px' ) {		
	$custom_css .= 'h4 {line-height: ' . $gp_h4_line_height . ';}';
}
if ( $gp_h4_font_weight != '100' ) {		
	$custom_css .= 'h4 {font-weight: ' . $gp_h4_font_weight . ';}';
}

// H5 Heading
if ( $gp_h5_font != 'Open Sans' ) {	
	$gp_h5_font = preg_replace( '/[+]/', ' ', $gp_h5_font );		
	$custom_css .= 'h5 {font-family: "' . $gp_h5_font . '";}';
}
if ( $gp_h5_font_size != '16px' ) {		
	$custom_css .= 'h5 {font-size: ' . $gp_h5_font_size . ';}';
}
if ( $gp_h5_line_height != '20px' ) {		
	$custom_css .= 'h5 {line-height: ' . $gp_h5_line_height . ';}';
}
if ( $gp_h5_font_weight != '100' ) {		
	$custom_css .= 'h5 {font-weight: ' . $gp_h5_font_weight . ';}';
}

// H6 Heading
if ( $gp_h6_font != 'Open Sans' ) {	
	$gp_h6_font = preg_replace( '/[+]/', ' ', $gp_h6_font );		
	$custom_css .= 'h6 {font-family: "' . $gp_h6_font . '";}';
}
if ( $gp_h6_font_size != '14px' ) {		
	$custom_css .= 'h6 {font-size: ' . $gp_h6_font_size . ';}';
}
if ( $gp_h6_line_height != '18px' ) {		
	$custom_css .= 'h6 {line-height: ' . $gp_h6_line_height . ';}';
}
if ( $gp_h6_font_weight != '100' ) {		
	$custom_css .= 'h6 {font-weight: ' . $gp_h6_font_weight . ';}';
}


/* Widths ************************************/

// Desktop
if ( $gp_page_width_1 != "1040" OR $gp_content_width_1 != "700" OR $gp_sidebar_width_1 != "300") {
	$custom_css .= '@media only screen and (min-width: 1083px) {';
		if ( $gp_page_width_1 != "1040") {
			$custom_css .= '.gp-boxed-layout #page-wrapper,.gp-boxed-layout #header,.container,.vc_span12.wpb_column > .wpb_wrapper > .wpb_row {width: ' . $gp_page_width_1 . 'px;}';
		}	
		if ( $gp_content_width_1 != "700") {
			$custom_css .= '.gp-responsive #content {width: ' . $gp_content_width_1 . 'px;}';
		}	
		if ( $gp_sidebar_width_1 != "300") {
			$custom_css .= '.gp-responsive #sidebar {width: ' . $gp_sidebar_width_1 . 'px;}';
		}	
	$custom_css .= '}';
	
}	

if ( $gp_page_width_2 != "940" OR $gp_content_width_2 != "700" OR $gp_sidebar_width_2 != "200") {
	$custom_css .= '@media only screen and (max-width: 1082px) and (min-width: 983px) {';
		if ( $gp_page_width_2 != "940") {	
			$custom_css .= '.gp-responsive.gp-boxed-layout #page-wrapper,.gp-responsive.gp-boxed-layout #header,.gp-responsive .container,.gp-responsive .vc_span12.wpb_column > .wpb_wrapper > .wpb_row {width: ' . $gp_page_width_2 . 'px;}';
		}	
		if ( $gp_content_width_2 != "700") {
			$custom_css .= '.gp-responsive #content {width: ' . $gp_content_width_2 . 'px;}';
		}
		if ( $gp_sidebar_width_2 != "200") {
			$custom_css .= '.gp-responsive #sidebar {width: ' . $gp_sidebar_width_2 . 'px;}';
		}	
	$custom_css .= '}';
}

if ( $gp_page_width_3 != "700" OR $gp_content_width_3 != "480" OR $gp_sidebar_width_3 != "180") {
	$custom_css .= '@media only screen and (max-width: 982px) and (min-width: 768px) {';
		if ( $gp_page_width_3 != "700") {
			$custom_css .= '.gp-responsive.gp-boxed-layout #page-wrapper,.gp-responsive.gp-boxed-layout #header,.gp-responsive .container,.gp-responsive .vc_span12.wpb_column > .wpb_wrapper > .wpb_row {width: ' . $gp_page_width_3 . 'px;}';
		}
		if ( $gp_content_width_3 != "480") {
			$custom_css .= '.gp-responsive #content {width: ' . $gp_content_width_3 . 'px;}';
		}
		if ( $gp_sidebar_width_3 != "180") {
			$custom_css .= '.gp-responsive #sidebar {width: ' . $gp_sidebar_width_3 . 'px;}';
		}
	$custom_css .= '}';
}
	

/*--------------------------------------------------------------
Custom CSS
--------------------------------------------------------------*/

if ( $gp_custom_css ) {
	$custom_css .= stripslashes( $gp_custom_css );
}

if ( !empty($custom_css ) ) {
	echo '<style>' . $custom_css . '</style>';
}

?>