<?php require( gp_inc . 'options.php' ); global $gp_settings;

/*-----------------------------------------------------------------------------------

1. WooCommerce Shop Page
2. WooCommerce Products
3. BuddyPress
4. bbPress
5. Portfolio Categories
6. Portfolio Page Template
7. Portfolio Items
8. Post Categories, Archives, Tags, Search & Author Pages
9. Posts
10. 404 & Attachment Pages
11. Homepage Page Template
12. Page & Custom Post Types

-----------------------------------------------------------------------------------*/


/*--------------------------------------------------------------
1 - WooCommerce Shop Page
--------------------------------------------------------------*/

if ( function_exists( 'is_woocommerce' ) && (is_shop() OR is_product_category() OR is_product_tag() ) ) {

	if( is_shop() ) {
		$gp_post_id = get_option( 'woocommerce_shop_page_id' ); 
	} else {
		$gp_post_id = get_the_ID();
	}
		
	// Page Layout
	if ( get_post_meta( $gp_post_id, '_gp_layout', true ) && get_post_meta( $gp_post_id, '_gp_layout', true ) != 'default' ) {
		$gp_settings['layout'] = get_post_meta( $gp_post_id, '_gp_layout', true );
	} else {
		$gp_settings['layout'] = $gp_shop_layout;
	}
				
	// Sidebar
	if ( get_post_meta( $gp_post_id, '_gp_sidebar', true ) && get_post_meta( $gp_post_id, '_gp_sidebar', true ) != 'default' ) {
		$gp_settings['sidebar'] = get_post_meta( $gp_post_id, '_gp_sidebar', true );
	} else {
		$gp_settings['sidebar'] = $gp_shop_sidebar;
	}
	
	// Page Title Header
	if ( get_post_meta( $gp_post_id, '_gp_title_header', true ) && get_post_meta( $gp_post_id, '_gp_title_header', true ) != 'default' ) {
		$gp_settings['title_header'] = get_post_meta( $gp_post_id, '_gp_title_header', true );
	} else {
		$gp_settings['title_header'] = $gp_shop_title_header;
	}	

	// Page Title Image
	if ( get_post_meta( $gp_post_id, '_gp_title_header_image', true ) && get_post_meta( $gp_post_id, '_gp_title_header_image', true ) != 'default' ) {
		$gp_settings['title_image'] = get_post_meta( $gp_post_id, '_gp_title_header_image', true );
	} else {
		$gp_settings['title_image'] = $gp_shop_title_header_image;
	}	

	// Page Title Color
	if ( get_post_meta( $gp_post_id, '_gp_title_header_color', true ) && get_post_meta( $gp_post_id, '_gp_title_header_color', true ) != '' ) {
		$gp_settings['title_color'] = get_post_meta( $gp_post_id, '_gp_title_header_color', true );
	} else {
		$gp_settings['title_color'] = $gp_shop_title_header_color;
	}	
		
	// Page Title Padding
	if ( get_post_meta( $gp_post_id, '_gp_title_header_padding', true ) && get_post_meta( $gp_post_id, '_gp_title_header_padding', true ) != 'default' ) {
		$gp_settings['title_padding'] = get_post_meta( $gp_post_id, '_gp_title_header_padding', true );
	} else {
		$gp_settings['title_padding'] = $gp_shop_title_header_padding;
	}	

	// Parallax Page Title
	if ( get_post_meta( $gp_post_id, '_gp_title_header_parallax', true ) && get_post_meta( $gp_post_id, '_gp_title_header_parallax', true ) != 'default' ) {
		$gp_settings['title_parallax'] = get_post_meta( $gp_post_id, '_gp_title_header_parallax', true );
	} else {
		$gp_settings['title_parallax'] = $gp_shop_title_header_parallax;
	}	

		
/*--------------------------------------------------------------
2 - WooCommerce Products
--------------------------------------------------------------*/

} elseif ( function_exists( 'is_woocommerce' ) && is_singular( 'product' ) ) {

	// Page Layout
	if ( get_post_meta( get_the_ID(), '_gp_layout', true ) && get_post_meta( get_the_ID(), '_gp_layout', true ) != 'default' ) {
		$gp_settings['layout'] = get_post_meta( get_the_ID(), '_gp_layout', true );
	} else {
		$gp_settings['layout'] = $gp_product_layout;
	}
				
	// Sidebar
	if ( get_post_meta( get_the_ID(), '_gp_sidebar', true ) && get_post_meta( get_the_ID(), '_gp_sidebar', true ) != 'default' ) {
		$gp_settings['sidebar'] = get_post_meta( get_the_ID(), '_gp_sidebar', true );
	} else {
		$gp_settings['sidebar'] = $gp_product_sidebar;
	}


/*--------------------------------------------------------------
3 - BuddyPress
--------------------------------------------------------------*/

} elseif ( function_exists( 'bp_is_active' ) && ! bp_is_blog_page() ) {

	$gp_settings['layout'] = $gp_bp_layout;
	$gp_settings['sidebar'] = $gp_bp_sidebar;
	$gp_settings['title_header'] = $gp_bp_title_header;
	$gp_settings['title_image'] = $gp_bp_title_header_image;
	$gp_settings['title_color'] = $gp_bp_title_header_color;
	$gp_settings['title_padding'] = $gp_bp_title_header_padding;
	$gp_settings['title_parallax'] = $gp_bp_title_header_parallax;	
		

/*--------------------------------------------------------------
4 - bbPress
--------------------------------------------------------------*/

} elseif ( function_exists( 'is_bbpress' ) && is_bbpress() ) {

	$gp_settings['layout'] = $gp_bbpress_layout;
	$gp_settings['sidebar'] = $gp_bbpress_sidebar;
	$gp_settings['title_header'] = $gp_bp_title_header;
	$gp_settings['title_image'] = $gp_bp_title_header_image;
	$gp_settings['title_color'] = $gp_bp_title_header_color;
	$gp_settings['title_padding'] = $gp_bp_title_header_padding;
	$gp_settings['title_parallax'] = $gp_bp_title_header_parallax;
	

/*--------------------------------------------------------------
5 - Portfolio Categories
--------------------------------------------------------------*/


} elseif ( is_post_type_archive( 'gp_portfolio_item' ) OR is_tax( 'gp_portfolios' ) )  {

	$gp_settings['layout'] = $gp_portfolio_cat_layout;
	$gp_settings['sidebar'] = $gp_portfolio_cat_sidebar;
	$gp_settings['filter'] = $gp_portfolio_cat_filter;
	$gp_settings['portfolio_type'] = $gp_portfolio_cat_type;
	$gp_settings['per_page'] = $gp_portfolio_cat_per_page;	
	$gp_settings['title_header'] = $gp_portfolio_cat_title_header;
	$gp_settings['title_image'] = $gp_portfolio_cat_title_header_image;
	$gp_settings['title_color'] = $gp_portfolio_cat_title_header_color;
	$gp_settings['title_padding'] = $gp_portfolio_cat_title_header_padding;
	$gp_settings['title_parallax'] = $gp_portfolio_cat_title_header_parallax;		
	

/*--------------------------------------------------------------
6 - Portfolio Page Template
--------------------------------------------------------------*/


} elseif ( is_page_template( 'portfolio.php' ) )  {

	// Page Layout
	if ( get_post_meta( get_the_ID(), '_gp_layout', true ) && get_post_meta( get_the_ID(), '_gp_layout', true ) != 'default' ) {
		$gp_settings['layout'] = get_post_meta( get_the_ID(), '_gp_layout', true );
	} else {
		$gp_settings['layout'] = $gp_portfolio_cat_layout;
	}
				
	// Sidebar
	if ( get_post_meta( get_the_ID(), '_gp_sidebar', true ) && get_post_meta( get_the_ID(), '_gp_sidebar', true ) != 'default' ) {
		$gp_settings['sidebar'] = get_post_meta( get_the_ID(), '_gp_sidebar', true );
	} else {
		$gp_settings['sidebar'] = $gp_portfolio_cat_sidebar;
	}	

	// Page Title Header
	if ( get_post_meta( get_the_ID(), '_gp_title_header', true ) && get_post_meta( get_the_ID(), '_gp_title_header', true ) != 'default' ) {
		$gp_settings['title_header'] = get_post_meta( get_the_ID(), '_gp_title_header', true );
	} else {
		$gp_settings['title_header'] = $gp_portfolio_cat_title_header;
	}	

	// Page Title Image
	if ( get_post_meta( get_the_ID(), '_gp_title_header_image', true ) && get_post_meta( get_the_ID(), '_gp_title_header_image', true ) != 'default' ) {
		$gp_settings['title_image'] = get_post_meta( get_the_ID(), '_gp_title_header_image', true );
	} else {
		$gp_settings['title_image'] = $gp_portfolio_cat_title_header_image;
	}	

	// Page Title Color
	if ( get_post_meta( get_the_ID(), '_gp_title_header_color', true ) && get_post_meta( get_the_ID(), '_gp_title_header_color', true ) != '' ) {
		$gp_settings['title_color'] = get_post_meta( get_the_ID(), '_gp_title_header_color', true );
	} else {
		$gp_settings['title_color'] = $gp_portfolio_cat_title_header_color;
	}	
		
	// Page Title Padding
	if ( get_post_meta( get_the_ID(), '_gp_title_header_padding', true ) && get_post_meta( get_the_ID(), '_gp_title_header_padding', true ) != 'default' ) {
		$gp_settings['title_padding'] = get_post_meta( get_the_ID(), '_gp_title_header_padding', true );
	} else {
		$gp_settings['title_padding'] = $gp_portfolio_cat_title_header_padding;
	}	

	// Parallax Page Title
	if ( get_post_meta( get_the_ID(), '_gp_title_header_parallax', true ) && get_post_meta( get_the_ID(), '_gp_title_header_parallax', true ) != 'default' ) {
		$gp_settings['title_parallax'] = get_post_meta( get_the_ID(), '_gp_title_header_parallax', true );
	} else {
		$gp_settings['title_parallax'] = $gp_portfolio_cat_title_header_parallax;
	}

	$gp_settings['filter'] = $gp_portfolio_cat_filter;
	$gp_settings['portfolio_type'] = $gp_portfolio_cat_type;
	$gp_settings['per_page'] = $gp_portfolio_cat_per_page;		
			

/*--------------------------------------------------------------
7 - Portfolio Items
--------------------------------------------------------------*/


} elseif ( is_singular( 'gp_portfolio_item' ) ) {

	// Page Layout
	if ( get_post_meta( get_the_ID(), '_gp_layout', true ) && get_post_meta( get_the_ID(), '_gp_layout', true ) != 'default' ) {
		$gp_settings['layout'] = get_post_meta( get_the_ID(), '_gp_layout', true );
	} else {
		$gp_settings['layout'] = $gp_portfolio_item_layout;
	}
				
	// Sidebar
	if ( get_post_meta( get_the_ID(), '_gp_sidebar', true ) && get_post_meta( get_the_ID(), '_gp_sidebar', true ) != 'default' ) {
		$gp_settings['sidebar'] = get_post_meta( get_the_ID(), '_gp_sidebar', true );
	} else {
		$gp_settings['sidebar'] = $gp_portfolio_item_sidebar;
	}
	
	// Image/Slider Type
	if ( get_post_meta( get_the_ID(), '_gp_type', true ) && get_post_meta( get_the_ID(), '_gp_type', true ) != 'default' ) {
		$gp_settings['type'] = get_post_meta( get_the_ID(), '_gp_type', true );
	} else {
		$gp_settings['type'] = $gp_portfolio_item_type;
	}
	
	// Image Dimensions
	if ( get_post_meta( get_the_ID(), '_gp_image_width', true ) && get_post_meta( get_the_ID(), '_gp_image_width', true ) != '' ) {
		$gp_settings['image_width'] = get_post_meta( get_the_ID(), '_gp_image_width', true );
	} else {
		$gp_settings['image_width'] = $gp_portfolio_item_image_width;
	}
	if ( get_post_meta( get_the_ID(), '_gp_image_height', true ) != '' ) {
		$gp_settings['image_height'] = get_post_meta( get_the_ID(), '_gp_image_height', true );
	} else {
		$gp_settings['image_height'] = $gp_portfolio_item_image_height;
	}

	// Hard Crop
	if ( get_post_meta( get_the_ID(), '_gp_hard_crop', true ) && get_post_meta( get_the_ID(), '_gp_hard_crop', true ) != 'default' ) {
		$gp_settings['hard_crop'] = get_post_meta( get_the_ID(), '_gp_hard_crop', true );
	} else {
		$gp_settings['hard_crop'] = $gp_portfolio_item_hard_crop;
	}
	if ( $gp_settings['hard_crop'] == 'enable' ) { $gp_settings['hard_crop'] = true; } else { $gp_settings['hard_crop'] = false; }	

	// Link Target
	if ( get_post_meta( get_the_ID(), '_gp_link_target', true ) && get_post_meta( get_the_ID(), '_gp_link_target', true ) != 'default' ) {
		$gp_settings['link_target'] = get_post_meta( get_the_ID(), '_gp_link_target', true );
	} else {
		$gp_settings['link_target'] = $gp_portfolio_item_link_target;
	}	
		
	// Page Title Header
	if ( get_post_meta( get_the_ID(), '_gp_title_header', true ) && get_post_meta( get_the_ID(), '_gp_title_header', true ) != 'default' ) {
		$gp_settings['title_header'] = get_post_meta( get_the_ID(), '_gp_title_header', true );
	} else {
		$gp_settings['title_header'] = $gp_portfolio_item_title_header;
	}	

	// Page Title Image
	if ( get_post_meta( get_the_ID(), '_gp_title_header_image', true ) && get_post_meta( get_the_ID(), '_gp_title_header_image', true ) != 'default' ) {
		$gp_settings['title_image'] = get_post_meta( get_the_ID(), '_gp_title_header_image', true );
	} else {
		$gp_settings['title_image'] = $gp_portfolio_item_title_header_image;
	}	

	// Page Title Color
	if ( get_post_meta( get_the_ID(), '_gp_title_header_color', true ) && get_post_meta( get_the_ID(), '_gp_title_header_color', true ) != '' ) {
		$gp_settings['title_color'] = get_post_meta( get_the_ID(), '_gp_title_header_color', true );
	} else {
		$gp_settings['title_color'] = $gp_portfolio_item_title_header_color;
	}	
		
	// Page Title Padding
	if ( get_post_meta( get_the_ID(), '_gp_title_header_padding', true ) && get_post_meta( get_the_ID(), '_gp_title_header_padding', true ) != 'default' ) {
		$gp_settings['title_padding'] = get_post_meta( get_the_ID(), '_gp_title_header_padding', true );
	} else {
		$gp_settings['title_padding'] = $gp_portfolio_item_title_header_padding;
	}	

	// Parallax Page Title
	if ( get_post_meta( get_the_ID(), '_gp_title_header_parallax', true ) && get_post_meta( get_the_ID(), '_gp_title_header_parallax', true ) != 'default' ) {
		$gp_settings['title_parallax'] = get_post_meta( get_the_ID(), '_gp_title_header_parallax', true );
	} else {
		$gp_settings['title_parallax'] = $gp_portfolio_item_title_header_parallax;
	}
	
	$gp_settings['link_text'] = $gp_portfolio_item_link_text;
	$gp_settings['related_items'] = $gp_portfolio_item_related_items;			
	$gp_settings['related_image_width'] = $gp_portfolio_item_related_image_width;
	$gp_settings['related_image_height'] = $gp_portfolio_item_related_image_height;
	$gp_settings['related_per_page'] = $gp_portfolio_item_related_per_page;
			
						
/*--------------------------------------------------------------
8 - Post Categories, Archives, Tags, Search & Author Pages
--------------------------------------------------------------*/


} elseif ( is_home() OR is_archive() OR is_search() ) {

	$gp_settings['blog_type'] = $gp_cat_blog_type;
	$gp_settings['layout'] = $gp_cat_layout;
	$gp_settings['sidebar'] = $gp_cat_sidebar;
	$gp_settings['featured_image'] = $gp_cat_featured_image;		
	$gp_settings['image_width'] = $gp_cat_image_width;
	$gp_settings['image_height'] = $gp_cat_image_height;
	$gp_settings['hard_crop'] = $gp_cat_hard_crop;
	if ( $gp_settings['hard_crop'] == 'enable' ) { $gp_settings['hard_crop'] = true; } else { $gp_settings['hard_crop'] = false; }
	$gp_settings['image_wrap'] = $gp_cat_image_wrap;		
	$gp_settings['title_header'] = $gp_cat_title_header;
	$gp_settings['title_image'] = $gp_cat_title_header_image;
	$gp_settings['title_color'] = $gp_cat_title_header_color;
	$gp_settings['title_padding'] = $gp_cat_title_header_padding;
	$gp_settings['title_parallax'] = $gp_cat_title_header_parallax;
	$gp_settings['content_display'] = $gp_cat_content_display;
	$gp_settings['excerpt_length'] = $gp_cat_excerpt_length;
	$gp_settings['read_more'] = $gp_cat_read_more;
	$gp_settings['meta_date'] = $gp_cat_date;
	$gp_settings['meta_author'] = $gp_cat_author;
	$gp_settings['meta_cats'] = $gp_cat_cats;
	$gp_settings['meta_comments'] = $gp_cat_comments;
	$gp_settings['meta_tags'] = $gp_cat_tags;

							
/*--------------------------------------------------------------
9 - Posts
--------------------------------------------------------------*/

} elseif ( is_singular( 'post' ) ) {

	// Page Layout
	if ( get_post_meta( get_the_ID(), '_gp_layout', true ) && get_post_meta( get_the_ID(), '_gp_layout', true ) != 'default' ) {
		$gp_settings['layout'] = get_post_meta( get_the_ID(), '_gp_layout', true );
	} else {
		$gp_settings['layout'] = $gp_post_layout;
	}
						
	// Sidebar
	if ( get_post_meta( get_the_ID(), '_gp_sidebar', true ) && get_post_meta( get_the_ID(), '_gp_sidebar', true ) != 'default' ) {
		$gp_settings['sidebar'] = get_post_meta( get_the_ID(), '_gp_sidebar', true );
	} else {
		$gp_settings['sidebar'] = $gp_post_sidebar;
	}
	
	// Featured Image
	if ( get_post_meta( get_the_ID(), '_gp_featured_image', true ) && get_post_meta( get_the_ID(), '_gp_featured_image', true ) != 'default' ) {
		$gp_settings['featured_image'] = get_post_meta( get_the_ID(), '_gp_featured_image', true );
	} else {
		$gp_settings['featured_image'] = $gp_post_featured_image;
	}
	
	// Image Dimensions
	if ( get_post_meta( get_the_ID(), '_gp_image_width', true ) && get_post_meta( get_the_ID(), '_gp_image_width', true ) != '' ) {
		$gp_settings['image_width'] = get_post_meta( get_the_ID(), '_gp_image_width', true );
	} else {
		$gp_settings['image_width'] = $gp_post_image_width;
	}
	if ( get_post_meta( get_the_ID(), '_gp_image_height', true ) != '' ) {
		$gp_settings['image_height'] = get_post_meta( get_the_ID(), '_gp_image_height', true );
	} else {
		$gp_settings['image_height'] = $gp_post_image_height;
	}

	// Hard Crop
	if ( get_post_meta( get_the_ID(), '_gp_hard_crop', true ) && get_post_meta( get_the_ID(), '_gp_hard_crop', true ) != 'default' ) {
		$gp_settings['hard_crop'] = get_post_meta( get_the_ID(), '_gp_hard_crop', true );
	} else {
		$gp_settings['hard_crop'] = $gp_post_hard_crop;
	}
	if ( $gp_settings['hard_crop'] == 'enable' ) { $gp_settings['hard_crop'] = true; } else { $gp_settings['hard_crop'] = false; }
		
	// Image Wrap
	if ( get_post_meta( get_the_ID(), '_gp_image_wrap', true ) && get_post_meta( get_the_ID(), '_gp_image_wrap', true ) != 'default' ) {
		$gp_settings['image_wrap'] = get_post_meta( get_the_ID(), '_gp_image_wrap', true );
	} else {
		$gp_settings['image_wrap'] = $gp_post_image_wrap;
	}
					
	$gp_settings['meta_date'] = $gp_post_date;
	$gp_settings['meta_author'] = $gp_post_author;
	$gp_settings['meta_cats'] = $gp_post_cats;
	$gp_settings['meta_comments'] = $gp_post_comments;
	$gp_settings['meta_tags'] = $gp_post_tags;
	$gp_settings['author_info'] = $gp_post_author_info;
	$gp_settings['related_items'] = $gp_post_related_items;			
	$gp_settings['related_image_width'] = $gp_post_related_image_width;
	$gp_settings['related_image_height'] = $gp_post_related_image_height;
	$gp_settings['related_per_page'] = $gp_post_related_per_page;
	

/*--------------------------------------------------------------
10 - 404 & Attachment Pages
--------------------------------------------------------------*/

} elseif ( is_404() OR is_attachment() ) {

	$gp_settings['layout'] = 'fullwidth';


/*--------------------------------------------------------------
11 - Homepage Page Template
--------------------------------------------------------------*/

} elseif ( is_page_template( 'homepage-layerslider.php' ) OR is_page_template( 'homepage-flexslider.php' ) OR is_page_template( 'blank-page.php' ) ) {
	
	$gp_settings['layout'] = 'fullwidth';

	
/*--------------------------------------------------------------
12 - Pages & Custom Post Types
--------------------------------------------------------------*/

} else {

	// Page Layout
	if ( get_post_meta( get_the_ID(), '_gp_layout', true ) && get_post_meta( get_the_ID(), '_gp_layout', true ) != 'default' ) {
		$gp_settings['layout'] = get_post_meta( get_the_ID(), '_gp_layout', true );
	} else {
		$gp_settings['layout'] = $gp_page_layout;
	}
				
	// Sidebar
	if ( get_post_meta( get_the_ID(), '_gp_sidebar', true ) && get_post_meta( get_the_ID(), '_gp_sidebar', true ) != 'default' ) {
		$gp_settings['sidebar'] = get_post_meta( get_the_ID(), '_gp_sidebar', true );
	} else {
		$gp_settings['sidebar'] = $gp_page_sidebar;
	}
			
	// Featured Image
	if ( get_post_meta( get_the_ID(), '_gp_featured_image', true ) && get_post_meta( get_the_ID(), '_gp_featured_image', true ) != 'default' ) {
		$gp_settings['featured_image'] = get_post_meta( get_the_ID(), '_gp_featured_image', true );
	} else {
		$gp_settings['featured_image'] = $gp_page_featured_image;
	}
	
	// Image Dimensions
	if ( get_post_meta( get_the_ID(), '_gp_image_width', true ) && get_post_meta( get_the_ID(), '_gp_image_width', true ) != '' ) {
		$gp_settings['image_width'] = get_post_meta( get_the_ID(), '_gp_image_width', true );
	} else {
		$gp_settings['image_width'] = $gp_page_image_width;
	}
	if ( get_post_meta( get_the_ID(), '_gp_image_height', true ) != '' ) {
		$gp_settings['image_height'] = get_post_meta( get_the_ID(), '_gp_image_height', true );
	} else {
		$gp_settings['image_height'] = $gp_page_image_height;
	}

	// Hard Crop
	if ( get_post_meta( get_the_ID(), '_gp_hard_crop', true ) && get_post_meta( get_the_ID(), '_gp_hard_crop', true ) != 'default' ) {
		$gp_settings['hard_crop'] = get_post_meta( get_the_ID(), '_gp_hard_crop', true );
	} else {
		$gp_settings['hard_crop'] = $gp_page_hard_crop;
	}
	if ( $gp_settings['hard_crop'] == 'enable' ) { $gp_settings['hard_crop'] = true; } else { $gp_settings['hard_crop'] = false; }
		
	// Image Wrap
	if ( get_post_meta( get_the_ID(), '_gp_image_wrap', true ) && get_post_meta( get_the_ID(), '_gp_image_wrap', true ) != 'default' ) {
		$gp_settings['image_wrap'] = get_post_meta( get_the_ID(), '_gp_image_wrap', true );
	} else {
		$gp_settings['image_wrap'] = $gp_page_image_wrap;
	}
	
	// Page Title Header
	if ( get_post_meta( get_the_ID(), '_gp_title_header', true ) && get_post_meta( get_the_ID(), '_gp_title_header', true ) != 'default' ) {
		$gp_settings['title_header'] = get_post_meta( get_the_ID(), '_gp_title_header', true );
	} else {
		$gp_settings['title_header'] = $gp_page_title_header;
	}	

	// Page Title Image
	if ( get_post_meta( get_the_ID(), '_gp_title_header_image', true ) && get_post_meta( get_the_ID(), '_gp_title_header_image', true ) != 'default' ) {
		$gp_settings['title_image'] = get_post_meta( get_the_ID(), '_gp_title_header_image', true );
	} else {
		$gp_settings['title_image'] = $gp_page_title_header_image;
	}	

	// Page Title Color
	if ( get_post_meta( get_the_ID(), '_gp_title_header_color', true ) && get_post_meta( get_the_ID(), '_gp_title_header_color', true ) != '' ) {
		$gp_settings['title_color'] = get_post_meta( get_the_ID(), '_gp_title_header_color', true );
	} else {
		$gp_settings['title_color'] = $gp_page_title_header_color;
	}	
		
	// Page Title Padding
	if ( get_post_meta( get_the_ID(), '_gp_title_header_padding', true ) && get_post_meta( get_the_ID(), '_gp_title_header_padding', true ) != 'default' ) {
		$gp_settings['title_padding'] = get_post_meta( get_the_ID(), '_gp_title_header_padding', true );
	} else {
		$gp_settings['title_padding'] = $gp_page_title_header_padding;
	}	

	// Parallax Page Title
	if ( get_post_meta( get_the_ID(), '_gp_title_header_parallax', true ) && get_post_meta( get_the_ID(), '_gp_title_header_parallax', true ) != 'default' ) {
		$gp_settings['title_parallax'] = get_post_meta( get_the_ID(), '_gp_title_header_parallax', true );
	} else {
		$gp_settings['title_parallax'] = $gp_page_title_header_parallax;
	}	

	if ( is_page_template( 'blog-standard.php' ) OR is_page_template( 'blog-masonry.php' ) ) {
		$gp_settings['content_display'] = $gp_cat_content_display;
		$gp_settings['excerpt_length'] = $gp_cat_excerpt_length;
		$gp_settings['read_more'] = $gp_cat_read_more;
		$gp_settings['meta_date'] = $gp_cat_date;
		$gp_settings['meta_author'] = $gp_cat_author;
		$gp_settings['meta_cats'] = $gp_cat_cats;
		$gp_settings['meta_comments'] = $gp_cat_comments;
		$gp_settings['meta_tags'] = $gp_cat_tags;	
	} else {
		$gp_settings['author_info'] = $gp_page_author_info;			
	}
									
}

?>