<?php

/*--------------------------------------------------------------
Custom Visual Composer Fields
--------------------------------------------------------------*/

// Icon Selection
function gp_icon_selection( $settings, $value ) {
   $dependency = vc_generate_dependencies_attributes( $settings );
	foreach ( $settings['value'] as $val ) {		   
		$output .= '<a href="' . $val . '" class="icon-link"><i class="fa fa-lg ' . $val . '" '.$dependency.'></i></a>';		
	}
	$output .= '<input name="' . $settings['param_name'] . '" id="icon-selection-value" class="wpb_vc_param_value ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $value . '" ' . $dependency . '/>';    
	return $output;
}
add_shortcode_param( 'icon_selection', 'gp_icon_selection', get_template_directory_uri() . '/lib/admin/scripts/icon-selection.js' );	


/*--------------------------------------------------------------
Blog Shortcode
--------------------------------------------------------------*/

vc_remove_element( 'vc_posts_grid' );
require_once( gp . 'vc_templates/blog.php' );

vc_map( array( 
	'name' => __( 'Blog', 'gp_lang' ),
	'base' => 'blog',
	'class' => 'wpb_vc_blog',
	'controls' => 'full',
	'icon' => 'gp-icon-blog',
	'category' => __( 'Content', 'gp_lang' ),
	'admin_enqueue_css' => get_template_directory_uri().'/lib/fonts/font-awesome/css/font-awesome.min.css',
	'admin_enqueue_js' => get_template_directory_uri() . '/lib/admin/scripts/icon-selection.js',
	'params' => array( 		
		array( 
		'heading' => __( 'Type', 'gp_lang' ),
		'param_name' => 'type',
		'class' => '',
		'value' => array( __( 'Standard', 'gp_lang' ) => 'blog-standard', __( 'Masonry', 'gp_lang' ) => 'blog-masonry' ),
		'type' => 'dropdown',
		 ),
		array( 
		'heading' => __( 'Categories', 'gp_lang' ),
		'description' => __('Enter the ID numbers of the categories you want to include or exclude, separating each ID with a comma e.g. 33,74,25. Add a minus before an ID to exclude it e.g. -33,-74,-25. Hover your mouse over the category names on the <a href="' . admin_url ( 'edit-tags.php?taxonomy=category'). '" target="_blank">category page</a> to reveal the URL which contains the ID numbers.', 'gp_lang'),
		'param_name' => 'cats',
		'class' => '',
		'value' => '',
		'type' => 'textfield',
		 ),
		array( 
		'heading' => __( 'Per Page', 'gp_lang' ),
		'param_name' => 'per_page',
		'class' => '',
		'value' => '10',
		'type' => 'textfield',
		 ),
		array( 
		'heading' => __( 'Featured Image', 'gp_lang' ),
		'param_name' => 'featured_image',
		'class' => '',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		 ),	
		array( 
		'heading' => __( 'Image Width', 'gp_lang' ),
		'param_name' => 'image_width',
		'class' => '',
		'value' => '700',
		'type' => 'textfield',
		'dependency' => array( 'element' => 'featured_image', 'value' => 'enable' ),
		 ),		 
		array( 
		'heading' => __( 'Image Height', 'gp_lang' ),
		'param_name' => 'image_height',
		'class' => '',
		'value' => '400',
		'type' => 'textfield',
		'dependency' => array( 'element' => 'featured_image', 'value' => 'enable' ),
		 ),	
		array( 
		'heading' => __( 'Hard Crop', 'gp_lang' ),
		'param_name' => 'hard_crop',
		'class' => '',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		'dependency' => array( 'element' => 'featured_image', 'value' => 'enable' ),
		 ),	
		array( 
		'heading' => __( 'Image Wrap', 'gp_lang' ),
		'param_name' => 'image_wrap',
		'class' => '',
		'value' => array( __( 'Disable', 'gp_lang' ) => 'disable', __( 'Enable', 'gp_lang' ) => 'enable' ),
		'type' => 'dropdown',
		'dependency' => array( 'element' => 'featured_image', 'value' => 'enable' ),
		 ),
		array( 
		'heading' => __( 'Content Display', 'gp_lang' ),
		'param_name' => 'content_display',
		'class' => '',
		'value' => array( __( 'Excerpt', 'gp_lang' ) => 'excerpt', __( 'Full Content', 'gp_lang' ) => 'full_content' ),
		'type' => 'dropdown',
		 ),
		array( 
		'heading' => __( 'Excerpt Length', 'gp_lang' ),
		'param_name' => 'excerpt_length',
		'class' => '',
		'value' => '400',
		'type' => 'textfield',
		'dependency' => array( 'element' => 'content_display', 'value' => 'excerpt' ),
		 ),
		array( 
		'heading' => __( 'Read More Link', 'gp_lang' ),
		'param_name' => 'read_more',
		'class' => '',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		 ),
		array( 
		'heading' => __( 'Post Date', 'gp_lang' ),
		'param_name' => 'meta_date',
		'class' => '',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		 ),		
		array( 
		'heading' => __( 'Post Author', 'gp_lang' ),
		'param_name' => 'meta_author',
		'class' => '',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		 ),		
		array( 
		'heading' => __( 'Post Categories', 'gp_lang' ),
		'param_name' => 'meta_cats',
		'class' => '',
		'value' => array( __( 'Disable', 'gp_lang' ) => 'disable', __( 'Enable', 'gp_lang' ) => 'enable' ),
		'type' => 'dropdown',
		 ),		
		array( 
		'heading' => __( 'Post Comment Number', 'gp_lang' ),
		'param_name' => 'meta_comments',
		'class' => '',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		 ),
		array( 
		'heading' => __( 'Post Tags', 'gp_lang' ),
		'param_name' => 'meta_tags',
		'class' => '',
		'value' => array( __( 'Disable', 'gp_lang' ) => 'disable', __( 'Enable', 'gp_lang' ) => 'enable' ),
		'type' => 'dropdown',
		 ),	
		array( 
		'heading' => __( 'Pagination', 'gp_lang' ),
		'param_name' => 'pages',
		'class' => '',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		 ),		 			 				 		   			 			 
		array( 
		'heading' => __( 'Extra class names', 'gp_lang' ),
		'param_name' => 'classes',
		'class' => '',
		'value' => '',
		'description' => __( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gp_lang' ),
		'type' => 'textfield',
		 ),																																								
	 )
) );


/*--------------------------------------------------------------
Button Shortcode
--------------------------------------------------------------*/

vc_remove_element( 'vc_button' );
//vc_remove_element( 'vc_button2' );
require_once( gp . 'vc_templates/button.php' );

vc_map( array( 
	'name' => __( 'Button', 'gp_lang' ),
	'base' => 'button',
	'class' => 'wpb_vc_button',
	'controls' => 'full',
	'icon' => 'gp-icon-button',
	'category' => __( 'Content', 'gp_lang' ),
	'admin_enqueue_css' => get_template_directory_uri().'/lib/fonts/font-awesome/css/font-awesome.min.css',
	'admin_enqueue_js' => get_template_directory_uri() . '/lib/admin/scripts/icon-selection.js',
	'params' => array( 	
		array( 
		'heading' => __( 'Button Text', 'gp_lang' ),
		'param_name' => 'text',
		'class' => '',
		'holder' => 'span',
		'value' => 'Button Text',
		'type' => 'textfield'
		 ),
		array( 
		'heading' => __( 'Link', 'gp_lang' ),
		'param_name' => 'link',
		'class' => '',
		'value' => '',
		'type' => 'textfield',
		 ),		
		array( 
		'heading' => __( 'Target', 'gp_lang' ),
		'param_name' => 'target',
		'class' => '',
		'value' => array( __( 'Same Window', 'gp_lang' ) => '', __( 'New Window', 'gp_lang' ) => '_blank' ),
		'type' => 'dropdown',
		'dependency' => array( 'element' => 'link', 'not_empty' => true )
		 ),
		array( 
		'heading' => __( 'Text Color', 'gp_lang' ),
		'param_name' => 'text_color',
		'class' => '',
		'value' => '#ffffff',
		'type' => 'colorpicker',
		 ),			
		array( 
		'heading' => __( 'Text Size', 'gp_lang' ),
		'param_name' => 'text_size',
		'class' => '',
		'value' => '14px',
		'description' => __( 'The text size of the button (supports px, em, %).', 'gp_lang' ),
		'type' => 'textfield',
		 ),			
		array( 
		'heading' => __( 'Background Color', 'gp_lang' ),
		'param_name' => 'background_color',
		'class' => '',
		'value' => '#23a1b8',
		'type' => 'colorpicker',
		 ),									
		array( 
		'heading' => __( 'Border Color', 'gp_lang' ),
		'param_name' => 'border_color',
		'class' => '',
		'value' => '',
		'type' => 'colorpicker',
		 ),									
		array( 
		'heading' => __( 'Border Radius', 'gp_lang' ),
		'param_name' => 'border_radius',
		'class' => '',
		'value' => '3px',
		'description' => __( 'The border radius of the button to create rounded corners (supports px, em, %).', 'gp_lang' ),
		'type' => 'textfield'
		 ),
		array( 
		'heading' => __( 'Button Alignment', 'gp_lang' ),
		'param_name' => 'align',
		'class' => '',
		'value' => array( __( 'Align Left', 'gp_lang' ) => '', __( 'Align Center', 'gp_lang' ) => 'text-center', __( 'Align Right', 'gp_lang' ) => 'text-right' ),
		'type' => 'dropdown',
		 ),		
		array( 
		'heading' => __( 'Width', 'gp_lang' ),
		'param_name' => 'width',
		'class' => '',
		'value' => 'auto',
		'description' => __( 'The width of the button (supports px, em, %).', 'gp_lang' ),
		'type' => 'textfield'
		 ),
		array( 
		'heading' => __( 'Padding', 'gp_lang' ),
		'param_name' => 'padding',
		'class' => '',
		'value' => '14px 20px',
		'description' => __( 'The padding of the button (supports px, em, %).', 'gp_lang' ),
		'type' => 'textfield',
		 ),	
		array( 
		'heading' => __( 'Margins', 'gp_lang' ),
		'param_name' => 'margins',
		'class' => '',
		'value' => '',
		'description' => __( 'The margins of the button (supports px, em, %).', 'gp_lang' ),
		'type' => 'textfield',
		 ),		 		
		array( 
		'heading' => __( 'Icon', 'gp_lang' ),
		'param_name' => 'icon',
		'class' => '',
		'value' => array( '', 'fa-glass','fa-music','fa-search','fa-envelope-o','fa-heart','fa-star','fa-star-o','fa-user','fa-film','fa-th-large','fa-th','fa-th-list','fa-check','fa-times','fa-search-plus','fa-search-minus','fa-power-off','fa-signal','fa-cog','fa-trash-o','fa-home','fa-file-o','fa-clock-o','fa-road','fa-download','fa-arrow-circle-o-down','fa-arrow-circle-o-up','fa-inbox','fa-play-circle-o','fa-repeat','fa-refresh','fa-list-alt','fa-lock','fa-flag','fa-headphones','fa-volume-off','fa-volume-down','fa-volume-up','fa-qrcode','fa-barcode','fa-tag','fa-tags','fa-book','fa-bookmark','fa-print','fa-camera','fa-font','fa-bold','fa-italic','fa-text-height','fa-text-width','fa-align-left','fa-align-center','fa-align-right','fa-align-justify','fa-list','fa-outdent','fa-indent','fa-video-camera','fa-picture-o','fa-pencil','fa-map-marker','fa-adjust','fa-tint','fa-pencil-square-o','fa-share-square-o','fa-check-square-o','fa-arrows','fa-step-backward','fa-fast-backward','fa-backward','fa-play','fa-pause','fa-stop','fa-forward','fa-fast-forward','fa-step-forward','fa-eject','fa-chevron-left','fa-chevron-right','fa-plus-circle','fa-minus-circle','fa-times-circle','fa-check-circle','fa-question-circle','fa-info-circle','fa-crosshairs','fa-times-circle-o','fa-check-circle-o','fa-ban','fa-arrow-left','fa-arrow-right','fa-arrow-up','fa-arrow-down','fa-share','fa-expand','fa-compress','fa-plus','fa-minus','fa-asterisk','fa-exclamation-circle','fa-gift','fa-leaf','fa-fire','fa-eye','fa-eye-slash','fa-exclamation-triangle','fa-plane','fa-calendar','fa-random','fa-comment','fa-magnet','fa-chevron-up','fa-chevron-down','fa-retweet','fa-shopping-cart','fa-folder','fa-folder-open','fa-arrows-v','fa-arrows-h','fa-bar-chart-o','fa-twitter-square','fa-facebook-square','fa-camera-retro','fa-key','fa-cogs','fa-comments','fa-thumbs-o-up','fa-thumbs-o-down','fa-star-half','fa-heart-o','fa-sign-out','fa-linkedin-square','fa-thumb-tack','fa-external-link','fa-sign-in','fa-trophy','fa-github-square','fa-upload','fa-lemon-o','fa-phone','fa-square-o','fa-bookmark-o','fa-phone-square','fa-twitter','fa-facebook','fa-github','fa-unlock','fa-credit-card','fa-rss','fa-hdd-o','fa-bullhorn','fa-bell','fa-certificate','fa-hand-o-right','fa-hand-o-left','fa-hand-o-up','fa-hand-o-down','fa-arrow-circle-left','fa-arrow-circle-right','fa-arrow-circle-up','fa-arrow-circle-down','fa-globe','fa-wrench','fa-tasks','fa-filter','fa-briefcase','fa-arrows-alt','fa-users','fa-link','fa-cloud','fa-flask','fa-scissors','fa-files-o','fa-paperclip','fa-floppy-o','fa-square','fa-bars','fa-list-ul','fa-list-ol','fa-strikethrough','fa-underline','fa-table','fa-magic','fa-truck','fa-pinterest','fa-pinterest-square','fa-google-plus-square','fa-google-plus','fa-money','fa-caret-down','fa-caret-up','fa-caret-left','fa-caret-right','fa-columns','fa-sort','fa-sort-asc','fa-sort-desc','fa-envelope','fa-linkedin','fa-undo','fa-gavel','fa-tachometer','fa-comment-o','fa-comments-o','fa-bolt','fa-sitemap','fa-umbrella','fa-clipboard','fa-lightbulb-o','fa-exchange','fa-cloud-download','fa-cloud-upload','fa-user-md','fa-stethoscope','fa-suitcase','fa-bell-o','fa-coffee','fa-cutlery','fa-file-text-o','fa-building-o','fa-hospital-o','fa-ambulance','fa-medkit','fa-fighter-jet','fa-beer','fa-h-square','fa-plus-square','fa-angle-double-left','fa-angle-double-right','fa-angle-double-up','fa-angle-double-down','fa-angle-left','fa-angle-right','fa-angle-up','fa-angle-down','fa-desktop','fa-laptop','fa-tablet','fa-mobile','fa-circle-o','fa-quote-left','fa-quote-right','fa-spinner','fa-circle','fa-reply','fa-github-alt','fa-folder-o','fa-folder-open-o','fa-smile-o','fa-frown-o','fa-meh-o','fa-gamepad','fa-keyboard-o','fa-flag-o','fa-flag-checkered','fa-terminal','fa-code','fa-reply-all','fa-mail-reply-all','fa-star-half-o','fa-location-arrow','fa-crop','fa-code-fork','fa-chain-broken','fa-question','fa-info','fa-exclamation','fa-superscript','fa-subscript','fa-eraser','fa-puzzle-piece','fa-microphone','fa-microphone-slash','fa-shield','fa-calendar-o','fa-fire-extinguisher','fa-rocket','fa-maxcdn','fa-chevron-circle-left','fa-chevron-circle-right','fa-chevron-circle-up','fa-chevron-circle-down','fa-html5','fa-css3','fa-anchor','fa-unlock-alt','fa-bullseye','fa-ellipsis-h','fa-ellipsis-v','fa-rss-square','fa-play-circle','fa-ticket','fa-minus-square','fa-minus-square-o','fa-level-up','fa-level-down','fa-check-square','fa-pencil-square','fa-external-link-square','fa-share-square','fa-compass','fa-caret-square-o-down','fa-caret-square-o-up','fa-caret-square-o-right','fa-eur','fa-gbp','fa-usd','fa-inr','fa-jpy','fa-rub','fa-krw','fa-btc','fa-file','fa-file-text','fa-sort-alpha-asc','fa-sort-alpha-desc','fa-sort-amount-asc','fa-sort-amount-desc','fa-sort-numeric-asc','fa-sort-numeric-desc','fa-thumbs-up','fa-thumbs-down','fa-youtube-square','fa-youtube','fa-xing','fa-xing-square','fa-youtube-play','fa-dropbox','fa-stack-overflow','fa-instagram','fa-flickr','fa-adn','fa-bitbucket','fa-bitbucket-square','fa-tumblr','fa-tumblr-square','fa-long-arrow-down','fa-long-arrow-up','fa-long-arrow-left','fa-long-arrow-right','fa-apple','fa-windows','fa-android','fa-linux','fa-dribbble','fa-skype','fa-foursquare','fa-trello','fa-female','fa-male','fa-gittip','fa-sun-o','fa-moon-o','fa-archive','fa-bug','fa-vk','fa-weibo','fa-renren','fa-pagelines','fa-stack-exchange','fa-arrow-circle-o-right','fa-arrow-circle-o-left','fa-caret-square-o-left','fa-dot-circle-o','fa-wheelchair','fa-vimeo-square','fa-try','fa-plus-square-o' ),
		'description' => __( 'The icon you want to display.', 'gp_lang' ),
		'type' => 'icon_selection',
		 ),				
		array( 
		'heading' => __( 'Extra class names', 'gp_lang' ),
		'param_name' => 'classes',
		'class' => '',
		'value' => '',
		'description' => __( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gp_lang' ),
		'type' => 'textfield',
		 ),																																								
	 )
) );


/*--------------------------------------------------------------
Icon Shortcode
--------------------------------------------------------------*/

require_once( gp . 'vc_templates/icon.php' );

vc_map( array( 
	'name' => __( 'Icon', 'gp_lang' ),
	'base' => 'icon',
	'class' => 'fa fa-rocket',
	'controls' => 'full',
	'icon' => 'gp-icon-icon',
	'category' => __( 'Content', 'gp_lang' ),
	'admin_enqueue_css' => get_template_directory_uri() . '/lib/fonts/font-awesome/css/font-awesome.min.css',
	'admin_enqueue_js' => get_template_directory_uri() . '/lib/admin/scripts/icon-selection.js',
	'params' => array( 	
		array( 
		'heading' => __( 'Icon', 'gp_lang' ),
		'param_name' => 'image',
		'class' => '',
		'value' => array( 'fa-glass','fa-music','fa-search','fa-envelope-o','fa-heart','fa-star','fa-star-o','fa-user','fa-film','fa-th-large','fa-th','fa-th-list','fa-check','fa-times','fa-search-plus','fa-search-minus','fa-power-off','fa-signal','fa-cog','fa-trash-o','fa-home','fa-file-o','fa-clock-o','fa-road','fa-download','fa-arrow-circle-o-down','fa-arrow-circle-o-up','fa-inbox','fa-play-circle-o','fa-repeat','fa-refresh','fa-list-alt','fa-lock','fa-flag','fa-headphones','fa-volume-off','fa-volume-down','fa-volume-up','fa-qrcode','fa-barcode','fa-tag','fa-tags','fa-book','fa-bookmark','fa-print','fa-camera','fa-font','fa-bold','fa-italic','fa-text-height','fa-text-width','fa-align-left','fa-align-center','fa-align-right','fa-align-justify','fa-list','fa-outdent','fa-indent','fa-video-camera','fa-picture-o','fa-pencil','fa-map-marker','fa-adjust','fa-tint','fa-pencil-square-o','fa-share-square-o','fa-check-square-o','fa-arrows','fa-step-backward','fa-fast-backward','fa-backward','fa-play','fa-pause','fa-stop','fa-forward','fa-fast-forward','fa-step-forward','fa-eject','fa-chevron-left','fa-chevron-right','fa-plus-circle','fa-minus-circle','fa-times-circle','fa-check-circle','fa-question-circle','fa-info-circle','fa-crosshairs','fa-times-circle-o','fa-check-circle-o','fa-ban','fa-arrow-left','fa-arrow-right','fa-arrow-up','fa-arrow-down','fa-share','fa-expand','fa-compress','fa-plus','fa-minus','fa-asterisk','fa-exclamation-circle','fa-gift','fa-leaf','fa-fire','fa-eye','fa-eye-slash','fa-exclamation-triangle','fa-plane','fa-calendar','fa-random','fa-comment','fa-magnet','fa-chevron-up','fa-chevron-down','fa-retweet','fa-shopping-cart','fa-folder','fa-folder-open','fa-arrows-v','fa-arrows-h','fa-bar-chart-o','fa-twitter-square','fa-facebook-square','fa-camera-retro','fa-key','fa-cogs','fa-comments','fa-thumbs-o-up','fa-thumbs-o-down','fa-star-half','fa-heart-o','fa-sign-out','fa-linkedin-square','fa-thumb-tack','fa-external-link','fa-sign-in','fa-trophy','fa-github-square','fa-upload','fa-lemon-o','fa-phone','fa-square-o','fa-bookmark-o','fa-phone-square','fa-twitter','fa-facebook','fa-github','fa-unlock','fa-credit-card','fa-rss','fa-hdd-o','fa-bullhorn','fa-bell','fa-certificate','fa-hand-o-right','fa-hand-o-left','fa-hand-o-up','fa-hand-o-down','fa-arrow-circle-left','fa-arrow-circle-right','fa-arrow-circle-up','fa-arrow-circle-down','fa-globe','fa-wrench','fa-tasks','fa-filter','fa-briefcase','fa-arrows-alt','fa-users','fa-link','fa-cloud','fa-flask','fa-scissors','fa-files-o','fa-paperclip','fa-floppy-o','fa-square','fa-bars','fa-list-ul','fa-list-ol','fa-strikethrough','fa-underline','fa-table','fa-magic','fa-truck','fa-pinterest','fa-pinterest-square','fa-google-plus-square','fa-google-plus','fa-money','fa-caret-down','fa-caret-up','fa-caret-left','fa-caret-right','fa-columns','fa-sort','fa-sort-asc','fa-sort-desc','fa-envelope','fa-linkedin','fa-undo','fa-gavel','fa-tachometer','fa-comment-o','fa-comments-o','fa-bolt','fa-sitemap','fa-umbrella','fa-clipboard','fa-lightbulb-o','fa-exchange','fa-cloud-download','fa-cloud-upload','fa-user-md','fa-stethoscope','fa-suitcase','fa-bell-o','fa-coffee','fa-cutlery','fa-file-text-o','fa-building-o','fa-hospital-o','fa-ambulance','fa-medkit','fa-fighter-jet','fa-beer','fa-h-square','fa-plus-square','fa-angle-double-left','fa-angle-double-right','fa-angle-double-up','fa-angle-double-down','fa-angle-left','fa-angle-right','fa-angle-up','fa-angle-down','fa-desktop','fa-laptop','fa-tablet','fa-mobile','fa-circle-o','fa-quote-left','fa-quote-right','fa-spinner','fa-circle','fa-reply','fa-github-alt','fa-folder-o','fa-folder-open-o','fa-smile-o','fa-frown-o','fa-meh-o','fa-gamepad','fa-keyboard-o','fa-flag-o','fa-flag-checkered','fa-terminal','fa-code','fa-reply-all','fa-mail-reply-all','fa-star-half-o','fa-location-arrow','fa-crop','fa-code-fork','fa-chain-broken','fa-question','fa-info','fa-exclamation','fa-superscript','fa-subscript','fa-eraser','fa-puzzle-piece','fa-microphone','fa-microphone-slash','fa-shield','fa-calendar-o','fa-fire-extinguisher','fa-rocket','fa-maxcdn','fa-chevron-circle-left','fa-chevron-circle-right','fa-chevron-circle-up','fa-chevron-circle-down','fa-html5','fa-css3','fa-anchor','fa-unlock-alt','fa-bullseye','fa-ellipsis-h','fa-ellipsis-v','fa-rss-square','fa-play-circle','fa-ticket','fa-minus-square','fa-minus-square-o','fa-level-up','fa-level-down','fa-check-square','fa-pencil-square','fa-external-link-square','fa-share-square','fa-compass','fa-caret-square-o-down','fa-caret-square-o-up','fa-caret-square-o-right','fa-eur','fa-gbp','fa-usd','fa-inr','fa-jpy','fa-rub','fa-krw','fa-btc','fa-file','fa-file-text','fa-sort-alpha-asc','fa-sort-alpha-desc','fa-sort-amount-asc','fa-sort-amount-desc','fa-sort-numeric-asc','fa-sort-numeric-desc','fa-thumbs-up','fa-thumbs-down','fa-youtube-square','fa-youtube','fa-xing','fa-xing-square','fa-youtube-play','fa-dropbox','fa-stack-overflow','fa-instagram','fa-flickr','fa-adn','fa-bitbucket','fa-bitbucket-square','fa-tumblr','fa-tumblr-square','fa-long-arrow-down','fa-long-arrow-up','fa-long-arrow-left','fa-long-arrow-right','fa-apple','fa-windows','fa-android','fa-linux','fa-dribbble','fa-skype','fa-foursquare','fa-trello','fa-female','fa-male','fa-gittip','fa-sun-o','fa-moon-o','fa-archive','fa-bug','fa-vk','fa-weibo','fa-renren','fa-pagelines','fa-stack-exchange','fa-arrow-circle-o-right','fa-arrow-circle-o-left','fa-caret-square-o-left','fa-dot-circle-o','fa-wheelchair','fa-vimeo-square','fa-try','fa-plus-square-o' ),
		'admin_label' => true,
		'description' => __( 'The icon image you want to display.', 'gp_lang' ),
		'type' => 'icon_selection',
		 ),		
		array( 
		'heading' => __( 'Link', 'gp_lang' ),
		'param_name' => 'link',
		'class' => '',
		'value' => '',
		'type' => 'textfield',
		 ),		
		array( 
		'heading' => __( 'Target', 'gp_lang' ),
		'param_name' => 'target',
		'class' => '',
		'value' => array( __( 'Same Window', 'gp_lang' ) => '', __( 'New Window', 'gp_lang' ) => '_blank' ),
		'type' => 'dropdown',
		'dependency' => array( 'element' => 'link', 'not_empty' => true )
		 ),		 
		array( 
		'heading' => __( 'Size', 'gp_lang' ),
		'param_name' => 'size',
		'class' => '',
		'value' => array( __( 'Medium', 'gp_lang' ) => 'medium', __( 'Extra Small', 'gp_lang' ) => 'xsmall', __( 'Small', 'gp_lang' ) => 'small', __( 'Large', 'gp_lang' ) => 'large', __( 'Extra Large', 'gp_lang' ) => 'xlarge' ),
		'description' => __( 'The size of the icon.', 'gp_lang' ),
		'type' => 'dropdown',
		 ),			
		array( 
		'heading' => __( 'Color', 'gp_lang' ),
		'param_name' => 'color',
		'class' => '',
		'value' => '#ffffff',
		'description' => __( 'The color of the icon.', 'gp_lang' ),
		'type' => 'colorpicker'
		 ),	
		array( 
		'heading' => __( 'Animation', 'gp_lang' ),
		'param_name' => 'animation',
		'class' => '',
		'value' => array( __( 'None', 'gp_lang' ) => 'no-animation', __( 'Slide Up', 'gp_lang' ) => 'slideUp', __( 'Slide Down', 'gp_lang' ) => 'slideDown', __( 'Slide Left', 'gp_lang' ) => 'slideLeft', __( 'Slide Right', 'gp_lang' ) => 'slideRight', __( 'Slide Expand Up', 'gp_lang' ) => 'slideExpandUp', __( 'Expand Up', 'gp_lang' ) => 'expandUp', __( 'Fade In', 'gp_lang' ) => 'fadeIn', __( 'Expand Open', 'gp_lang' ) => 'expandOpen', __( 'Big Entrance', 'gp_lang' ) => 'bigEntrance', __( 'Hatch', 'gp_lang' ) => 'hatch', __( 'Bounce', 'gp_lang' ) => 'bounce', __( 'Pulse', 'gp_lang' ) => 'pulse', __( 'Floating', 'gp_lang' ) => 'Floating', __( 'Tossing', 'gp_lang' ) => 'tossing', __( 'Pull Up', 'gp_lang' ) => 'pullUp', __( 'Pull Down', 'gp_lang' ) => 'pullDown', __( 'Stretch Left', 'gp_lang' ) => 'stretchLeft', __( 'Stretch Right', 'gp_lang' ) => 'stretchRight' ),
		'description' => __( 'The animation effect of the icon.', 'gp_lang' ),
		'type' => 'dropdown',
		 ),		
		array( 
		'heading' => __( 'Scroll Animation', 'gp_lang' ),
		'param_name' => 'scroll_animation',
		'class' => '',
		'value' => array( __( 'Disable', 'gp_lang' ) => 'disable', __( 'Enable', 'gp_lang' ) => 'enable' ),
		'description' => __( 'Choose whether the animation effect is activated when the element is scrolled into viewed.', 'gp_lang' ),
		'type' => 'dropdown',
		'dependency' => array( 'element' => 'animation', 'value' => array( 'slideUp', 'slideDown', 'slideLeft', 'slideRight', 'slideExpandUp', 'expandUp', 'fadeIn', 'expandOpen', 'bigEntrance', 'hatch' ) )
		 ),
		array( 
		'heading' => __( 'Delay', 'gp_lang' ),
		'param_name' => 'delay',
		'class' => '',
		'value' => '0.1',
		'description' => __( 'The number of seconds to delay the animation effect of the icon.', 'gp_lang' ),
		'type' => 'textfield',
		'dependency' => array( 'element' => 'animation', 'value' => array( 'slideUp', 'slideDown', 'slideLeft', 'slideRight', 'slideExpandUp', 'expandUp', 'fadeIn', 'expandOpen', 'bigEntrance', 'hatch' ) )		
		 ),		
		array( 
		'heading' => __( 'Spin Icon', 'gp_lang' ),
		'param_name' => 'spin',
		'class' => '',
		'value' => array( __( 'False', 'gp_lang' ) => 'false', __( 'True', 'gp_lang' ) => 'true' ),
		'description' => __( 'The icon spins around (useful for loading icons).', 'gp_lang' ),
		'type' => 'dropdown',
		 ),					
		array( 
		'heading' => __( 'Background Color 1', 'gp_lang' ),
		'param_name' => 'background_color_1',
		'class' => '',
		'value' => '#42caf6',
		'description' => __( 'The top background color of the icon.', 'gp_lang' ),
		'type' => 'colorpicker',
		 ),			
		array( 
		'heading' => __( 'Background Color 2', 'gp_lang' ),
		'param_name' => 'background_color_2',
		'class' => '',
		'value' => '#00c0ff',
		'description' => __( 'The bottom background color of the icon.', 'gp_lang' ),
		'type' => 'colorpicker'
		 ),
		array( 
		'heading' => __( 'Background Size', 'gp_lang' ),
		'param_name' => 'background_size',
		'class' => '',
		'value' => '98px',
		'description' => __( 'The width/height of the background of the icon (supports px, em, %).', 'gp_lang' ),
		'type' => 'textfield',
		 ),						
		array( 
		'heading' => __( 'Border Color', 'gp_lang' ),
		'param_name' => 'border_color',
		'class' => '',
		'value' => '',
		'description' => __( 'The border color of the icon.', 'gp_lang' ),
		'type' => 'colorpicker',
		 ),									
		array( 
		'heading' => __( 'Border Radius', 'gp_lang' ),
		'param_name' => 'border_radius',
		'class' => '',
		'value' => '100%',
		'description' => __( 'The border radius of the icon to create rounded corners (supports px, em, %).', 'gp_lang' ),
		'type' => 'textfield'
		 ),
		array( 
		'heading' => __( 'Margins', 'gp_lang' ),
		'param_name' => 'margins',
		'class' => '',
		'value' => '0',
		'description' => __( 'The margins of the icon (supports px, em, %).', 'gp_lang' ),
		'type' => 'textfield',
		 ),			
		array( 
		'heading' => __( 'Alignment', 'gp_lang' ),
		'param_name' => 'align',
		'class' => '',
		'value' => array( __( 'Center', 'gp_lang' ) => 'aligncenter', __( 'Left', 'gp_lang' ) => 'alignleft', __( 'Right', 'gp_lang' ) => 'alignright', __( 'None', 'gp_lang' ) => 'alignnone' ),
		'description' => __( 'The alignment of the icon.', 'gp_lang' ),
		'type' => 'dropdown',
		 ),				
		array( 
		'heading' => __( 'Extra class names', 'gp_lang' ),
		'param_name' => 'classes',
		'class' => '',
		'value' => '',
		'description' => __( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gp_lang' ),
		'type' => 'textfield',
		 ),																																								
	 )
 ) );


/*--------------------------------------------------------------
Portfolio Shortcode
--------------------------------------------------------------*/

require_once( gp . 'vc_templates/portfolio.php' );

vc_map( array( 
	'name' => __( 'Portfolio', 'gp_lang' ),
	'base' => 'portfolio',
	'class' => 'wpb_vc_portfolio',
	'controls' => 'full',
	'icon' => 'gp-icon-portfolio',
	'category' => __( 'Content', 'gp_lang' ),
	'admin_enqueue_css' => get_template_directory_uri().'/lib/fonts/font-awesome/css/font-awesome.min.css',
	'admin_enqueue_js' => get_template_directory_uri() . '/lib/admin/scripts/icon-selection.js',
	'params' => array( 		
		array( 
		'heading' => __( 'Type', 'gp_lang' ),
		'param_name' => 'type',
		'class' => '',
		'value' => array( __( '2 Columns', 'gp_lang' ) => 'portfolio-columns-2', __( '3 Columns', 'gp_lang' ) => 'portfolio-columns-3', __( '4 Columns', 'gp_lang' ) => 'portfolio-columns-4', __( '5 Columns', 'gp_lang' ) => 'portfolio-columns-5', __( '6 Columns', 'gp_lang' ) => 'portfolio-columns-6', __( 'Masonry', 'gp_lang' ) => 'portfolio-masonry' ),
		'type' => 'dropdown',
		 ),
		array( 
		'heading' => __( 'Categories', 'gp_lang' ),
		'description' => __('Enter the ID numbers of the categories you want to include or exclude, separating each ID with a comma e.g. 33,74,25. Add a minus before an ID to exclude it e.g. -33,-74,-25. Hover your mouse over the category names on the <a href="' . admin_url( 'edit-tags.php?taxonomy=gp_portfolios&post_type=gp_portfolio_item' ) . '" target="_blank">category page</a> to reveal the URL which contains the ID numbers.', 'gp_lang'),
		'param_name' => 'cats',
		'class' => '',
		'value' => '',
		'type' => 'textfield',
		 ),		 
		array( 
		'heading' => __( 'Portfolio Filter', 'gp_lang' ),
		'param_name' => 'filter',
		'class' => '',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		 ),			 
		array( 
		'heading' => __( 'Per Page', 'gp_lang' ),
		'param_name' => 'per_page',
		'class' => '',
		'value' => '10',
		'type' => 'textfield',
		 ), 
		array( 
		'heading' => __( 'Pagination', 'gp_lang' ),
		'param_name' => 'pages',
		'class' => '',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		 ),		 		 				 		   			 			 
		array( 
		'heading' => __( 'Extra class names', 'gp_lang' ),
		'param_name' => 'classes',
		'class' => '',
		'value' => '',
		'description' => __( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gp_lang' ),
		'type' => 'textfield',
		 ),																																								
	 )
) );


/*--------------------------------------------------------------
Pricing Table Shortcode
--------------------------------------------------------------*/

// Pricing Table
vc_map( array( 
	'name' => __( 'Pricing Table', 'gp_lang' ),
	'base' => 'pricing_table',
	'as_parent' => array( 'only' => 'pricing_column' ),
	'controls' => 'full',
	'icon' => 'gp-icon-pricing-table',
	'category' => __( 'Content', 'gp_lang' ),
	'js_view' => 'VcColumnView',
	'admin_enqueue_css' => get_template_directory_uri().'/lib/fonts/font-awesome/css/font-awesome.min.css',
	'params' => array( 
		array( 
		'heading' => __( 'Extra class names', 'gp_lang' ),
		'param_name' => 'classes',
		'value' => '',
		'description' => __( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gp_lang' ),
		'type' => 'textfield',
		 ),	
	),
	'js_view' => 'VcColumnView'
 ) );


// Pricing Column
vc_map( array( 
	'name' => __( 'Pricing Column', 'gp_lang' ),
	'base' => 'pricing_column',
	'content_element' => true,
	'as_child' => array( 'only' => 'pricing_table' ),
	'icon' => 'gp-icon-pricing-table',
	'params' => array( 	
		array( 
		'heading' => __( 'Column Title', 'gp_lang' ),
		'param_name' => 'title',
		'value' => '',
		'type' => 'textfield'
		 ),
		array( 
		'heading' => __( 'Price', 'gp_lang' ),
		'param_name' => 'price',
		'value' => '',
		'type' => 'textfield'
		 ),
		array( 
		'heading' => __( 'Currency Symbol', 'gp_lang' ),
		'param_name' => 'currency_symbol',
		'value' => '',
		'type' => 'textfield',
		 ),		
		array( 
		'heading' => __( 'Interval', 'gp_lang' ),
		'param_name' => 'interval',
		'value' => '',
		'type' => 'textfield',
		 ),		
		array( 
		'heading' => __( 'Highlight Column', 'gp_lang' ),
		'param_name' => 'highlight',
		'value' => array( __( 'Disable', 'gp_lang' ) => 'disable', __( 'Enable', 'gp_lang' ) => 'enable' ),
		'type' => 'dropdown'
		 ),	
		array( 
		'heading' => __( 'Highlight Text', 'gp_lang' ),
		'param_name' => 'highlight_text',
		'value' => '',
		'dependency' => array( 'element' => 'highlight', 'value' => 'enable' ),
		'type' => 'textfield',
		 ),	
		array( 
		'heading' => __( 'Content', 'gp_lang' ),
		'param_name' => 'content',
		'type' => 'textarea_html',
		'description' => __( 'Use the Unordered List button to create the points in your pricing column. <br/>You can also add shortcodes such as the [button link="#"] shortcode seen in the site demo.', 'gp_lang' ),
		 ),
		array( 
		'heading' => __( 'Highlight Color', 'gp_lang' ),
		'param_name' => 'highlight_color',
		'class' => '',
		'value' => '#32B2C3',
		'dependency' => array( 'element' => 'highlight', 'value' => 'enable' ),
		'type' => 'colorpicker',
		 ),		
		array( 
		'heading' => __( 'Title Color', 'gp_lang' ),
		'param_name' => 'title_color',
		'class' => '',
		'value' => '#32B2C3',
		'dependency' => array( 'element' => 'highlight', 'value' => 'disable' ),
		'type' => 'colorpicker',
		 ),	
		array( 
		'heading' => __( 'Highlight Title Color', 'gp_lang' ),
		'param_name' => 'highlight_title_color',
		'class' => '',
		'value' => '#fff',
		'dependency' => array( 'element' => 'highlight', 'value' => 'enable' ),
		'type' => 'colorpicker',
		 ),	
		array( 
		'heading' => __( 'Background Color', 'gp_lang' ),
		'param_name' => 'background_color',
		'class' => '',
		'value' => '#f7f7f7',
		'dependency' => array( 'element' => 'highlight', 'value' => 'disable' ),
		'type' => 'colorpicker',
		 ),		 
		array( 
		'heading' => __( 'Highlight Background Color', 'gp_lang' ),
		'param_name' => 'highlight_background_color',
		'class' => '',
		'value' => '#fff',
		'dependency' => array( 'element' => 'highlight', 'value' => 'enable' ),
		'type' => 'colorpicker',
		 ),		 		 		 
		array( 
		'heading' => __( 'Text Color', 'gp_lang' ),
		'param_name' => 'text_color',
		'class' => '',
		'value' => '#747474',
		'type' => 'colorpicker',
		 ),	
		array( 
		'heading' => __( 'Border', 'gp_lang' ),
		'param_name' => 'border',
		'value' => array( __( 'Enable', 'gp_lang' ) => 'enable', __( 'Disable', 'gp_lang' ) => 'disable' ),
		'type' => 'dropdown',
		 ),			 
		array( 
		'heading' => __( 'Border Color', 'gp_lang' ),
		'param_name' => 'border_color',
		'class' => '',
		'value' => '#e7e7e7',
		'dependency' => array( 'element' => 'border', 'value' => 'enable' ),
		'type' => 'colorpicker',
		 ),	 		 																																							
	 )
 ) );

class WPBakeryShortCode_Pricing_Table extends WPBakeryShortCodesContainer {}
class WPBakeryShortCode_Pricing_Column extends WPBakeryShortCode {}	


/*--------------------------------------------------------------
Progress Bar Shortcode (add-on)
--------------------------------------------------------------*/

vc_add_param( 'vc_progress_bar', array( 
'heading' => __( 'Text Color', 'gp_lang' ),
'param_name' => 'textcolor',
'class' => '',
'description' => __( 'Select custom text color for bars.', 'gp_lang' ),
'type' => 'colorpicker',
 ) );

/*--------------------------------------------------------------
Row Shortcode (add-on)
--------------------------------------------------------------*/

vc_add_param( 'vc_row', array( 
'heading' => __( 'Parallax Scrolling', 'gp_lang' ),
'param_name' => 'parallax_scrolling',
'class' => '',
'value' => array( __( 'Disable', 'gp_lang' ) => '', __( 'Enable', 'gp_lang' ) => 'enable' ),
'description' => __( 'Parallax scrolling for the background image.', 'gp_lang' ),
'type' => 'dropdown',
'dependency' => array( 'element' => 'bg_image', 'not_empty' => true )
) );
vc_add_param( 'vc_row', array( 
'heading' => __( 'Overflow', 'gp_lang' ),
'param_name' => 'overflow',
'class' => '',
'value' => array( __( 'Visible', 'gp_lang' ) => '', __( 'Hidden', 'gp_lang' ) => ' overflow-class' ),
'description' => __( 'The content that overflows from the container.', 'gp_lang' ),
'type' => 'dropdown',
) );


/*--------------------------------------------------------------
Single Image Shortcode (add-on)
--------------------------------------------------------------*/

vc_remove_param( 'vc_single_image', 'css_animation' ); 
vc_remove_param( 'vc_single_image', 'alignment' ); 

vc_add_param( 'vc_single_image', array( 
'heading' => __( 'Animation', 'gp_lang' ),
'param_name' => 'animation',
'class' => '',
'value' => array( __( 'None', 'gp_lang' ) => 'no-animation', __( 'Slide Up', 'gp_lang' ) => 'slideUp', __( 'Slide Down', 'gp_lang' ) => 'slideDown', __( 'Slide Left', 'gp_lang' ) => 'slideLeft', __( 'Slide Right', 'gp_lang' ) => 'slideRight', __( 'Slide Expand Up', 'gp_lang' ) => 'slideExpandUp', __( 'Expand Up', 'gp_lang' ) => 'expandUp', __( 'Fade In', 'gp_lang' ) => 'fadeIn', __( 'Expand Open', 'gp_lang' ) => 'expandOpen', __( 'Big Entrance', 'gp_lang' ) => 'bigEntrance', __( 'Hatch', 'gp_lang' ) => 'hatch', __( 'Bounce', 'gp_lang' ) => 'bounce', __( 'Pulse', 'gp_lang' ) => 'pulse', __( 'Floating', 'gp_lang' ) => 'Floating', __( 'Tossing', 'gp_lang' ) => 'tossing', __( 'Pull Up', 'gp_lang' ) => 'pullUp', __( 'Pull Down', 'gp_lang' ) => 'pullDown', __( 'Stretch Left', 'gp_lang' ) => 'stretchLeft', __( 'Stretch Right', 'gp_lang' ) => 'stretchRight' ),
'description' => __( 'Select the animation effect of this element (only works in modern browsers).', 'gp_lang' ),
'type' => 'dropdown',
 ) );
vc_add_param( 'vc_single_image', array( 
'heading' => __( 'Scroll Animation', 'gp_lang' ),
'param_name' => 'scroll_animation',
'class' => '',
'value' => array( __( 'Disable', 'gp_lang' ) => 'disable', __( 'Enable', 'gp_lang' ) => 'enable' ),
'description' => __( 'Choose whether the animation effect is activated when the element is scrolled into viewed.', 'gp_lang' ),
'type' => 'dropdown',
'dependency' => array( 'element' => 'animation', 'value' => array( 'slideUp', 'slideDown', 'slideLeft', 'slideRight', 'slideExpandUp', 'expandUp', 'fadeIn', 'expandOpen', 'bigEntrance', 'hatch' ) )
) );
vc_add_param( 'vc_single_image', array( 
'heading' => __( 'Delay', 'gp_lang' ),
'param_name' => 'delay',
'class' => '',
'value' => '0.1',
'description' => __( 'The number of seconds to delay the animation effect of the image.', 'gp_lang' ),
'type' => 'textfield',
'dependency' => array( 'element' => 'animation', 'value' => array( 'slideUp', 'slideDown', 'slideLeft', 'slideRight', 'slideExpandUp', 'expandUp', 'fadeIn', 'expandOpen', 'bigEntrance', 'hatch' ) )		
) );							
vc_add_param( 'vc_single_image', array( 
'heading' => __( 'Styling', 'gp_lang' ),
'param_name' => 'styling',
'class' => '',
'value' => '',
'description' => __( 'The styling for the image.', 'gp_lang' ),
'type' => 'textfield',
) );
vc_add_param( 'vc_single_image', array( 
'heading' => __( 'Alignment', 'gp_lang' ),
'param_name' => 'align',
'class' => '',
'value' => array( __( 'Left', 'gp_lang' ) => '', __( 'Center', 'gp_lang' ) => 'vc_align_center', __( 'Right', 'gp_lang' ) => 'vc_align_right', __( 'None', 'gp_lang' ) => 'vc_align_none' ),
'description' => __( 'The alignment of the image.', 'gp_lang' ),
'type' => 'dropdown',
) );


/*--------------------------------------------------------------
Team Shortcode
--------------------------------------------------------------*/

// Team Wrapper
vc_map( array( 
	'name' => __( 'Team', 'gp_lang' ),
	'base' => 'team',
	'as_parent' => array( 'only' => 'team_member' ), 
	'class' => '',
	'controls' => 'full',
	'icon' => 'gp-icon-team',
	'category' => __( 'Content', 'gp_lang' ),
	'js_view' => 'VcColumnView',
	'admin_enqueue_css' => get_template_directory_uri().'/lib/fonts/font-awesome/css/font-awesome.min.css',
	'params' => array( 	
		array( 
		'heading' => __( 'Columns', 'gp_lang' ),
		'param_name' => 'columns',
		'class' => '',
		'value' => '3',
		'description' => __( 'The number of columns.', 'gp_lang' ),
		'type' => 'textfield',
		 ),		
		array( 
		'heading' => __( 'Extra class names', 'gp_lang' ),
		'param_name' => 'classes',
		'class' => '',
		'value' => '',
		'description' => __( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gp_lang' ),
		'type' => 'textfield',
		 ),																																								
	 ),
	'js_view' => 'VcColumnView',
) );

// Team Member
vc_map( array( 
	'name' => __( 'Team Member', 'gp_lang' ),
	'base' => 'team_member',
	'content_element' => true,
	'as_child' => array( 'only' => 'team' ),
	'params' => array( 	
		array( 
		'heading' => __( 'Image', 'gp_lang' ),
		'param_name' => 'image_url',
		'class' => '',
		'value' => '',
		'type' => 'attach_image'
		 ),
		array( 
		'heading' => __( 'Image Width', 'gp_lang' ),
		'param_name' => 'image_width',
		'class' => '',
		'value' => '230',
		'description' => '',
		'type' => 'textfield',
		 ),		
		array( 
		'heading' => __( 'Image Height', 'gp_lang' ),
		'param_name' => 'image_height',
		'class' => '',
		'value' => '230',
		'type' => 'textfield',
		 ),			
		array( 
		'heading' => __( 'Name', 'gp_lang' ),
		'param_name' => 'name',
		'admin_label' => true,
		'class' => '',
		'value' => '',
		'type' => 'textfield'
		 ),	
		array( 
		'heading' => __( 'Position', 'gp_lang' ),
		'param_name' => 'position',
		'class' => '',
		'value' => '',
		'type' => 'textfield',
		 ),				
		array( 
		'heading' => __( 'Description', 'gp_lang' ),
		'param_name' => 'content',
		'class' => '',
		'value' => '',
		'type' => 'textarea_html',
		 ),																																								
	 )
 ) );

class WPBakeryShortCode_Team extends WPBakeryShortCodesContainer {}
class WPBakeryShortCode_Team_Member extends WPBakeryShortCode {}											


/*--------------------------------------------------------------
Testimonials Shortcode
--------------------------------------------------------------*/

// Testimonial Slider
vc_map( array( 
	'name' => __( 'Testimonial Slider', 'gp_lang' ),
	'base' => 'testimonial_slider',
	'as_parent' => array( 'only' => 'testimonial' ), 
	'class' => '',
	'controls' => 'full',
	'icon' => 'gp-icon-testimonial-slider',
	'category' => __( 'Content', 'gp_lang' ),
	'js_view' => 'VcColumnView',
	'admin_enqueue_css' => get_template_directory_uri().'/lib/fonts/font-awesome/css/font-awesome.min.css',
	'params' => array( 	
		array( 
		'heading' => __( 'Effect', 'gp_lang' ),
		'param_name' => 'effect',
		'class' => '',
		'value' => array( __( 'Slide', 'gp_lang' ) => 'slide', __( 'Fade', 'gp_lang' ) => 'fade' ),
		'description' => __( 'The slider effect.', 'gp_lang' ),
		'type' => 'dropdown'
		 ),
		array( 
		'heading' => __( 'Slider Speed', 'gp_lang' ),
		'param_name' => 'speed',
		'class' => '',
		'value' => '0',
		'description' => __( 'The number of seconds between slide transitions, set to 0 to disable the autoplay.', 'gp_lang' ),
		'type' => 'textfield',
		 ),		
		array( 
		'heading' => __( 'Buttons', 'gp_lang' ),
		'param_name' => 'buttons',
		'class' => '',
		'value' => array( __( 'Show', 'gp_lang' ) => 'true', __( 'Hide', 'gp_lang' ) => 'false' ),
		'description' => __( 'The slider buttons.', 'gp_lang' ),
		'type' => 'dropdown',
		 ),				
		array( 
		'heading' => __( 'Extra class names', 'gp_lang' ),
		'param_name' => 'classes',
		'class' => '',
		'value' => '',
		'description' => __( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'gp_lang' ),
		'type' => 'textfield',
		 ),																																								
	 ),
	'js_view' => 'VcColumnView'
 ) );


// Testimonial Slide
vc_map( array( 
	'name' => __( 'Testimonial', 'gp_lang' ),
	'base' => 'testimonial',
	'content_element' => true,
	'as_child' => array( 'only' => 'testimonial_slider' ),
	'icon' => 'gp-icon-testimonial-slider',
	'params' => array( 	
		array( 
		'heading' => __( 'Image', 'gp_lang' ),
		'param_name' => 'image_url',
		'class' => '',
		'value' => '',
		'type' => 'attach_image'
		 ),
		array( 
		'heading' => __( 'Image Width', 'gp_lang' ),
		'param_name' => 'image_width',
		'class' => '',
		'value' => '120',
		'description' => '',
		'type' => 'textfield',
		 ),		
		array( 
		'heading' => __( 'Image Height', 'gp_lang' ),
		'param_name' => 'image_height',
		'class' => '',
		'value' => '120',
		'type' => 'textfield',
		 ),		
		array( 
		'heading' => __( 'Quote', 'gp_lang' ),
		'param_name' => 'quote',
		'class' => '',
		'value' => '',
		'type' => 'textarea',
		 ),		
		array( 
		'heading' => __( 'Name', 'gp_lang' ),
		'param_name' => 'name',
		'class' => '',
		'value' => '',
		'type' => 'textfield',
		 ),																																								
	 )
 ) );

class WPBakeryShortCode_Testimonial_Slider extends WPBakeryShortCodesContainer {}
class WPBakeryShortCode_Testimonial extends WPBakeryShortCode {}																																
 
?>