<?php

$shortname = 'gp';
$page_handle = $shortname . '-options';
$options = array( 


array( 'name' => __( 'General Settings', 'gp_lang' ), 'id' => 'general_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'General Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the general settings for the theme.', 'gp_lang' ) ),

	array( 'type' => 'separator' ),

	array(  
	'name' => __( 'Theme Layout', 'gp_lang' ),
	'id' => $shortname.'_theme_layout',
	'std' => 'gp-wide-layout',
	'options' => array( 'gp-wide-layout' => __( 'Wide', 'gp_lang' ), 'gp-boxed-layout' => __( 'Boxed', 'gp_lang' ) ),
	'type' => 'radio',
	),

	array( 'type' => 'separator' ),
								
	array(  
	'name' => __( 'Responsive', 'gp_lang' ),
	'desc' => __( 'The theme responds to the width of the browser window.', 'gp_lang' ),
	'id' => $shortname.'_responsive',
	'std' => 'gp-responsive',
	'options' => array( 'gp-responsive' => __( 'Enable', 'gp_lang' ), 'gp-fixed' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
			
	array( 'type' => 'separator' ),
							
	array(  
	'name' => __( 'Retina Images', 'gp_lang' ),
	'desc' => __( 'Crop images at double the size on retina displays ( newer iPhones/iPads, Macbook Pro etc. ).', 'gp_lang' ),
	'id' => $shortname.'_retina',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
			
	array( 'type' => 'separator' ),
					
	array(  
	'name' => __( 'Smooth Scrolling', 'gp_lang' ),
	'id' => $shortname.'_smooth_scrolling',
	'std' => 'gp-smooth-scrolling',
	'options' => array( 'gp-smooth-scrolling' => __( 'Enable', 'gp_lang' ), 'gp-normal-scrolling' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio'
	 ),

	array( 'type' => 'separator' ),
					
	array(  
	'name' => __( 'Back To Top Button', 'gp_lang' ),
	'id' => $shortname.'_back_to_top',
	'std' => 'gp-back-to-top',
	'options' => array( 'gp-back-to-top' => __( 'Enable', 'gp_lang' ), 'gp-no-back-to-top' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio'
	 ),

	array( 'type' => 'separator' ),
	
	array(  
	'name' => __( 'RSS Feed Button', 'gp_lang' ),
	'desc' => __( 'Add a RSS feed button with the default RSS feed link or enter a custom feed link below.', 'gp_lang' ),
	'id' => $shortname.'_rss_button',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio'
	 ),
	
	array( 
	'name' => __( 'RSS URL', 'gp_lang' ),
	'id' => $shortname.'_rss',
	'type' => 'text',
	'std' => 'http://',
	 ),
	
	array( 
	'name' => __( 'Twitter URL', 'gp_lang' ),
	'id' => $shortname.'_twitter',
	'type' => 'text',
	'std' => 'http://',
	 ),
	
	array( 
	'name' => __( 'Facebook URL', 'gp_lang' ),
	'id' => $shortname.'_facebook',
	'type' => 'text',
	'std' => 'http://',
	 ),

	array( 
	'name' => __( 'YouTube URL', 'gp_lang' ),
	'id' => $shortname.'_youtube',
	'type' => 'text',
	'std' => 'http://',
	 ),
	
	array( 
	'name' => __( 'Google+ URL', 'gp_lang' ),
	'id' => $shortname.'_googleplus',
	'type' => 'text',
	'std' => 'http://',
	 ),
	
	array( 
	'name' => __( 'LinkedIn URL', 'gp_lang' ),
	'id' => $shortname.'_linkedin',
	'type' => 'text',
	'std' => 'http://',
	 ),
			
	array( 
	'name' => __( 'Flickr URL', 'gp_lang' ),
	'id' => $shortname.'_flickr',
	'type' => 'text',
	'std' => 'http://',
	 ),

	array( 
	'name' => __( 'Pinterest URL', 'gp_lang' ),
	'id' => $shortname.'_pinterest',
	'type' => 'text',
	'std' => 'http://',
	 ),
			
	array( 
	'name' => __( 'Additional Social Icons', 'gp_lang' ),
	'desc' => __( 'Add additional social icons by entering the following <code>&lt;a href=&quot;http://social-link.com&quot; rel=&quot;nofollow&quot; target=&quot;_blank&quot; class=&quot;fa fa-tumblr-square&quot;&gt;&lt;/a&gt;</code>. Replace <code>fa-tumblr-square</code> with any of the icon names from <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_blank">Font Awesome More</a>.', 'gp_lang' ),
	'id' => $shortname.'_additional_social_icons',
	'type' => 'textarea' ),
		
	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Favicon URL ( .ico )', 'gp_lang' ),
	'desc' => __( 'Favicon image ( .ico, 16x16 or 32x32 )', 'gp_lang' ),
	'id' => $shortname.'_favicon_ico',
	'type' => 'upload'
	 ),

	array( 
	'name' => __( 'Favicon URL ( .png )', 'gp_lang' ),
	'desc' => __( 'Favicon image ( .png, 16x16 or 32x32 )', 'gp_lang' ),
	'id' => $shortname.'_favicon_png',
	'type' => 'upload'
	 ),
	
	 array( 
	'name' => __( 'Apple Icon URL ( .png )', 'gp_lang' ),
	'desc' => __( 'Apple icon image ( .png, 57x57 ), used for display on the Apple iPhone', 'gp_lang' ),
	'id' => $shortname.'_apple_icon',
	'type' => 'upload'
	 ),
	
	array( 'type' => 'separator' ), 
			
	array( 
	'name' => __( 'Scripts', 'gp_lang' ),
	'desc' => __( 'Scripts that need to be embedded into your theme ( e.g. Google Analytics ).', 'gp_lang' ),
	'id' => $shortname.'_scripts',
	'type' => 'textarea'
	 ),
	
array( 'type' => 'close' ),	


array( 'name' => __( 'Header Settings', 'gp_lang' ), 'id' => 'header_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'Header Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the header settings.', 'gp_lang' )
	 ),

	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Layout', 'gp_lang' ),
	'id' => $shortname.'_header_layout',
	'std' => 'gp-header-1',
	'options' => array( 'gp-header-1' => __( 'Header 1', 'gp_lang' ), 'gp-header-2' => __( 'Header 2', 'gp_lang' ), 'gp-header-3' => __( 'Header 3', 'gp_lang' ), 'gp-header-4' => __( 'Header 4', 'gp_lang' ) ),
	'type' => 'radio',
	),
	 
	array( 'type' => 'separator' ),

	array(  
	'name' => __( 'Fixed Header', 'gp_lang' ),
	'id' => $shortname.'_fixed_header',
	'std' => 'gp-fixed-header',
	'options' => array( 'gp-fixed-header' => __( 'Enable', 'gp_lang' ), 'gp-relative-header' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio',
	),

	array( 'type' => 'separator' ),

	array(  
	'name' => __( 'Header Resize', 'gp_lang' ),
	'id' => $shortname.'_header_resize',
	'desc' => __( 'The header reduces in size as you scroll down the page.', 'gp_lang' ),
	'std' => 'gp-header-resize',
	'options' => array( 'gp-header-resize' => __( 'Enable', 'gp_lang' ), 'gp-header-noresize' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio',
	),
	
	array( 
	'name' => __( 'Header Size Reduction', 'gp_lang' ),
	'id' => $shortname.'_header_size_reduction',
	'desc' => __( 'The amount to reduce the header by on smaller devices or when scrolling.', 'gp_lang' ),
	'type' => 'text',
	'std' => '1.5',
	'details' => ' times smaller',
	'size' => 'small',
	),	
	  
	array( 'type' => 'separator' ),	  
	  			
	array( 
	'name' => __( 'Custom Logo Image', 'gp_lang' ),
	'id' => $shortname.'_logo',
	'type' => 'upload'
	 ),
	
	array( 'type' => 'option_open', 'name' => __( 'Logo Dimensions', 'gp_lang' ) ),
	 
		array( 
		'id' => $shortname.'_logo_width',
		'std' => '220',
		'type' => 'text',
		'size' => 'small',
		'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X',
		'stripped' => 'true',
		 ),
		
		array( 
		'id' => $shortname.'_logo_height',
		'std' => '62',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ),
	
	array( 'type' => 'option_close', 'desc' => __( 'Set to half the original logo dimensions for retina displays.', 'gp_lang' ) ),

	array( 'type' => 'option_open', 'name' => __( 'Logo Margins', 'gp_lang' ) ),
	 								
		array( 
		'id' => $shortname.'_logo_top',
		'std' => '0',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ),
		
		array( 
		'id' => $shortname.'_logo_right',
		'std' => '0',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ),	
			
		array( 
		'id' => $shortname.'_logo_bottom',
		'std' => '0',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',	
		'stripped' => 'true',
		 ),
		
		array( 
		'id' => $shortname.'_logo_left',
		'std' => '0',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ),

	array( 'type' => 'option_close', 'desc' => __( 'The top, right, bottom and left logo margins.', 'gp_lang' ) ),
	
	array( 'type' => 'separator' ), 

	array(  
	'name' => __( 'Search Form', 'gp_lang' ),
	'desc' => __( 'Add a search button to the header to slide the search form up/down.', 'gp_lang' ),
	'id' => $shortname.'_search',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio'
	 ),

array( 'type' => 'close' ),	
	

array( 'name' => __( 'Footer Settings', 'gp_lang' ), 'id' => 'footer_settings', 'type' => 'open', ),

	array( 
	'name' => __( 'Footer Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the footer settings.', 'gp_lang' )
	 ),

	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Copyright Text', 'gp_lang' ),
	'desc' => __( 'Add copyright text to the footer.', 'gp_lang' ),
	'id' => $shortname.'_footer_content',
	'type' => 'textarea' ),		
	
array( 'type' => 'close' ),	


array( 'name' => __( 'Category Settings', 'gp_lang' ), 'type' => 'open' ),

	array( 
	'name' => __( 'Category Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the global settings for all category, archive, tag, search and author pages.', 'gp_lang' ) ),

	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Page Layout', 'gp_lang' ),
	'id' => $shortname.'_cat_layout',
	'std' => 'right-sidebar',
	'options' => array( 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ),
	'type' => 'select' ),

	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Sidebar', 'gp_lang' ),
	'id' => $shortname.'_cat_sidebar',
	'std' => 'gp-standard-sidebar',
	'type' => 'select_sidebar' ),

	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Blog Type', 'gp_lang' ),
	'id' => $shortname.'_cat_blog_type',
	'std' => 'blog-standard',
	'options' => array( 'blog-standard' => __( 'Standard', 'gp_lang' ), 'blog-masonry' => __( 'Masonry', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Posts Per Page', 'gp_lang' ),
	'id' => $shortname.'_cat_per_page',
	'std' => '10',
	'type' => 'text',
	'size' => 'small',
	),
		
	array( 'type' => 'separator' ),
						
	array(  
	'name' => __( 'Featured Image', 'gp_lang' ),
	'id' => $shortname.'_cat_featured_image',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 'type' => 'option_open', 'name' => __( 'Image Dimensions', 'gp_lang' ) ),			
					
		array( 
		'id' => $shortname.'_cat_image_width',
		'std' => '700',
		'type' => 'text',
		'size' => 'small',
		'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X',
		'stripped' => 'true',
		 ), 

		array( 
		'id' => $shortname.'_cat_image_height',
		'std' => '400',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ), 
	
	array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),

	array( 
	'name' => __( 'Hard Crop', 'gp_lang' ),
	'desc' => __( 'Image is cropped even if it is smaller than the dimensions you want to crop it to.', 'gp_lang' ),
	'id' => $shortname.'_cat_hard_crop',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array( 
	'name' => __( 'Image Wrap', 'gp_lang' ),
	'desc' => __( 'The page content wraps around the featured image.', 'gp_lang' ),
	'id' => $shortname.'_cat_image_wrap',
	'std' => 'disable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
		
	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Page Title Header', 'gp_lang' ),
	'id' => $shortname.'_cat_title_header',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 
	'name' => __( 'Page Title Image', 'gp_lang' ),
	'id' => $shortname.'_cat_title_header_image',
	'type' => 'upload' ),

	array( 
	'name' => __( 'Page Title Color', 'gp_lang' ),
	'id' => $shortname.'_cat_title_header_color',
	'type' => 'colorpicker',
	'size' => 'small',
	 ),
	
	array( 
	'name' => __( 'Page Title Padding', 'gp_lang' ),
	'desc' => __( 'Supports px, em, %.', 'gp_lang' ),
	'id' => $shortname.'_cat_title_header_padding',
	'std' => '',
	'type' => 'text',
	'size' => 'small',
	 ),

	array( 
	'name' => __( 'Parallax Effect', 'gp_lang' ),
	'desc' => __( 'Parallax scroll effect of the page title image.', 'gp_lang' ),
	'id' => $shortname.'_cat_title_header_parallax',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 'type' => 'separator' ),
			
	array( 
	'name' => __( 'Content Display', 'gp_lang' ),
	'id' => $shortname.'_cat_content_display',
	'std' => 'excerpt',
	'options' => array( 'excerpt' => __( 'Excerpt', 'gp_lang' ), 'full_content' => __( 'Full Content', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Excerpt Length', 'gp_lang' ),
	'desc' => __( 'The number of characters in an excerpt.', 'gp_lang' ),
	'id' => $shortname.'_cat_excerpt_length',
	'std' => '400',
	'type' => 'text',
	'size' => 'small' ),

	array( 'type' => 'separator' ),

	array(  
	'name' => __( 'Read More Link', 'gp_lang' ),
	'id' => $shortname.'_cat_read_more',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array(  
	'name' => __( 'Post Date', 'gp_lang' ),
	'id' => $shortname.'_cat_date',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array(  
	'name' => __( 'Post Author', 'gp_lang' ),
	'id' => $shortname.'_cat_author',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array(  
	'name' => __( 'Post Categories', 'gp_lang' ),
	'id' => $shortname.'_cat_cats',
	'std' => 'disable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array(  
	'name' => __( 'Post Comment Number', 'gp_lang' ),
	'id' => $shortname.'_cat_comments',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
			
	array(  
	'name' => __( 'Post Tags', 'gp_lang' ),
	'id' => $shortname.'_cat_tags',
	'std' => 'disable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
						   
array( 'type' => 'close' ),


array( 'name' => __( 'Post Settings', 'gp_lang' ), 'id' => 'post_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'Post Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the global settings for all posts, but most settings can be overridden on individual posts.', 'gp_lang' ) ),

	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Page Layout', 'gp_lang' ),
	'id' => $shortname.'_post_layout',
	'std' => 'right-sidebar',
	'options' => array( 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ),
	'type' => 'select' ),

	array( 'type' => 'separator' ),
	 
	array( 
	'name' => __( 'Sidebar', 'gp_lang' ),
	'id' => $shortname.'_post_sidebar',
	'std' => 'gp-standard-sidebar',
	'type' => 'select_sidebar' ),

	array( 'type' => 'separator' ),
					
	array(  
	'name' => __( 'Featured Image', 'gp_lang' ),
	'id' => $shortname.'_post_featured_image',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array( 'type' => 'option_open', 'name' => __( 'Image Dimensions', 'gp_lang' ) ),			
				
		array( 
		'id' => $shortname.'_post_image_width',
		'std' => '700',
		'type' => 'text',
		'size' => 'small',
		'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X',
		'stripped' => 'true',
		 ), 

		array( 
		'id' => $shortname.'_post_image_height',
		'std' => '400',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ), 
	
	array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),

	array( 
	'name' => __( 'Hard Crop', 'gp_lang' ),
	'desc' => __( 'Image is cropped even if it is smaller than the dimensions you want to crop it to.', 'gp_lang' ),
	'id' => $shortname.'_post_hard_crop',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array( 
	'name' => __( 'Image Wrap', 'gp_lang' ),
	'desc' => __( 'The page content wraps around the featured image.', 'gp_lang' ),
	'id' => $shortname.'_post_image_wrap',
	'std' => 'disable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
						   
	array( 'type' => 'separator' ),
	
	array(  
	'name' => __( 'Post Author', 'gp_lang' ),
	'id' => $shortname.'_post_author',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array(  
	'name' => __( 'Post Date', 'gp_lang' ),
	'id' => $shortname.'_post_date',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array(  
	'name' => __( 'Post Categories', 'gp_lang' ),
	'id' => $shortname.'_post_cats',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array(  
	'name' => __( 'Post Comment Number', 'gp_lang' ),
	'id' => $shortname.'_post_comments',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array(  
	'name' => __( 'Post Tags', 'gp_lang' ),
	'id' => $shortname.'_post_tags',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array( 'type' => 'separator' ),
	
	 array( 
	'name' => __( 'Author Info Panel', 'gp_lang' ),
	'id' => $shortname.'_post_author_info',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Related Items', 'gp_lang' ),
	'desc' => __( 'Display a related items section.', 'gp_lang' ), 
	'id' => $shortname.'_post_related_items',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 
	'name' => __( 'Number Of Related Items', 'gp_lang' ),
	'id' => $shortname.'_post_related_per_page',
	'std' => '4',
	'type' => 'text',
	'size' => 'small',
	 ),

	array( 'type' => 'option_open', 'name' => __( 'Image Dimensions', 'gp_lang' ) ),							
							
		array( 
		'id' => $shortname.'_post_related_image_width',
		'std' => '161',
		'type' => 'text',
		'size' => 'small',
		'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X',
		'stripped' => 'true',
		 ), 

		array( 
		'id' => $shortname.'_post_related_image_height',
		'std' => '141',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ), 

	array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),

array( 'type' => 'close' ),


array( 'name' => __( 'Page Settings', 'gp_lang' ), 'id' => 'page_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'Page Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the global settings for all pages, but most settings can be overridden on individual pages.', 'gp_lang' ) ),

	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Page Layout', 'gp_lang' ),
	'id' => $shortname.'_page_layout',
	'std' => 'right-sidebar',
	'options' => array( 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ),
	'type' => 'select' ),

	array( 'type' => 'separator' ), 
	
	array( 
	'name' => __( 'Sidebar', 'gp_lang' ),
	'id' => $shortname.'_page_sidebar',
	'std' => 'gp-standard-sidebar',
	'type' => 'select_sidebar' ),
	
	array( 'type' => 'separator' ),
									
	array(  
	'name' => __( 'Featured Image', 'gp_lang' ),
	'id' => $shortname.'_page_featured_image',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array( 'type' => 'option_open', 'name' => __( 'Image Dimensions', 'gp_lang' ) ),			
				
		array( 
		'id' => $shortname.'_page_image_width',
		'std' => '700',
		'type' => 'text',
		'size' => 'small',
		'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X',
		'stripped' => 'true',
		 ), 

		array( 
		'id' => $shortname.'_page_image_height',
		'std' => '400',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ), 
	
	array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),

	array( 
	'name' => __( 'Hard Crop', 'gp_lang' ),
	'desc' => __( 'Image is cropped even if it is smaller than the dimensions you want to crop it to.', 'gp_lang' ),
	'id' => $shortname.'_page_hard_crop',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
	array( 
	'name' => __( 'Image Wrap', 'gp_lang' ),
	'desc' => __( 'The page content wraps around the featured image.', 'gp_lang' ),
	'id' => $shortname.'_page_image_wrap',
	'std' => 'disable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
					
	array( 'type' => 'separator' ),
			
	array( 
	'name' => __( 'Page Title Header', 'gp_lang' ),
	'id' => $shortname.'_page_title_header',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 
	'name' => __( 'Page Title Image', 'gp_lang' ),
	'id' => $shortname.'_page_title_header_image',
	'type' => 'upload'
	),

	array( 
	'name' => __( 'Page Title Color', 'gp_lang' ),
	'id' => $shortname.'_page_title_header_color',
	'type' => 'colorpicker',
	 ),
	
	array( 
	'name' => __( 'Page Title Padding', 'gp_lang' ),
	'desc' => __( 'Supports px, em, %.', 'gp_lang' ),
	'id' => $shortname.'_page_title_header_padding',
	'size' => 'small',
	'type' => 'text',
	 ),

	array( 
	'name' => __( 'Parallax Effect', 'gp_lang' ),
	'desc' => __( 'Parallax scroll effect of the page title image..', 'gp_lang' ),
	'id' => $shortname.'_page_title_header_parallax',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio'
	 ),
					
	array( 'type' => 'separator' ),
	
	array(  
	'name' => __( 'Author Info Panel', 'gp_lang' ),
	'id' => $shortname.'_page_author_info',
	'std' => 'disable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
	
array( 'type' => 'close' ),
	

array( 'name' => __( 'Portfolio Category Settings', 'gp_lang' ), 'id' => 'portfolio_cat_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'Portfolio Category Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the global settings for all portfolio categories, but most settings can be overridden on individual pages using the Portfolio page template.', 'gp_lang' ) ),

	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Page Layout', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_layout',
	'std' => 'no-sidebar',
	'options' => array( 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ),
	'type' => 'select' ),

	array( 'type' => 'separator' ), 

	array( 
	'name' => __( 'Sidebar', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_sidebar',
	'std' => 'gp-standard-sidebar',
	'type' => 'select_sidebar' ),

	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Slug', 'gp_lang' ),
	'desc' => __( 'Custom slug used in the URL for portfolio categories e.g. ', 'gp_lang' ) . 'http://domain.com/<strong>portfolios</strong>/item-name.<br/><br/><strong>' . __( 'After changing the slug, go to', 'gp_lang') . ' <a href="'.admin_url( 'options-permalink.php' ).'">' . __( 'Settings -> Permalinks' ,'gp_lang' ) . '</a> ' . __( 'and click Save Changes.', 'gp_lang' ) . '</strong>',
	'id' => $shortname.'_portfolio_cat_slug',
	'std' => 'portfolios',
	'type' => 'text',
	 ),

	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Portfolio Type', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_type',
	'std' => 'portfolio-columns-3',
	'options' => array( 'portfolio-columns-2' => __( '2 Columns', 'gp_lang' ), 'portfolio-columns-3' => __( '3 Columns', 'gp_lang' ), 'portfolio-columns-4' => __( '4 Columns', 'gp_lang' ), 'portfolio-columns-5' => __( '5 Columns', 'gp_lang' ), 'portfolio-columns-6' => __( '6 Columns', 'gp_lang' ), 'portfolio-masonry' => __( 'Masonry', 'gp_lang' ) ),
	'type' => 'select' ),
		
	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Portfolio Filter', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_filter',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
		
	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Portfolio Items Per Page', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_per_page',
	'std' => '10',
	'type' => 'text',
	'size' => 'small',
	),
		
	array( 'type' => 'separator' ),
			 	
	array( 
	'name' => __( 'Page Title Header', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_title_header',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 
	'name' => __( 'Page Title Image', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_title_header_image',
	'type' => 'upload' ),

	array( 
	'name' => __( 'Page Title Color', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_title_header_color',
	'type' => 'colorpicker',
	'size' => 'small',
	 ),
	
	array( 
	'name' => __( 'Page Title Padding', 'gp_lang' ),
	'desc' => __( 'Supports px, em, %.', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_title_header_padding',
	'std' => '',
	'type' => 'text',
	'size' => 'small',
	 ),

	array( 
	'name' => __( 'Parallax Effect', 'gp_lang' ),
	'desc' => __( 'Parallax scroll effect of the page title image.', 'gp_lang' ),
	'id' => $shortname.'_portfolio_cat_title_header_parallax',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 'type' => 'close' ), 


array( 'name' => __( 'Portfolio Item Settings', 'gp_lang' ), 'id' => 'portfolio_item_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'Portfolio Item Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the global settings for all portfolio items, but most settings can be overridden on individual pages.', 'gp_lang' ) ),

	array( 'type' => 'separator' ),
		
	array( 
	'name' => __( 'Page Layout', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_layout',
	'std' => 'no-sidebar',
	'options' => array( 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ),
	'type' => 'select' ),
	
	array( 'type' => 'separator' ),
			
	array( 
	'name' => __( 'Sidebar', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_sidebar',
	'std' => 'gp-standard-sidebar',
	'type' => 'select_sidebar' ),
				
	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Slug', 'gp_lang' ),
	'desc' => __( 'Custom slug used in the URL for portfolio items e.g. ', 'gp_lang' ) . 'http://domain.com/<strong>portfolio-item</strong>/item-name.<br/><br/><strong>' . __( 'After changing the slug, go to', 'gp_lang') . ' <a href="'.admin_url( 'options-permalink.php' ).'">' . __( 'Settings -> Permalinks' ,'gp_lang' ) . '</a> ' . __( 'and click Save Changes.', 'gp_lang' ) . '</strong>',
	'id' => $shortname.'_portfolio_item_slug',
	'std' => 'portfolio-item',
	'type' => 'text',
	 ),

	array( 'type' => 'separator' ),
		
	array( 
	'name' => __( 'Image/Slider Type', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_type',
	'std' => 'left-image',
	'options' => array( 'left-image' => __( 'Left Featured Image', 'gp_lang' ), 'fullwidth-image' => __( 'Fullwidth Featured Image', 'gp_lang' ), 'left-slider' => __( 'Left Slider', 'gp_lang' ), 'fullwidth-slider' => __( 'Fullwidth Slider', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'select' ),

	array( 'type' => 'option_open', 'name' => __( 'Image/Slider Dimensions', 'gp_lang' ) ),			
					
		array( 
		'id' => $shortname.'_portfolio_item_image_width',
		'std' => '685',
		'type' => 'text',
		'size' => 'small',
		'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X',
		'stripped' => 'true',
		 ), 

		array( 
		'id' => $shortname.'_portfolio_item_image_height',
		'std' => '0',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ), 
	
	array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),

	array( 
	'name' => __( 'Hard Crop', 'gp_lang' ),
	'desc' => __( 'Image is cropped even if it is smaller than the dimensions you want to crop it to.', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_hard_crop',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),
			
	array( 'type' => 'separator' ),
		
	array( 
	'name' => __( 'Link Text', 'gp_lang' ),	
	'id' => $shortname.'_portfolio_item_link_text',
	'std' => 'Website',
	'type' => 'text',
	), 

	array( 
	'name' => __( 'Link Target', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_link_target',
	'std' => '_blank',
	'options' => array( '_blank' => __( 'New Window', 'gp_lang' ), '_self' => __( 'Same Window', 'gp_lang' ) ),
	'type' => 'radio'
	),
		 
	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Page Title Header', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_title_header',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio'
	),

	array( 
	'name' => __( 'Page Title Image', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_title_header_image',
	'type' => 'upload'
	),

	array( 
	'name' => __( 'Page Title Color', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_title_header_color',
	'type' => 'colorpicker'
	 ),
	
	array( 
	'name' => __( 'Page Title Padding', 'gp_lang' ),
	'desc' => __( 'Supports px, em, %.', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_title_header_padding',
	'std' => '',
	'type' => 'text',
	'size' => 'small',
	 ),

	array( 
	'name' => __( 'Parallax Effect', 'gp_lang' ),
	'desc' => __( 'Parallax scroll effect of the page title image.', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_title_header_parallax',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Related Items', 'gp_lang' ),
	'desc' => __( 'Display a related items section.', 'gp_lang' ), 
	'id' => $shortname.'_portfolio_item_related_items',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 
	'name' => __( 'Number Of Related Items', 'gp_lang' ),
	'id' => $shortname.'_portfolio_item_related_per_page',
	'std' => '4',
	'type' => 'text',
	'size' => 'small',
	 ),

	array( 'type' => 'option_open', 'name' => __( 'Image Dimensions', 'gp_lang' ) ),							
							
		array( 
		'id' => $shortname.'_portfolio_item_related_image_width',
		'std' => '161',
		'type' => 'text',
		'size' => 'small',
		'details' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;X',
		'stripped' => 'true',
		 ), 

		array( 
		'id' => $shortname.'_portfolio_item_related_image_height',
		'std' => '141',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		 ), 

	array( 'type' => 'option_close', 'desc' => __( 'Set height to 0 to have a proportionate height.', 'gp_lang' ) ),

	array( 'type' => 'close' ),
		 	
	
array( 'name' => __( 'WooCommerce Settings', 'gp_lang' ), 'id' => 'woocommerce_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'WooCommerce Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the global settings for all WooCommerce pages, but most settings can be overridden on individual pages.', 'gp_lang' ) ),
			
	array( 'type' => 'separator' ),

	array(  
	'name' => __( 'Dropdown Cart', 'gp_lang' ),
	'desc' => __( 'Add a cart button to the header to slide the shopping cart up/down.', 'gp_lang' ),
	'id' => $shortname.'_cart',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio'
	 ),
					
	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Shop Page Layout', 'gp_lang' ),
	'id' => $shortname.'_shop_layout',
	'std' => 'no-sidebar',
	'options' => array( 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ),
	'type' => 'select' ),

	array( 'type' => 'separator' ), 
	
	array( 
	'name' => __( 'Shop Sidebar', 'gp_lang' ),
	'id' => $shortname.'_shop_sidebar',
	'std' => 'gp-woocommerce-sidebar',
	'type' => 'select_sidebar' ),
	
	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'Shop Page Title Header', 'gp_lang' ),
	'id' => $shortname.'_shop_title_header',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 
	'name' => __( 'Shop Page Title Image', 'gp_lang' ),
	'id' => $shortname.'_shop_title_header_image',
	'type' => 'upload' ),

	array( 
	'name' => __( 'Shop Page Title Color', 'gp_lang' ),
	'id' => $shortname.'_shop_title_header_color',
	'type' => 'colorpicker',
	'size' => 'small',
	 ),
	
	array( 
	'name' => __( 'Shop Page Title Padding', 'gp_lang' ),
	'desc' => __( 'Supports px, em, %.', 'gp_lang' ),
	'id' => $shortname.'_shop_title_header_padding',
	'std' => '',
	'type' => 'text',
	'size' => 'small',
	 ),

	array( 
	'name' => __( 'Shop Parallax Effect', 'gp_lang' ),
	'desc' => __( 'Parallax scroll effect of the page title image.', 'gp_lang' ),
	'id' => $shortname.'_shop_title_header_parallax',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 'type' => 'separator' ),
		
	array( 
	'name' => __( 'Product Page Layout', 'gp_lang' ),
	'id' => $shortname.'_product_layout',
	'std' => 'no-sidebar',
	'options' => array( 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ),
	'type' => 'select' ),

	array( 'type' => 'separator' ), 
	
	array( 
	'name' => __( 'Product Sidebar', 'gp_lang' ),
	'id' => $shortname.'_product_sidebar',
	'std' => 'gp-woocommerce-sidebar',
	'type' => 'select_sidebar' ),
	
	array( 'type' => 'close' ),


array( 'name' => __( 'BuddyPress/bbPress Settings', 'gp_lang' ), 'id' => 'buddypress_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'BuddyPress/bbPress Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'Controls the global settings for all BuddyPress and bbPress pages, but most settings can be overridden on individual pages.', 'gp_lang' ) ),
			
	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'BuddyPress Page Layout', 'gp_lang' ),
	'id' => $shortname.'_bp_layout',
	'std' => 'no-sidebar',
	'options' => array( 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ),
	'type' => 'select' ),

	array( 'type' => 'separator' ), 
	
	array( 
	'name' => __( 'BuddyPress Sidebar', 'gp_lang' ),
	'id' => $shortname.'_bp_sidebar',
	'std' => 'gp-standard-sidebar',
	'type' => 'select_sidebar' ),
	
	array( 'type' => 'separator' ),
	
	array( 
	'name' => __( 'bbPress Page Layout', 'gp_lang' ),
	'id' => $shortname.'_bbpress_layout',
	'std' => 'no-sidebar',
	'options' => array( 'left-sidebar' => __( 'Left Sidebar', 'gp_lang' ), 'right-sidebar' => __( 'Right Sidebar', 'gp_lang' ), 'no-sidebar' => __( 'No Sidebar', 'gp_lang' ), 'fullwidth' => __( 'Fullwidth', 'gp_lang' ) ),
	'type' => 'select' ),

	array( 'type' => 'separator' ), 
	
	array( 
	'name' => __( 'bbPress Sidebar', 'gp_lang' ),
	'id' => $shortname.'_bbpress_sidebar',
	'std' => 'gp-standard-sidebar',
	'type' => 'select_sidebar' ),

	array( 'type' => 'separator' ),
			
	array( 
	'name' => __( 'Page Title Header', 'gp_lang' ),
	'id' => $shortname.'_bp_title_header',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio' ),

	array( 
	'name' => __( 'Page Title Image', 'gp_lang' ),
	'id' => $shortname.'_bp_title_header_image',
	'type' => 'upload'
	),

	array( 
	'name' => __( 'Page Title Color', 'gp_lang' ),
	'id' => $shortname.'_bp_title_header_color',
	'type' => 'colorpicker',
	 ),
	
	array( 
	'name' => __( 'Page Title Padding', 'gp_lang' ),
	'desc' => __( 'Supports px, em, %.', 'gp_lang' ),
	'id' => $shortname.'_bp_title_header_padding',
	'size' => 'small',
	'type' => 'text',
	 ),

	array( 
	'name' => __( 'Parallax Effect', 'gp_lang' ),
	'desc' => __( 'Parallax scroll effect of the page title image..', 'gp_lang' ),
	'id' => $shortname.'_bp_title_header_parallax',
	'std' => 'enable',
	'options' => array( 'enable' => __( 'Enable', 'gp_lang' ), 'disable' => __( 'Disable', 'gp_lang' ) ),
	'type' => 'radio'
	 ),
	 	
	array( 'type' => 'close' ),
			
				
array( 'name' => __( 'Style Settings', 'gp_lang' ), 'id' => 'style_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'Style Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'This section provides you with some basic settings to change the look of the theme. If you want to customize the design of the theme further you can add your own CSS styling in the "CSS Settings" tab.', 'gp_lang' ) ),

	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Colors', 'gp_lang' ),	
	'type' => 'subheader',
	 ),		

	array( 'type' => 'option_open', 'name' => __('General', 'gp_lang') ),
					
		array( 
		'name' => __( 'Page Background', 'gp_lang' ),
		'id' => $shortname.'_bg_color',
		'type' => 'colorpicker',
		'std' => '#fff',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Primary', 'gp_lang' ),
		'id' => $shortname.'_primary_color',
		'type' => 'colorpicker',
		'std' => '#32B2C3',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Secondary', 'gp_lang' ),
		'id' => $shortname.'_secondary_color',
		'type' => 'colorpicker',
		'std' => '#2c2c2c',
		'stripped' => 'true',
		),
									 
		array( 
		'name' => __( 'Primary Text', 'gp_lang' ),
		'id' => $shortname.'_primary_text_color',
		'type' => 'colorpicker',
		'std' => '#747474',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Secondary Text', 'gp_lang' ),
		'id' => $shortname.'_secondary_text_color',
		'type' => 'colorpicker',
		'std' => '#fff',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Tertiary Text', 'gp_lang' ),
		'id' => $shortname.'_tertiary_text_color',
		'type' => 'colorpicker',
		'std' => '#aaa',
		'stripped' => 'true',
		),

		array( 'type' => 'spacer' ),
					
		array( 
		'name' => __( 'Alternative Background', 'gp_lang' ),
		'id' => $shortname.'_alt_bg_color',
		'type' => 'colorpicker',
		'std' => '#f7f7f7',
		'stripped' => 'true',
		),		

		array( 
		'name' => __( 'Border', 'gp_lang' ),
		'id' => $shortname.'_border_color',
		'type' => 'colorpicker',
		'std' => '#e7e7e7',
		'stripped' => 'true',
		),		
										
	array( 'type' => 'option_close', 'desc' => 'The main colours used throughout the theme for text, links, forms, buttons etc.' ),

	array( 'type' => 'option_open', 'name' => __('Header', 'gp_lang') ),

		array( 
		'name' => __( 'Background', 'gp_lang' ),
		'id' => $shortname.'_header_bg_color',
		'type' => 'colorpicker',
		'std' => '#222',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Text Color', 'gp_lang' ),
		'id' => $shortname.'_header_text_color',
		'type' => 'colorpicker',
		'std' => '#fff',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Link Color', 'gp_lang' ),
		'id' => $shortname.'_header_link_color',
		'type' => 'colorpicker',
		'std' => '#fff',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Link Hover Color', 'gp_lang' ),
		'id' => $shortname.'_header_link_hover_color',
		'type' => 'colorpicker',
		'std' => '#32B2C3',
		'stripped' => 'true',
		),
				
	array( 'type' => 'option_close' ),

	array( 'type' => 'option_open', 'name' => __('Header Dropdown Menus', 'gp_lang') ),

		array( 
		'name' => __( 'Background', 'gp_lang' ),
		'id' => $shortname.'_header_dropdown_bg_color',
		'type' => 'colorpicker',
		'std' => '#fff',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Background Hover', 'gp_lang' ),
		'id' => $shortname.'_header_dropdown_bg_hover_color',
		'type' => 'colorpicker',
		'std' => '#f7f7f7',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Border', 'gp_lang' ),
		'id' => $shortname.'_header_dropdown_border_color',
		'type' => 'colorpicker',
		'std' => '#e7e7e7',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Heading Color', 'gp_lang' ),
		'id' => $shortname.'_header_dropdown_heading_color',
		'type' => 'colorpicker',
		'std' => '#32B2C3',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Link Color', 'gp_lang' ),
		'id' => $shortname.'_header_dropdown_link_color',
		'type' => 'colorpicker',
		'std' => '#747474',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Link Hover Color', 'gp_lang' ),
		'id' => $shortname.'_header_dropdown_link_hover_color',
		'type' => 'colorpicker',
		'std' => '#32B2C3',
		'stripped' => 'true',
		),
				
	array( 'type' => 'option_close' ),
		
	array( 'type' => 'option_open', 'name' => __('Top Header', 'gp_lang') ),
		
		array( 
		'name' => __( 'Background', 'gp_lang' ),
		'id' => $shortname.'_top_header_bg_color',
		'type' => 'colorpicker',
		'std' => '#000',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Text Color', 'gp_lang' ),
		'id' => $shortname.'_top_header_text_color',
		'type' => 'colorpicker',
		'std' => '#747474',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Link Color', 'gp_lang' ),
		'id' => $shortname.'_top_header_link_color',
		'type' => 'colorpicker',
		'std' => '#eee',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Link Hover Color', 'gp_lang' ),
		'id' => $shortname.'_top_header_link_hover_color',
		'type' => 'colorpicker',
		'std' => '#32B2C3',
		'stripped' => 'true',
		),
		
	array( 'type' => 'option_close' ),

	array( 'type' => 'option_open', 'name' => __('Top Header Dropdown Menus', 'gp_lang') ),

		array( 
		'name' => __( 'Background', 'gp_lang' ),
		'id' => $shortname.'_top_header_dropdown_bg_color',
		'type' => 'colorpicker',
		'std' => '#fff',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Background Hover', 'gp_lang' ),
		'id' => $shortname.'_top_header_dropdown_bg_hover_color',
		'type' => 'colorpicker',
		'std' => '#f7f7f7',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Border', 'gp_lang' ),
		'id' => $shortname.'_top_header_dropdown_border_color',
		'type' => 'colorpicker',
		'std' => '#e7e7e7',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Heading Color', 'gp_lang' ),
		'id' => $shortname.'_top_header_dropdown_heading_color',
		'type' => 'colorpicker',
		'std' => '#32B2C3',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Link Color', 'gp_lang' ),
		'id' => $shortname.'_top_header_dropdown_link_color',
		'type' => 'colorpicker',
		'std' => '#747474',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Link Hover Color', 'gp_lang' ),
		'id' => $shortname.'_top_header_dropdown_link_hover_color',
		'type' => 'colorpicker',
		'std' => '#32B2C3',
		'stripped' => 'true',
		),
				
	array( 'type' => 'option_close' ),
		
	array( 'type' => 'option_open', 'name' => __('Footer', 'gp_lang') ),

		array( 
		'name' => __( 'Background', 'gp_lang' ),
		'id' => $shortname.'_footer_bg_color',
		'type' => 'colorpicker',
		'std' => '#111',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Heading Color', 'gp_lang' ),
		'id' => $shortname.'_footer_heading_color',
		'type' => 'colorpicker',
		'std' => '#fff',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Text Color', 'gp_lang' ),
		'id' => $shortname.'_footer_text_color',
		'type' => 'colorpicker',
		'std' => '#aaa',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Link Color', 'gp_lang' ),
		'id' => $shortname.'_footer_link_color',
		'type' => 'colorpicker',
		'std' => '#fff',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Link Hover Color', 'gp_lang' ),
		'id' => $shortname.'_footer_link_hover_color',
		'type' => 'colorpicker',
		'std' => '#32B2C3',
		'stripped' => 'true',
		),
		
	array( 'type' => 'option_close' ),
	
	array( 'type' => 'option_open', 'name' => __('Bottom Footer', 'gp_lang') ),
		
		array( 
		'name' => __( 'Background', 'gp_lang' ),
		'id' => $shortname.'_bottom_footer_bg_color',
		'type' => 'colorpicker',
		'std' => '#2c2c2c',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Text Color', 'gp_lang' ),
		'id' => $shortname.'_bottom_footer_text_color',
		'type' => 'colorpicker',
		'std' => '#aaa',
		'stripped' => 'true',
		),
		
		array( 
		'name' => __( 'Link Color', 'gp_lang' ),
		'id' => $shortname.'_bottom_footer_link_color',
		'type' => 'colorpicker',
		'std' => '#fff',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Link Hover Color', 'gp_lang' ),
		'id' => $shortname.'_bottom_footer_link_hover_color',
		'type' => 'colorpicker',
		'std' => '#32B2C3',
		'stripped' => 'true',
		),
		
	array( 'type' => 'option_close' ),

	array( 'type' => 'separator' ),


	array( 
	'name' => __( 'Fonts', 'gp_lang' ),
	'type' => 'subheader',
	 ),		

	array( 'type' => 'option_open', 'name' => __( 'Primary Font', 'gp_lang' ) ),

		array( 
		'name' => __( 'Font Family', 'gp_lang' ),
		'id' => $shortname.'_primary_font',
		'options' => array( 'Open Sans' => __( 'Open Sans', 'gp_lang'), 'Roboto' => __( 'Roboto', 'gp_lang' ), 'Oswald' => __( 'Oswald', 'gp_lang' ), 'Droid+Sans' => __( 'Droid Sans', 'gp_lang' ), 'Lato' => __( 'Lato', 'gp_lang' ), 'PT+Sans' => __( 'PT Sans', 'gp_lang' ), 'Open+Sans+Condensed' => __( 'Open Sans Condensed', 'gp_lang' ), 'Droid+Serif' => __( 'Droid Serif', 'gp_lang' ), 'Ubuntu' => __( 'Ubuntu', 'gp_lang' ), 'PT+Sans+Narrow' => __( 'PT Sans Narrow', 'gp_lang' ), 'Raleway' => __( 'Raleway', 'gp_lang' ), 'Lora' => __( 'Lora', 'gp_lang' ), 'Montserrat' => __( 'Montserrat', 'gp_lang' ), 'Lobster' => __( 'Lobster', 'gp_lang' ), 'Audiowide' => __( 'Audiowide', 'gp_lang' ), 'Pacifico' => __( 'Pacifico', 'gp_lang' ), 'Tangerine' => __( 'Tangerine', 'gp_lang' )),
		'type' => 'select',
		'std' => 'Open Sans',
		'stripped' => 'true',
		 ), 

		array( 
		'name' => __( 'Font Size', 'gp_lang' ),
		'id' => $shortname.'_primary_font_size',
		'type' => 'text',
		'std' => '13px',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Line Height', 'gp_lang' ),
		'id' => $shortname.'_primary_line_height',
		'type' => 'text',
		'std' => '1.7em',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Font Weight', 'gp_lang' ),
		'id' => $shortname.'_primary_font_weight',
		'type' => 'text',
		'std' => '400',
		'size' => 'small',
		'stripped' => 'true',
		), 							
	
	array( 'type' => 'option_close' ),

	array( 'type' => 'option_open', 'name' => __( 'Header Navigation Font', 'gp_lang' ) ),

		array( 
		'name' => __( 'Font Family', 'gp_lang' ),
		'id' => $shortname.'_nav_font',
		'options' => array( 'Open Sans' => __( 'Open Sans', 'gp_lang'), 'Roboto' => __( 'Roboto', 'gp_lang' ), 'Oswald' => __( 'Oswald', 'gp_lang' ), 'Droid+Sans' => __( 'Droid Sans', 'gp_lang' ), 'Lato' => __( 'Lato', 'gp_lang' ), 'PT+Sans' => __( 'PT Sans', 'gp_lang' ), 'Open+Sans+Condensed' => __( 'Open Sans Condensed', 'gp_lang' ), 'Droid+Serif' => __( 'Droid Serif', 'gp_lang' ), 'Ubuntu' => __( 'Ubuntu', 'gp_lang' ), 'PT+Sans+Narrow' => __( 'PT Sans Narrow', 'gp_lang' ), 'Raleway' => __( 'Raleway', 'gp_lang' ), 'Lora' => __( 'Lora', 'gp_lang' ), 'Montserrat' => __( 'Montserrat', 'gp_lang' ), 'Lobster' => __( 'Lobster', 'gp_lang' ), 'Audiowide' => __( 'Audiowide', 'gp_lang' ), 'Pacifico' => __( 'Pacifico', 'gp_lang' ), 'Tangerine' => __( 'Tangerine', 'gp_lang' )),
		'type' => 'select',
		'std' => 'Open Sans',
		'stripped' => 'true',
		 ), 

		array( 
		'name' => __( 'Font Size', 'gp_lang' ),
		'id' => $shortname.'_nav_font_size',
		'type' => 'text',
		'std' => '12px',
		'size' => 'small',
		'stripped' => 'true',
		),

		array( 
		'name' => __( 'Line Height', 'gp_lang' ),
		'id' => $shortname.'_nav_line_height',
		'type' => 'text',
		'std' => '62px',
		'size' => 'small',
		'stripped' => 'true',
		),
				
		array( 
		'name' => __( 'Font Weight', 'gp_lang' ),
		'id' => $shortname.'_nav_font_weight',
		'type' => 'text',
		'std' => '400',
		'size' => 'small',
		'stripped' => 'true',
		), 	 	
	
	array( 'type' => 'option_close' ),


	array( 'type' => 'option_open', 'name' => __( 'Top Header Navigation Font', 'gp_lang' ) ),

		array( 
		'name' => __( 'Font Family', 'gp_lang' ),
		'id' => $shortname.'_top_header_nav_font',
		'options' => array( 'Open Sans' => __( 'Open Sans', 'gp_lang'), 'Roboto' => __( 'Roboto', 'gp_lang' ), 'Oswald' => __( 'Oswald', 'gp_lang' ), 'Droid+Sans' => __( 'Droid Sans', 'gp_lang' ), 'Lato' => __( 'Lato', 'gp_lang' ), 'PT+Sans' => __( 'PT Sans', 'gp_lang' ), 'Open+Sans+Condensed' => __( 'Open Sans Condensed', 'gp_lang' ), 'Droid+Serif' => __( 'Droid Serif', 'gp_lang' ), 'Ubuntu' => __( 'Ubuntu', 'gp_lang' ), 'PT+Sans+Narrow' => __( 'PT Sans Narrow', 'gp_lang' ), 'Raleway' => __( 'Raleway', 'gp_lang' ), 'Lora' => __( 'Lora', 'gp_lang' ), 'Montserrat' => __( 'Montserrat', 'gp_lang' ), 'Lobster' => __( 'Lobster', 'gp_lang' ), 'Audiowide' => __( 'Audiowide', 'gp_lang' ), 'Pacifico' => __( 'Pacifico', 'gp_lang' ), 'Tangerine' => __( 'Tangerine', 'gp_lang' )),
		'type' => 'select',
		'std' => 'Open Sans',
		'stripped' => 'true',
		 ), 

		array( 
		'name' => __( 'Font Size', 'gp_lang' ),
		'id' => $shortname.'_top_header_nav_font_size',
		'type' => 'text',
		'std' => '11px',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Line Height', 'gp_lang' ),
		'id' => $shortname.'_top_header_nav_line_height',
		'type' => 'text',
		'std' => '29px',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Font Weight', 'gp_lang' ),
		'id' => $shortname.'_top_header_nav_font_weight',
		'type' => 'text',
		'std' => '400',
		'size' => 'small',
		'stripped' => 'true',
		), 							
	
	array( 'type' => 'option_close' ),
		
	array( 'type' => 'option_open', 'name' => __( 'H1 Font', 'gp_lang' ) ),

		array( 
		'name' => __( 'Font Family', 'gp_lang' ),
		'id' => $shortname.'_h1_font',
		'options' => array( 'Open Sans' => __( 'Open Sans', 'gp_lang'), 'Roboto' => __( 'Roboto', 'gp_lang' ), 'Oswald' => __( 'Oswald', 'gp_lang' ), 'Droid+Sans' => __( 'Droid Sans', 'gp_lang' ), 'Lato' => __( 'Lato', 'gp_lang' ), 'PT+Sans' => __( 'PT Sans', 'gp_lang' ), 'Open+Sans+Condensed' => __( 'Open Sans Condensed', 'gp_lang' ), 'Droid+Serif' => __( 'Droid Serif', 'gp_lang' ), 'Ubuntu' => __( 'Ubuntu', 'gp_lang' ), 'PT+Sans+Narrow' => __( 'PT Sans Narrow', 'gp_lang' ), 'Raleway' => __( 'Raleway', 'gp_lang' ), 'Lora' => __( 'Lora', 'gp_lang' ), 'Montserrat' => __( 'Montserrat', 'gp_lang' ), 'Lobster' => __( 'Lobster', 'gp_lang' ), 'Audiowide' => __( 'Audiowide', 'gp_lang' ), 'Pacifico' => __( 'Pacifico', 'gp_lang' ), 'Tangerine' => __( 'Tangerine', 'gp_lang' )),
		'type' => 'select',
		'std' => 'Open Sans',
		'stripped' => 'true',
		 ), 

		array( 
		'name' => __( 'Font Size', 'gp_lang' ),
		'id' => $shortname.'_h1_font_size',
		'type' => 'text',
		'std' => '36px',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Line Height', 'gp_lang' ),
		'id' => $shortname.'_h1_line_height',
		'type' => 'text',
		'std' => '46px',
		'size' => 'small',
		'stripped' => 'true',
		), 
		
		array( 
		'name' => __( 'Font Weight', 'gp_lang' ),
		'id' => $shortname.'_h1_font_weight',
		'type' => 'text',
		'std' => '100',
		'size' => 'small',
		'stripped' => 'true',
		), 	 	
	
	array( 'type' => 'option_close' ),

	array( 'type' => 'option_open', 'name' => __( 'H2 Font', 'gp_lang' ) ),

		array( 
		'name' => __( 'Font Family', 'gp_lang' ),
		'id' => $shortname.'_h2_font',
		'options' => array( 'Open Sans' => __( 'Open Sans', 'gp_lang'), 'Roboto' => __( 'Roboto', 'gp_lang' ), 'Oswald' => __( 'Oswald', 'gp_lang' ), 'Droid+Sans' => __( 'Droid Sans', 'gp_lang' ), 'Lato' => __( 'Lato', 'gp_lang' ), 'PT+Sans' => __( 'PT Sans', 'gp_lang' ), 'Open+Sans+Condensed' => __( 'Open Sans Condensed', 'gp_lang' ), 'Droid+Serif' => __( 'Droid Serif', 'gp_lang' ), 'Ubuntu' => __( 'Ubuntu', 'gp_lang' ), 'PT+Sans+Narrow' => __( 'PT Sans Narrow', 'gp_lang' ), 'Raleway' => __( 'Raleway', 'gp_lang' ), 'Lora' => __( 'Lora', 'gp_lang' ), 'Montserrat' => __( 'Montserrat', 'gp_lang' ), 'Lobster' => __( 'Lobster', 'gp_lang' ), 'Audiowide' => __( 'Audiowide', 'gp_lang' ), 'Pacifico' => __( 'Pacifico', 'gp_lang' ), 'Tangerine' => __( 'Tangerine', 'gp_lang' )),
		'type' => 'select',
		'std' => 'Open Sans',
		'stripped' => 'true',
		 ), 

		array( 
		'name' => __( 'Font Size', 'gp_lang' ),
		'id' => $shortname.'_h2_font_size',
		'type' => 'text',
		'std' => '22px',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Line Height', 'gp_lang' ),
		'id' => $shortname.'_h2_line_height',
		'type' => 'text',
		'std' => '32px',
		'size' => 'small',
		'stripped' => 'true',
		), 
		
		array( 
		'name' => __( 'Font Weight', 'gp_lang' ),
		'id' => $shortname.'_h2_font_weight',
		'type' => 'text',
		'std' => '100',
		'size' => 'small',
		'stripped' => 'true',
		), 	 	
	
	array( 'type' => 'option_close' ),

	array( 'type' => 'option_open', 'name' => __( 'H3 Font', 'gp_lang' ) ),

		array( 
		'name' => __( 'Font Family', 'gp_lang' ),
		'id' => $shortname.'_h3_font',
		'options' => array( 'Open Sans' => __( 'Open Sans', 'gp_lang'), 'Roboto' => __( 'Roboto', 'gp_lang' ), 'Oswald' => __( 'Oswald', 'gp_lang' ), 'Droid+Sans' => __( 'Droid Sans', 'gp_lang' ), 'Lato' => __( 'Lato', 'gp_lang' ), 'PT+Sans' => __( 'PT Sans', 'gp_lang' ), 'Open+Sans+Condensed' => __( 'Open Sans Condensed', 'gp_lang' ), 'Droid+Serif' => __( 'Droid Serif', 'gp_lang' ), 'Ubuntu' => __( 'Ubuntu', 'gp_lang' ), 'PT+Sans+Narrow' => __( 'PT Sans Narrow', 'gp_lang' ), 'Raleway' => __( 'Raleway', 'gp_lang' ), 'Lora' => __( 'Lora', 'gp_lang' ), 'Montserrat' => __( 'Montserrat', 'gp_lang' ), 'Lobster' => __( 'Lobster', 'gp_lang' ), 'Audiowide' => __( 'Audiowide', 'gp_lang' ), 'Pacifico' => __( 'Pacifico', 'gp_lang' ), 'Tangerine' => __( 'Tangerine', 'gp_lang' )),
		'type' => 'select',
		'std' => 'Open Sans',
		'stripped' => 'true',
		 ), 

		array( 
		'name' => __( 'Font Size', 'gp_lang' ),
		'id' => $shortname.'_h3_font_size',
		'type' => 'text',
		'std' => '20px',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Line Height', 'gp_lang' ),
		'id' => $shortname.'_h3_line_height',
		'type' => 'text',
		'std' => '30px',
		'size' => 'small',
		'stripped' => 'true',
		), 
		
		array( 
		'name' => __( 'Font Weight', 'gp_lang' ),
		'id' => $shortname.'_h3_font_weight',
		'type' => 'text',
		'std' => '100',
		'size' => 'small',
		'stripped' => 'true',
		), 	 	
	
	array( 'type' => 'option_close' ),		

	array( 'type' => 'option_open', 'name' => __( 'H4 Font', 'gp_lang' ) ),

		array( 
		'name' => __( 'Font Family', 'gp_lang' ),
		'id' => $shortname.'_h4_font',
		'options' => array( 'Open Sans' => __( 'Open Sans', 'gp_lang'), 'Roboto' => __( 'Roboto', 'gp_lang' ), 'Oswald' => __( 'Oswald', 'gp_lang' ), 'Droid+Sans' => __( 'Droid Sans', 'gp_lang' ), 'Lato' => __( 'Lato', 'gp_lang' ), 'PT+Sans' => __( 'PT Sans', 'gp_lang' ), 'Open+Sans+Condensed' => __( 'Open Sans Condensed', 'gp_lang' ), 'Droid+Serif' => __( 'Droid Serif', 'gp_lang' ), 'Ubuntu' => __( 'Ubuntu', 'gp_lang' ), 'PT+Sans+Narrow' => __( 'PT Sans Narrow', 'gp_lang' ), 'Raleway' => __( 'Raleway', 'gp_lang' ), 'Lora' => __( 'Lora', 'gp_lang' ), 'Montserrat' => __( 'Montserrat', 'gp_lang' ), 'Lobster' => __( 'Lobster', 'gp_lang' ), 'Audiowide' => __( 'Audiowide', 'gp_lang' ), 'Pacifico' => __( 'Pacifico', 'gp_lang' ), 'Tangerine' => __( 'Tangerine', 'gp_lang' )),
		'type' => 'select',
		'std' => 'Open Sans',
		'stripped' => 'true',
		 ), 

		array( 
		'name' => __( 'Font Size', 'gp_lang' ),
		'id' => $shortname.'_h4_font_size',
		'type' => 'text',
		'std' => '18px',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Line Height', 'gp_lang' ),
		'id' => $shortname.'_h4_line_height',
		'type' => 'text',
		'std' => '22px',
		'size' => 'small',
		'stripped' => 'true',
		), 
		
		array( 
		'name' => __( 'Font Weight', 'gp_lang' ),
		'id' => $shortname.'_h4_font_weight',
		'type' => 'text',
		'std' => '400',
		'size' => 'small',
		'stripped' => 'true',
		), 	 	
	
	array( 'type' => 'option_close' ),	

	array( 'type' => 'option_open', 'name' => __( 'H5 Font', 'gp_lang' ) ),

		array( 
		'name' => __( 'Font Family', 'gp_lang' ),
		'id' => $shortname.'_h5_font',
		'options' => array( 'Open Sans' => __( 'Open Sans', 'gp_lang'), 'Roboto' => __( 'Roboto', 'gp_lang' ), 'Oswald' => __( 'Oswald', 'gp_lang' ), 'Droid+Sans' => __( 'Droid Sans', 'gp_lang' ), 'Lato' => __( 'Lato', 'gp_lang' ), 'PT+Sans' => __( 'PT Sans', 'gp_lang' ), 'Open+Sans+Condensed' => __( 'Open Sans Condensed', 'gp_lang' ), 'Droid+Serif' => __( 'Droid Serif', 'gp_lang' ), 'Ubuntu' => __( 'Ubuntu', 'gp_lang' ), 'PT+Sans+Narrow' => __( 'PT Sans Narrow', 'gp_lang' ), 'Raleway' => __( 'Raleway', 'gp_lang' ), 'Lora' => __( 'Lora', 'gp_lang' ), 'Montserrat' => __( 'Montserrat', 'gp_lang' ), 'Lobster' => __( 'Lobster', 'gp_lang' ), 'Audiowide' => __( 'Audiowide', 'gp_lang' ), 'Pacifico' => __( 'Pacifico', 'gp_lang' ), 'Tangerine' => __( 'Tangerine', 'gp_lang' )),
		'type' => 'select',
		'std' => 'Open Sans',
		'stripped' => 'true',
		 ), 

		array( 
		'name' => __( 'Font Size', 'gp_lang' ),
		'id' => $shortname.'_h5_font_size',
		'type' => 'text',
		'std' => '16px',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Line Height', 'gp_lang' ),
		'id' => $shortname.'_h5_line_height',
		'type' => 'text',
		'std' => '20px',
		'size' => 'small',
		'stripped' => 'true',
		), 
		
		array( 
		'name' => __( 'Font Weight', 'gp_lang' ),
		'id' => $shortname.'_h5_font_weight',
		'type' => 'text',
		'std' => '100',
		'size' => 'small',
		'stripped' => 'true',
		), 	 	
	
	array( 'type' => 'option_close' ),

	array( 'type' => 'option_open', 'name' => __( 'H6 Font', 'gp_lang' ) ),

		array( 
		'name' => __( 'Font Family', 'gp_lang' ),
		'id' => $shortname.'_h6_font',
		'options' => array( 'Open Sans' => __( 'Open Sans', 'gp_lang'), 'Roboto' => __( 'Roboto', 'gp_lang' ), 'Oswald' => __( 'Oswald', 'gp_lang' ), 'Droid+Sans' => __( 'Droid Sans', 'gp_lang' ), 'Lato' => __( 'Lato', 'gp_lang' ), 'PT+Sans' => __( 'PT Sans', 'gp_lang' ), 'Open+Sans+Condensed' => __( 'Open Sans Condensed', 'gp_lang' ), 'Droid+Serif' => __( 'Droid Serif', 'gp_lang' ), 'Ubuntu' => __( 'Ubuntu', 'gp_lang' ), 'PT+Sans+Narrow' => __( 'PT Sans Narrow', 'gp_lang' ), 'Raleway' => __( 'Raleway', 'gp_lang' ), 'Lora' => __( 'Lora', 'gp_lang' ), 'Montserrat' => __( 'Montserrat', 'gp_lang' ), 'Lobster' => __( 'Lobster', 'gp_lang' ), 'Audiowide' => __( 'Audiowide', 'gp_lang' ), 'Pacifico' => __( 'Pacifico', 'gp_lang' ), 'Tangerine' => __( 'Tangerine', 'gp_lang' )),
		'type' => 'select',
		'std' => 'Open Sans',
		'stripped' => 'true',
		 ), 

		array( 
		'name' => __( 'Font Size', 'gp_lang' ),
		'id' => $shortname.'_h6_font_size',
		'type' => 'text',
		'std' => '14px',
		'size' => 'small',
		'stripped' => 'true',
		), 

		array( 
		'name' => __( 'Line Height', 'gp_lang' ),
		'id' => $shortname.'_h6_line_height',
		'type' => 'text',
		'std' => '18px',
		'size' => 'small',
		'stripped' => 'true',
		), 
		
		array( 
		'name' => __( 'Font Weight', 'gp_lang' ),
		'id' => $shortname.'_h6_font_weight',
		'type' => 'text',
		'std' => '100',
		'size' => 'small',
		'stripped' => 'true',
		), 	 	
	
	array( 'type' => 'option_close' ),
	
			
	array( 'type' => 'separator' ),
					
	
	array( 
	'name' => __( 'Widths', 'gp_lang' ),
	'desc' => __( 'The total of the content and sidebar widths should not be larger than the page width.', 'gp_lang' ),
	'type' => 'subheader',
	 ), 

	array( 'type' => 'option_open', 'name' => 'Desktop' ),			

		array( 
		'name' => __( 'Page Width', 'gp_lang' ),
		'id' => $shortname.'_page_width_1',
		'std' => '1040',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		),
					
		array( 
		'name' => __( 'Content Width', 'gp_lang' ),
		'id' => $shortname.'_content_width_1',
		'std' => '700',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		),	
		
		array( 
		'name' => __( 'Sidebar Width', 'gp_lang' ),
		'id' => $shortname.'_sidebar_width_1',
		'std' => '300',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		),
	
	array( 'type' => 'option_close' ),

	array( 'type' => 'option_open', 'name' => 'Tablet (Landscape)' ),
	
		array( 
		'name' => __( 'Page Width', 'gp_lang' ),
		'id' => $shortname.'_page_width_2',
		'std' => '940',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		),
					
		array( 
		'name' => __( 'Content Width', 'gp_lang' ),
		'id' => $shortname.'_content_width_2',
		'std' => '700',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		),	
		
		array( 
		'name' => __( 'Sidebar Width', 'gp_lang' ),
		'id' => $shortname.'_sidebar_width_2',
		'std' => '200',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		),
			
	array( 'type' => 'option_close' ),

	array( 'type' => 'option_open', 'name' => 'Tablet (Portrait)' ),					

		array( 
		'name' => __( 'Page Width', 'gp_lang' ),
		'id' => $shortname.'_page_width_3',
		'std' => '700',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		),
					
		array( 
		'name' => __( 'Content Width', 'gp_lang' ),
		'id' => $shortname.'_content_width_3',
		'std' => '480',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		),	
		
		array( 
		'name' => __( 'Sidebar Width', 'gp_lang' ),
		'id' => $shortname.'_sidebar_width_3',
		'std' => '180',
		'type' => 'text',
		'size' => 'small',
		'details' => 'px',
		'stripped' => 'true',
		),
	
	array( 'type' => 'option_close' ),
											 
array( 'type' => 'close' ),
		
					
array( 'name' => __( 'CSS Settings', 'gp_lang' ), 'id' => 'css_settings', 'type' => 'open' ),

	array( 
	'name' => __( 'CSS Settings', 'gp_lang' ),
	'type' => 'header',
	'desc' => __( 'You can link to your own custom stylesheet or add your own CSS below to style the theme. This CSS will not be lost if you update the theme. For more information on how to find the names of the elements you want to style  click', 'gp_lang' ).' <a href="http://ghostpool.com/help/'.$gp_dirname.'/help.html#customizing-theme" target="_blank">'.__( 'here', 'gp_lang' ).'</a>.' ),

	array( 'type' => 'separator' ),

	array( 
	'name' => __( 'Custom Stylesheet', 'gp_lang' ),
	'desc' => __( 'The relative URL to your custom stylesheet e.g. <code>lib/css/custom-style.css</code>.', 'gp_lang' ),
	'id' => $shortname.'_custom_stylesheet',
	'type' => 'text' ),
	
	array( 'type' => 'separator' ), 
							
	array( 
	'name' => __( 'Custom CSS', 'gp_lang' ),
	'id' => $shortname.'_custom_css',
	'type' => 'textarea',
	'size' => 'large' ),

array( 'type' => 'close' ),
	
 );

function gp_add_admin() {

    global $gp_dirname, $options, $get_font_transiet;
			
    if( isset( $_GET['page'] ) && $_GET['page'] == basename( __FILE__ ) ) {

        if( isset( $_REQUEST['action'] ) && 'save' == $_REQUEST['action'] ) {

			foreach ( $options as $value ) {
				if( isset( $value['id'] ) ) {
					update_option( $value['id'], $_REQUEST[ $value['id']] );
				} else {
					if( isset( $value['id'] ) ) { delete_option( $value['id'] ); }
				}
			}

			header( "Location: themes.php?page=theme-options.php&saved=true" );
			die;

        } elseif( isset( $_REQUEST['action'] ) && 'reset' == $_REQUEST['action'] ) {

            foreach ( $options as $value ) {
                delete_option( $value['id'] );
            }
            
            update_option( 'gp_theme_setup_status', '0' );

            header( "Location: themes.php?page=theme-options.php&reset=true" );
            die;

        }

		elseif( isset( $_REQUEST['action'] ) && 'export' == $_REQUEST['action'] ) gp_export_settings();
		elseif( isset( $_REQUEST['action'] ) && 'import' == $_REQUEST['action'] ) gp_import_settings();

    }
	
	add_theme_page( __( 'Theme Options', 'gp_lang' ), __( 'Theme Options', 'gp_lang' ), 'manage_options', basename( __FILE__ ), 'gp_admin' );

}

function gp_admin() {

    global $gp_dirname, $options, $get_font_transiet;

    if( isset( $_REQUEST['saved'] ) && $_REQUEST['saved'] ) {
    	echo '<div id="message" class="updated"><p><strong>'.__( 'Options Saved', 'gp_lang' ).'</strong></p></div>';
    }	
    if( isset( $_REQUEST['reset'] ) && $_REQUEST['reset'] ) {
    	echo '<div id="message" class="updated"><p><strong>'.__( 'Options Reset', 'gp_lang' ).'</strong></p></div>';
	}
	
?>

<div id="gp-theme-options" class="wrap">
	
	<h2>
	
		<?php _e( 'Theme Options', 'gp_lang' ); ?>
		
		<a href="http://ghostpool.com/help/<?php echo $gp_dirname; ?>/help.html" class="add-new-h2" target="_blank"><?php _e( 'Help File', 'gp_lang' ); ?></a>
	
		<a href="http://ghostpool.com/help/<?php echo $gp_dirname; ?>/changelog.html" class="add-new-h2" target="_blank"><?php _e( 'Changelog', 'gp_lang' ); ?></a>
	
		<a href="http://ghostpool.ticksy.com" class="add-new-h2" target="_blank"><?php _e( 'Support', 'gp_lang' ); ?></a>
	
		<a href="http://ourwebmedia.com/ghostpool.php?aff=002" class="add-new-h2" target="_blank"><?php _e( 'Premium Service', 'gp_lang' ); ?></a>
	
	</h2>
	
	
	<div id="import_export" class="hide-if-js">
	
		<h2><?php _e( 'Import Theme Options', 'gp_lang' ); ?></h2>
		
		<span><?php _e( 'If you have a back up of your theme options you can import them below.', 'gp_lang' ); ?></span><br/><br/>
		
		<form method="post" enctype="multipart/form-data">
			<span class="submit"><input type="file" name="file" id="file" />
			<input type="submit" name="import" class="button" value="<?php _e( 'Upload', 'gp_lang' ); ?>" /></span>
			<input type="hidden" name="action" value="import" />
		</form>

		<br/><hr>
		
		<h2><?php _e( 'Export Theme Options', 'gp_lang' ); ?></h2>
		
		<span><?php _e( 'If you want to create a back up of all your theme options click the Export button below (will only back up your theme options and not your post/page/images data).', 'gp_lang' ); ?></span>
		
		<form method="post">
			<p class="submit"><input name="export" type="submit" class="button" value="<?php _e( 'Export Theme Settings', 'gp_lang' ); ?>" /></p>
			<input type="hidden" name="action" value="export" />
		</form>	
	
	</div>

	
	<form method="post">
		
		<div class="submit">	
		
			<a href="#TB_inline?height=300&amp;width=500&amp;inlineId=import_export" onclick="return false;" class="thickbox"><input type="button" class="button" value="<?php _e( 'Import/Export Theme Options' , 'gp_lang' ); ?>"></a>
		
			<input name="save" type="submit" class="button-primary right" value="<?php _e( 'Save Changes', 'gp_lang' ); ?>" />
			<input type="hidden" name="action" value="save" />
			
		</div>
		
		<div id="panels">


<?php foreach ( $options as $value ) {
switch( $value['type'] ) {
case 'open':
?>


	<div id="<?php echo $value['id']; ?>" data-name="<?php echo $value['name']; ?>" class="panel">
		
	
<?php break;
case 'close':
?>

	</div>


<?php break;
case 'header':
?>

	<div class="gp-option gp-option-header">
		<?php if( isset( $value['name'] ) ) { ?><h2><?php echo $value['name']; ?></h2><?php } ?>
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
	</div>	


<?php break;
case 'subheader':
?>

	<div class="gp-option gp-option-subheader">
		<?php if( isset( $value['name'] ) ) { ?><h3><?php echo $value['name']; ?></h3><?php } ?>
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
	</div>	
		
	
<?php break;
case 'separator':
?>

	<div class="gp-separator"></div>


<?php break;
case 'spacer':
?>

	<div class="gp-spacer"></div>



<?php break;
case 'option_open':
?>
	
	
	<div class="gp-option gp-option-open">
	
		<?php if( isset( $value['name'] ) ) { ?><h4><?php echo $value['name']; ?></h4><?php } ?>
	

<?php break;
case 'option_close':
?>
	
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
	
	</div>


<?php break;
case 'text':
?>
	
	
	<div class="gp-option gp-text<?php if( isset( $value['stripped'] ) && $value['stripped'] == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if( isset( $value['name'] ) ) { ?><h4><?php echo $value['name']; ?></h4><?php } ?>
		
		<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" value="<?php if( get_option( $value['id'] ) != '' ) { echo get_option( $value['id'] ); } else { if( isset( $value['std'] ) ) { echo $value['std']; } } ?>" size="<?php if( isset( $value['size'] ) && $value['size'] == 'small' ) { ?>4<?php } else { ?>40<?php } ?>" /><?php if( isset( $value['details'] ) ) { ?> <span><?php echo $value['details']; ?></span><?php } ?>
		
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
		
	</div>
	
	
<?php break;
case 'upload':
?>

	<div class="gp-option gp-upload<?php if( isset( $value['stripped'] ) && $value['stripped'] == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if( isset( $value['name'] ) ) { ?><h4><?php echo $value['name']; ?></h4><?php } ?>
		
		<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" size="40" class='upload' value="<?php if( get_option( $value['id'] ) != '' ) { echo get_option( $value['id'] ); } else { if( isset( $value['std'] ) ) { echo $value['std']; } } ?>" />
		<input type="button" id="<?php echo $value['id']; ?>_button" class="gp-upload-button button" value="<?php _e( 'Upload', 'gp_lang' ); ?>" />
		
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
		
	</div>


<?php
break;
case 'textarea':
?>

	<div class="gp-option gp-textarea<?php if( isset( $value['stripped'] ) && $value['stripped'] == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if( isset( $value['name'] ) ) { ?><h4><?php echo $value['name']; ?></h4><?php } ?>
		
		<textarea name="<?php echo $value['id']; ?>" cols="70" rows="<?php if( isset( $value['size'] ) && $value['size'] == 'large' ) { ?>50<?php } else { ?>10<?php } ?>"><?php if( get_option( $value['id'] ) != '' ) { echo stripslashes( get_option( $value['id'] ) ); } else { if( isset( $value['std'] ) ) { echo $value['std']; } } ?></textarea>
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
		
	</div>


<?php
break;
case 'checkbox':
?> 
   	
	<div class="gp-option gp-checkbox<?php if( isset( $value['stripped'] ) && $value['stripped'] == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if( get_option( $value['id'] ) ) { $checked = 'checked="checked"'; } else { $checked = ''; } ?>
		<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
		
		<?php if( isset( $value['name'] ) ) { ?><strong><?php echo $value['name']; ?></strong><?php } ?>
		
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
		
	</div>

	

<?php        
break;
case 'radio':
?>

	<div class="gp-option gp-radio<?php if( isset( $value['stripped'] ) && $value['stripped'] == 'true' ) { ?> gp-stripped<?php } ?>">
		
		<?php if( isset( $value['name'] ) ) { ?><h4><?php echo $value['name']; ?></h4><?php } ?>
		
		<?php foreach ( $value['options'] as $key=>$option ) {	
			$radio_setting = get_option( $value['id'] );
			if( $radio_setting != '' ) {
				if( $key == get_option( $value['id'] ) ) {
					$checked = 'checked="checked"';
				} else {
					$checked = '';
				}
			} else {
				if( $key == $value['std'] ) {
					$checked = 'checked="checked"';
				} else {
					$checked = '';
				}
			} ?>
			
			<div class="gp-radio-button">
				<input type='radio' name="<?php echo $value['id']; ?>" id="<?php echo $value['id'] . $key; ?>" value="<?php echo $key; ?>" <?php echo $checked; ?> /><label for="<?php echo $value['id'].'_'.$key; ?>"><?php echo $option; ?></label>
			</div>	
			
		<?php } ?>
		
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
		
	</div>
	
	
<?php
break;
case 'select':
?>
	
	<div class="gp-option gp-select<?php if( isset( $value['stripped'] ) && $value['stripped'] == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if( isset( $value['name'] ) ) { ?><h4><?php echo $value['name']; ?></h4><?php } ?>
		
		<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
			<?php foreach ( $value['options'] as $key => $option ) { ?>
					<?php if( get_option( $value['id'] ) != '' ) { ?>
						<option value="<?php echo $key; ?>" <?php if( get_option( $value['id'] ) == $key ) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
					<?php } else { ?>
						<option value="<?php echo $key; ?>" <?php if( $value['std'] == $key ) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
					<?php } ?>
			<?php } ?>
		</select>
		
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
		
	</div>


<?php
break;
case 'select_taxonomy':
?>
		
	<div class="gp-option gp-select-taxonomy<?php if( isset( $value['stripped'] ) && $value['stripped'] == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if( isset( $value['name'] ) ) { ?><h4><?php echo $value['name']; ?></h4><?php } ?>
		
		<?php $terms = get_terms( $value['cats'], 'hide_empty=0' ); ?>
		<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>"><option value=''><?php _e( 'None', 'gp_lang' ); ?></option><?php foreach ( $terms as $term ): ?><option value="<?php echo $term->slug; ?>" <?php if( get_option( $value['id'] ) == $term->slug ) { echo ' selected="selected"'; } ?>><?php echo $term->name; ?></option><?php endforeach; ?></select>
		
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
		
	</div>	



<?php
break;
case 'select_sidebar':
global $post, $wp_registered_sidebars;
?>
		
	<div class="gp-option gp-select-sidebar<?php if( isset( $value['stripped'] ) && $value['stripped'] == 'true' ) { ?> gp-stripped<?php } ?>">
		
		<?php if( isset( $value['name'] ) ) { ?><h4><?php echo $value['name']; ?></h4><?php } ?>
		
		<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
		<?php $sidebars = $wp_registered_sidebars; 
		if( is_array( $sidebars ) && !empty( $sidebars ) ) { 
			foreach ( $sidebars as $sidebar ) { 
				if( get_option( $value['id'] ) != '' ) { ?>
					<option value="<?php echo $sidebar['id']; ?>"<?php if( get_option( $value['id'] ) == $sidebar['id'] ) { echo ' selected="selected"'; } ?>><?php echo $sidebar['name']; ?></option>
				<?php } else { ?>				
					<option value="<?php echo $sidebar['id']; ?>"<?php if( $value['std'] == $sidebar['id'] ) { echo ' selected="selected"'; } ?>><?php echo $sidebar['name']; ?></option>				
		<?php }}} ?>	
		</select>
		
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
		
	</div>


<?php        
break;
case 'colorpicker':
?>

	<div class="gp-option gp-colorpick<?php if( isset( $value['stripped'] ) && $value['stripped'] == 'true' ) { ?> gp-stripped<?php } ?>">
	
		<?php if( isset( $value['name'] ) ) { ?><h4><?php echo $value['name']; ?></h4><?php } ?>
		
		<script type="text/javascript">
			jQuery( document ).ready( function( $ ) { 
				$( '#<?php echo $value["id"]; ?>' ).wpColorPicker();
			} );
		</script>
		
		<input type="text" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="<?php if( get_option( $value['id'] ) != '' ) { echo get_option( $value['id'] ); } else { if( isset( $value['std'] ) ) { if( isset( $value['std'] ) ) { echo $value['std']; } } } ?>" />
		
		<?php if( isset( $value['desc'] ) ) { ?><div class="gp-option-desc"><?php echo $value['desc']; ?></div><?php } ?>
		
	</div>


<?php        
break;
}}
?>

	</div>
	
	<div class="submit">

			<input name="save" type="submit" class="button-primary right" value="<?php _e( 'Save Changes', 'gp_lang' ); ?>" />
			<input type="hidden" name="action" value="save" />

		</form>
	
		<form method="post" onSubmit="if( confirm( '<?php _e( 'Are you sure you want to reset all the theme options&#63;', 'gp_lang' ); ?>' ) ) return true; else return false;">	
			<input name="reset" type="submit" class="button right" style="margin-right: 10px;" value="<?php _e( 'Reset', 'gp_lang' ); ?>" />
			<input type="hidden" name="action" value="reset" />			
		</form>
	
	</div>

</div>

<!-- END THEME WRAPPER -->


<?php } 


if( is_admin() && $pagenow == 'themes.php' ) {
	function gp_admin_styles() {
		wp_enqueue_style( 'thickbox' );
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style( 'gp-admin', get_template_directory_uri() . '/lib/admin/css/admin.css' );	
	}
	add_action( 'admin_enqueue_scripts', 'gp_admin_styles' );
	function gp_admin_scripts() {
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-sortable' );
		wp_enqueue_script( 'thickbox' );
		wp_enqueue_media();
		wp_enqueue_script( 'wp-color-picker' );
		wp_enqueue_script( 'gp-tabs', get_template_directory_uri() . '/lib/admin/scripts/jquery.tabs.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'gp-uploader', get_template_directory_uri() . '/lib/admin/scripts/uploader.js', array( 'jquery' ), '', true );
	}
	add_action( 'admin_enqueue_scripts', 'gp_admin_scripts' );				
}

add_action( 'admin_menu', 'gp_add_admin' ); 


// Export Theme Options
function gp_export_settings() {
	global $options;
	header( 'Cache-Control: public, must-revalidate' );
	header( 'Pragma: hack' );
	header( 'Content-Type: text/plain' );
	header( 'Content-Disposition: attachment; filename="theme-options-'.date( 'dMy' ) . '.dat"' );
	foreach ( $options as $value ) {
		$theme_settings[$value['id']] = get_option( $value['id'] );	
	}	
	echo serialize( $theme_settings );
}

// Import Theme Options
function gp_import_settings() {
	global $options;
	if ( $_FILES['file']['error'] > 0 ) {
		echo 'Error: ' . $_FILES['file']['error'] . '<br />';
	} else {
		$rawdata = file_get_contents( $_FILES['file']['tmp_name'] );		
		$theme_settings = unserialize( $rawdata );		
		foreach ( $options as $value ) {
			if ( $theme_settings[$value['id']] ) {
				update_option( $value['id'], $theme_settings[$value['id']] );
				$$value['id'] = $theme_settings[$value['id']];
			} else {
				if ( $value['type'] == 'checkbox_multiple' ) {
					$$value['id'] = array();
				} else {
					$$value['id'] = $value['std'];
				}	
			}
		}
		
	}
	if ( in_array( 'cacheStyles', get_option( 'gp_misc' ) ) ) {
		cache_settings();
	}	
	wp_redirect( $_SERVER['PHP_SELF'].'?page=theme-options.php' );
}

// Help Tab
if ( is_admin() && $pagenow == 'themes.php' ) {
	function gp_theme_help_tab() {
		global $gp_dirname;
		$screen = get_current_screen();
		$screen->add_help_tab( array( 
			'id' => 'help',
			'title' => 'Help',
			'content' => '<p><a href="http://ghostpool.com/help/'.$gp_dirname.'/help.html" target="_blank">'.__( 'Help File', 'gp_lang' ).'</a></p><p><a href="http://ghostpool.com/help/'.$gp_dirname.'/changelog.html" target="_blank">'.__( 'Changelog', 'gp_lang' ).'</a></p><p><a href="http://ghostpool.ticksy.com" target="_blank">'.__( 'Support', 'gp_lang' ).'</a></p><p><a href="http://ourwebmedia.com/ghostpool.php" target="_blank">'.__( 'Premium Service', 'gp_lang' ).'</a></p>'
		 ) );	
	}
	add_action( 'admin_head', 'gp_theme_help_tab' );
}


/////////////////////////////////////// Save Default Theme Options ///////////////////////////////////////


function gp_theme_options_setup() {
	
	if ( get_option( 'gp_theme_setup_status' ) !== '1' ) {
	
		$core_settings = array( 
		
			/* General Settings */
			'gp_theme_layout' => 'gp-wide-layout',
			'gp_responsive' => 'gp-responsive',
			'gp_retina' => 'enable',
			'gp_smooth_scrolling' => 'gp-smooth-scrolling',
			'gp_back_to_top' => 'gp-back-to-top',
			'gp_rss_button' => 'enable',
			'gp_rss' => 'http://',
			'gp_twitter' => 'http://',
			'gp_facebook' => 'http://',
			'gp_youtube' => 'http://',
			'gp_googleplus' => 'http://',
			'gp_linkedin' => 'http://',
			'gp_flickr' => 'http://',
			'gp_pinterest' => 'http://',
			'gp_additional_social_icons' => '',
			'gp_favicon_ico' => '',
			'gp_favicon_png' => '',
			'gp_apple_icon' => '',
			'gp_scripts' => '',
			
			/* Header Settings */
			'gp_header_layout' => 'gp-header-1',
			'gp_fixed_header' => 'gp-fixed-header',
			'gp_header_resize' => 'gp-header-resize',
			'gp_header_size_reduction' => '1.5',	
			'gp_logo_width' => '220',
			'gp_logo_height' => '62',
			'gp_logo_top' => '0',
			'gp_logo_right' => '0',
			'gp_logo_bottom' => '0',
			'gp_logo_left' => '0',
			'gp_search' => 'enable',
			
			/* Footer Settings */	
			'gp_footer_content' => '',
				
			/* Category Settings */
			'gp_cat_layout' => 'right-sidebar',
			'gp_cat_sidebar' => 'gp-standard-sidebar',
			'gp_cat_blog_type' => 'blog-standard',
			'gp_cat_featured_image' => 'enable',
			'gp_cat_image_width' => '700',
			'gp_cat_image_height' => '400',
			'gp_cat_hard_crop' => 'enable',
			'gp_cat_image_wrap' => 'disable',
			'gp_cat_title_header' => 'enable',
			'gp_cat_title_header_image' => '',
			'gp_cat_title_header_color' => '',
			'gp_cat_title_header_padding' => '',
			'gp_cat_title_header_parallax' => 'enable',								
			'gp_cat_content_display' => 'excerpt',
			'gp_cat_excerpt_length' => '400',		
			'gp_cat_read_more' => 'enable',
			'gp_cat_author' => 'enable',
			'gp_cat_date' => 'enable',
			'gp_cat_cats' => 'disable',
			'gp_cat_views' => 'enable',
			'gp_cat_comments' => 'enable',
			'gp_cat_tags' => 'disable',		
															
			/* Post Settings */
			'gp_post_layout' => 'right-sidebar',
			'gp_post_sidebar' => 'gp-standard-sidebar',			
			'gp_post_featured_image' => 'enable',
			'gp_post_image_width' => '700',
			'gp_post_image_height' => '400',
			'gp_post_hard_crop' => 'enable',
			'gp_post_image_wrap' => 'disable',		
			'gp_post_author' => 'enable',
			'gp_post_date' => 'enable',			
			'gp_post_cats' => 'enable',
			'gp_post_comments' => 'enable',			
			'gp_post_tags' => 'enable',	
			'gp_post_author_info' => 'enable',	
			'gp_post_related_items' => 'enable',	
			'gp_post_related_per_page' => '4',
			'gp_post_related_image_width' => '161',	
			'gp_post_related_image_height' => '141',
						
			/* Page Settings */
			'gp_page_layout' => 'right-sidebar',
			'gp_page_sidebar' => 'gp-standard-sidebar',	
			'gp_page_image' => 'enable',
			'gp_page_image_width' => '700',
			'gp_page_image_height' => '400',
			'gp_page_hard_crop' => 'enable',
			'gp_page_image_wrap' => 'disable',
			'gp_page_title_header' => 'enable',
			'gp_page_title_header_image' => '',
			'gp_page_title_header_color' => '',
			'gp_page_title_header_padding' => '',
			'gp_page_title_header_parallax' => 'enable',								
			'gp_page_author' => 'disable',	
			'gp_page_date' => 'disable',
			'gp_page_comments' => 'disable',				
			'gp_page_author_info' => 'disable',

			/* Portfolio Category Settings */
			'gp_portfolio_cat_layout' => 'no-sidebar',
			'gp_portfolio_cat_sidebar' => 'gp-standard-sidebar',
			'gp_portfolio_cat_slug' => 'portfolios',
			'gp_portfolio_cat_type' => 'portfolio-columns-3',
			'gp_portfolio_cat_filter' => 'filter',
			'gp_portfolio_cat_per_page' => '10',
			'gp_portfolio_cat_title_header' => 'enable',
			'gp_portfolio_cat_title_header_image' => '',
			'gp_portfolio_cat_title_header_color' => '',
			'gp_portfolio_cat_title_header_padding' => '',
			'gp_portfolio_cat_title_header_parallax' => 'enable',	
			
			/* Portfolio Item Settings */
			'gp_portfolio_item_layout' => 'no-sidebar',
			'gp_portfolio_item_sidebar' => 'gp-standard-sidebar',
			'gp_portfolio_item_slug' => 'portfolio-item',	
			'gp_portfolio_item_type' => 'left-image',	
			'gp_portfolio_item_image_width' => '685',	
			'gp_portfolio_item_image_height' => '0',	
			'gp_portfolio_item_hard_crop' => 'enable',
			'gp_portfolio_item_link_text' => 'Website',
			'gp_portfolio_item_link_target' => '_blank',	
			'gp_portfolio_item_title_header' => 'enable',
			'gp_portfolio_item_title_header_image' => '',
			'gp_portfolio_item_title_header_color' => '',
			'gp_portfolio_item_title_header_padding' => '',
			'gp_portfolio_item_title_header_parallax' => 'enable',
			'gp_portfolio_item_related_items' => 'enable',	
			'gp_portfolio_item_related_per_page' => '4',
			'gp_portfolio_item_related_image_width' => '244',	
			'gp_portfolio_item_related_image_height' => '195',										
						
			/* WooCommerce Settings */
			'gp_cart' => 'enable',
			'gp_shop_layout' => 'no-sidebar',
			'gp_shop_sidebar' => 'gp-woocommerce-sidebar',	
			'gp_shop_item_title_header' => 'enable',
			'gp_shop_item_title_header_image' => '',
			'gp_shop_item_title_header_color' => '',
			'gp_shop_item_title_header_padding' => '',
			'gp_shop_item_title_header_parallax' => 'enable',				
			'gp_product_layout' => 'no-sidebar',
			'gp_product_sidebar' => 'gp-woocommerce-sidebar',	
						
			/* BuddyPress/bbPress Settings */
			'gp_bp_layout' => 'no-sidebar',
			'gp_bp_sidebar' => 'gp-standard-sidebar',	
			'gp_bbpress_layout' => 'no-sidebar',
			'gp_bbpress_sidebar' => 'gp-standard-sidebar',
						
			/* Style Settings */
			'gp_bg_color' => '#fff',
			'gp_primary_color' => '#32B2C3',
			'gp_secondary_color' => '#2c2c2c',
			'gp_primary_text_color' => '#747474',
			'gp_secondary_text_color' => '#fff',
			'gp_tertiary_text_color' => '#aaa',
			'gp_alt_bg_color' => '#f7f7f7',
			'gp_border_color' => '#e7e7e7',
			'gp_header_bg_color' => '#222',
			'gp_header_text_color' => '#fff',
			'gp_header_link_color' => '#fff',
			'gp_header_link_hover_color' => '#32B2C3',
			'gp_header_dropdown_bg_color' => '#fff',
			'gp_header_dropdown_bg_hover_color' => '#f7f7f7',
			'gp_header_dropdown_border_color' => '#e7e7e7',
			'gp_header_dropdown_heading_color' => '#32B2C3',
			'gp_header_dropdown_link_color' => '#747474',
			'gp_header_dropdown_link_hover_color' => '#32B2C3',	
			'gp_top_header_color' => '#000',
			'gp_top_header_text_color' => '#74747',
			'gp_top_header_link_color' => '#eee',
			'gp_top_header_link_hover_color' => '#32B2C3',	
			'gp_top_header_dropdown_bg_color' => '#fff',
			'gp_top_header_dropdown_bg_hover_color' => '#f7f7f7',
			'gp_top_header_dropdown_border_color' => '#e7e7e7',
			'gp_top_header_dropdown_heading_color' => '#32B2C3',
			'gp_top_header_dropdown_link_color' => '#747474',
			'gp_top_header_dropdown_link_hover_color' => '#32B2C3',	
			'gp_footer_bg_color' => '#111',
			'gp_footer_heading_color' => '#fff',
			'gp_footer_text_color' => '#aaa',
			'gp_footer_link_color' => '#fff',
			'gp_footer_link_hover_color' => '#32B2C3',		
			'gp_bottom_footer_bg_color' => '#2c2c2c',
			'gp_bottom_footer_text_color' => '#aaa',
			'gp_bottom_footer_link_color' => '#fff',
			'gp_bottom_footer_link_hover_color' => '#32B2C3',			
			'gp_primary_font' => 'Open Sans',
			'gp_primary_font_size' => '13px',
			'gp_primary_line_height' => '1.7em',
			'gp_primary_font_weight' => '400',			
			'gp_nav_font' => 'Open Sans',
			'gp_nav_font_size' => '12px',
			'gp_nav_line_height' => '62px',
			'gp_nav_font_weight' => '400',
			'gp_top_header_nav_font' => 'Open Sans',
			'gp_top_header_nav_font_size' => '11px',
			'gp_top_header_nav_line_height' => '29px',
			'gp_top_header_nav_font_weight' => '400',
			'gp_h1_font' => 'Open Sans',
			'gp_h1_font_size' => '36px',
			'gp_h1_line_height' => '46px',
			'gp_h1_font_weight' => '100',
			'gp_h1_font' => 'Open Sans',
			'gp_h1_font_size' => '36px',
			'gp_h1_line_height' => '46px',
			'gp_h1_font_weight' => '100',
			'gp_h2_font' => 'Open Sans',
			'gp_h2_font_size' => '22px',
			'gp_h2_line_height' => '32px',
			'gp_h2_font_weight' => '100',
			'gp_h3_font' => 'Open Sans',
			'gp_h3_font_size' => '20px',
			'gp_h3_line_height' => '30px',
			'gp_h3_font_weight' => '100',
			'gp_h4_font' => 'Open Sans',
			'gp_h4_font_size' => '18px',
			'gp_h4_line_height' => '22px',
			'gp_h4_font_weight' => '400',			
			'gp_h5_font' => 'Open Sans',
			'gp_h5_font_size' => '16px',
			'gp_h5_line_height' => '20px',
			'gp_h5_font_weight' => '100',	
			'gp_h6_font' => 'Open Sans',
			'gp_h6_font_size' => '14px',
			'gp_h6_line_height' => '18px',
			'gp_h6_font_weight' => '100',			
			'gp_page_width_1' => '1040',
			'gp_content_width_1' => '700',
			'gp_sidebar_width_1' => '300',
			'gp_page_width_2' => '940',
			'gp_content_width_2' => '700',
			'gp_sidebar_width_2' => '200',
			'gp_page_width_3' => '700',
			'gp_content_width_3' => '480',
			'gp_sidebar_width_3' => '180',
			
			/* CSS Settings */
			'gp_custom_stylesheet' => '',
			'gp_custom_css' => '',			
																																																	
		 );
		
		foreach ( $core_settings as $k => $v ) {
			update_option( $k, $v );
		}

		update_option( 'gp_theme_setup_status', '1' );

	}		

}

add_action( 'after_setup_theme', 'gp_theme_options_setup' );

?>