<?php
/*
Template Name: Homepage - FlexSlider
*/
get_header(); ?>

<?php gp_page_header( get_the_ID() ); ?>

<?php if ( get_post_meta( get_the_ID(), '_gp_flexslider_id', true ) ) {

	$slider_width = get_post_meta( get_the_ID(), '_gp_slider_width', true );
	$slider_height = get_post_meta( get_the_ID(), '_gp_slider_height', true );

	$args = array( 
	'post_type' => 'gp_slide',
	'tax_query' => array( 'relation' => 'OR', array( 'taxonomy' => 'gp_slides', 'terms' => get_post_meta( get_the_ID(), '_gp_flexslider_id', true ), 'field' => 'slug' ) ),
	);

	$featured_query = new wp_query( $args ); if ( $featured_query->have_posts() ) : ?>
	
		<div id="homepage-slider" class="gp-slider">
	
			 <ul class="slides">
		
				<?php while ( $featured_query->have_posts() ) : $featured_query->the_post(); ?>
			
					<li>
						<?php $image = aq_resize( wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ), $slider_width, $slider_height, true, false, true ); ?>
						<?php if ( $gp_retina == 'enable' ) {
							$retina = aq_resize(wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ),  $slider_height * 2, $slider_height * 2, true, false, true );
						} else {
							$retina = '';
						} ?>
				
						<?php if ( get_post_meta( get_the_ID(), '_gp_link', true ) != 'http://' ) { ?><a href="<?php echo get_post_meta( get_the_ID(), '_gp_link', true ); ?>" target="<?php echo get_post_meta( get_the_ID(), '_gp_link_target', true ); ?>"><?php } ?>
							<img src="<?php echo $image[0]; ?>" data-rel="<?php echo $retina[0]; ?>" width="<?php echo $image[1]; ?>" height="<?php echo $image[2]; ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true); } else { the_title_attribute(); } ?>" class="wp-post-image" />			
						<?php if ( get_post_meta( get_the_ID(), '_gp_link', true ) != 'http://' ) { ?></a><?php } ?>
				
					</li>
		
				<?php endwhile; ?>
		
			</ul>

		</div>

	<?php endif; wp_reset_postdata(); ?>
		
	<script>
	jQuery( document ).ready( function( $ ) {
		'use strict';
		$( '.page-id-<?php the_ID(); ?> #homepage-slider.gp-slider' ).flexslider( { 
			animation: 'fade',
			slideshowSpeed: <?php if ( get_post_meta( get_the_ID(), '_gp_slide_timeout', true ) != '' ) { echo get_post_meta( get_the_ID(), '_gp_slide_timeout', true ) * 1000; } else { echo '9999999'; } ?>,
			animationSpeed: 600,
			directionNav: true,			
			controlNav: true,			
			pauseOnAction: true, 
			pauseOnHover: false,
			prevText: '',
			nextText: ''
		});

	});
	</script>

<?php } ?><!-- END SLIDER -->

<div id="content-wrapper">

	<div id="content">

		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>				
	
			<?php the_content(); ?>	
		
		<?php endwhile; endif; ?>		

	</div><!-- END CONTENT -->

</div><!-- END CONTENT WRAPPER -->

<?php get_footer(); ?>