<?php


// show admin bar only for admins and editors
if (!current_user_can('edit_posts')) {
	add_filter('show_admin_bar', '__return_false');
}

/////////////////////////////////////// Theme Setup ///////////////////////////////////////

if ( ! function_exists( 'gp_theme_setup' ) ) {
	function gp_theme_setup() {

		// Localisation
		load_theme_textdomain( 'gp_lang', get_template_directory() . '/languages' );
		$gp_locale = get_locale();
		$gp_locale_file = get_template_directory() . '/languages/$gp_locale.php';
		if ( is_readable( $gp_locale_file ) ) { require_once( $gp_locale_file ); }

		// Featured images
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 150, 150, true );

		// Background customizer
		add_theme_support( 'custom-background' );

		// Add shortcode support to Text widget
		add_filter( 'widget_text', 'do_shortcode' );

		// This theme styles the visual editor with editor-style.css to match the theme style
		add_editor_style( 'lib/css/editor-style.css' );

		// Set the content width based on the theme's design and stylesheet
		if ( !isset( $content_width ) ) {
			$content_width = 700;
		}

		// Add default posts and comments RSS feed links to <head>
		add_theme_support( 'automatic-feed-links' );

		// WooCommerce Support
		add_theme_support( 'woocommerce' );

		// Post formats
		add_theme_support( 'post-formats', array( 'quote', 'video', 'audio', 'gallery', 'link' ) );

	}
}
add_action( 'after_setup_theme', 'gp_theme_setup' );


/////////////////////////////////////// Theme Information ///////////////////////////////////////

$gp_themename = get_option( 'current_theme' ); // Theme Name
$gp_dirname = 'vivacity'; // Directory Name


/////////////////////////////////////// File Directories ///////////////////////////////////////

define( 'gp', get_template_directory() . '/' );
define( 'gp_inc', get_template_directory() . '/lib/inc/' );
define( 'gp_scripts', get_template_directory() . '/lib/scripts/' );
define( 'gp_admin', get_template_directory() . '/lib/admin/inc/' );
define( 'gp_wc', get_template_directory() . '/woocommerce/' );
define( 'gp_bp', get_template_directory() . '/buddypress/' );


/////////////////////////////////////// Additional Functions ///////////////////////////////////////


// Image Resizer
require_once( gp_scripts . 'aq_resizer/aq_resizer.php' );

// Main Theme Options
require_once( gp_admin . 'theme-options.php' );

// Meta Options
require_once( gp_admin . 'theme-meta-options.php' );

// Sidebars
require_once( gp_admin . 'theme-sidebars.php' );

// Shortcodes
if ( function_exists( 'vc_set_as_theme' ) ) {
	require_once( gp_admin . 'theme-shortcodes.php' );
}

// Widgets
require_once( gp_admin . 'theme-widgets.php' );

// Woocommerce Functions
if ( function_exists( 'is_woocommerce' ) ) {
	require_once( gp_wc . 'functions-woocommerce.php' );
}


/////////////////////////////////////// Enqueue Styles ///////////////////////////////////////

if ( !is_admin() ) {

	if ( ! function_exists( 'gp_enqueue_styles' ) ) {
	
		function gp_enqueue_styles() { 
	
			require( gp_inc . 'options.php' );
			
			wp_enqueue_style( 'gp-style', get_stylesheet_uri() );
			
			wp_enqueue_style( 'gp-font-awesome', get_template_directory_uri() . '/lib/fonts/font-awesome/css/font-awesome.min.css' );

			wp_enqueue_style( 'gp-open-sans-default', 'http://fonts.googleapis.com/css?family=Open+Sans:400,300,700' );
			
			if( function_exists( 'bp_is_active' ) OR function_exists( 'is_bbpress' ) ) {
				wp_enqueue_style( 'gp-buddypress', get_template_directory_uri() . '/lib/css/bp.css' );
			}
			
			wp_enqueue_style( 'gp-animations', get_template_directory_uri() . '/lib/css/animations.css' );

			wp_enqueue_style( 'gp-prettyphoto', get_template_directory_uri() . '/lib/scripts/prettyPhoto/css/prettyPhoto.css' );

			if ( $gp_primary_font != 'Open Sans' ) {
				wp_enqueue_style( 'gp-' . $gp_primary_font, 'http://fonts.googleapis.com/css?family=' . $gp_primary_font . ':300,400,600,700,900,300italic,400italic,600italic,700italic,900italic' );
			}

			if ( $gp_top_header_nav_font != 'Open Sans' ) {
				wp_enqueue_style( 'gp-' . $gp_top_header_nav_font, 'http://fonts.googleapis.com/css?family=' . $gp_top_header_nav_font . ':300,400,600,700,900,300italic,400italic,600italic,700italic,900italic' );
			}
					
			if ( $gp_nav_font != 'Open Sans' ) {
				wp_enqueue_style( 'gp-' . $gp_nav_font, 'http://fonts.googleapis.com/css?family=' . $gp_nav_font . ':300,400,600,700,900,300italic,400italic,600italic,700italic,900italic' );
			}

			if ( $gp_h1_font != 'Open Sans' ) {
				wp_enqueue_style( 'gp-' . $gp_h1_font, 'http://fonts.googleapis.com/css?family=' . $gp_h1_font . ':300,400,600,700,900,300italic,400italic,600italic,700italic,900italic' );
			}

			if ( $gp_h2_font != 'Open Sans' ) {
				wp_enqueue_style( 'gp-' . $gp_h2_font, 'http://fonts.googleapis.com/css?family=' . $gp_h2_font . ':300,400,600,700,900,300italic,400italic,600italic,700italic,900italic' );
			}
		
			if ( $gp_h3_font != 'Open Sans' ) {
				wp_enqueue_style( 'gp-' . $gp_h3_font, 'http://fonts.googleapis.com/css?family=' . $gp_h3_font . ':300,400,600,700,900,300italic,400italic,600italic,700italic,900italic' );
			}

			if ( $gp_h4_font != 'Open Sans' ) {
				wp_enqueue_style( 'gp-' . $gp_h4_font, 'http://fonts.googleapis.com/css?family=' . $gp_h4_font . ':300,400,600,700,900,300italic,400italic,600italic,700italic,900italic' );
			}

			if ( $gp_h5_font != 'Open Sans' ) {
				wp_enqueue_style( 'gp-' . $gp_h5_font, 'http://fonts.googleapis.com/css?family=' . $gp_h5_font . ':300,400,600,700,900,300italic,400italic,600italic,700italic,900italic' );
			}

			if ( $gp_h6_font != 'Open Sans' ) {
				wp_enqueue_style( 'gp-' . $gp_h6_font, 'http://fonts.googleapis.com/css?family=' . $gp_h6_font . ':300,400,600,700,900,300italic,400italic,600italic,700italic,900italic' );
			}

			if ( $gp_custom_stylesheet != '' ) {
				wp_enqueue_style( 'gp-custom-style', get_template_directory_uri() . '/' . $gp_custom_stylesheet );
			}
		}
	}
	
	add_action( 'wp_enqueue_scripts', 'gp_enqueue_styles' );
}


/////////////////////////////////////// Enqueue Scripts ///////////////////////////////////////

if ( !is_admin() ) {

	if ( ! function_exists( 'gp_enqueue_scripts' ) ) {
	
		function gp_enqueue_scripts() { 

			require( gp_inc . 'options.php' ); global $gp_settings;

			wp_enqueue_script( 'gp-modernizr', get_template_directory_uri() . '/lib/scripts/modernizr.js', array( 'jquery' ), '', false );
					
			if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) { 
				wp_enqueue_script( 'comment-reply' );
			}
			
			wp_enqueue_script( 'gp-stellar', get_template_directory_uri() . '/lib/scripts/jquery.stellar.min.js', array( 'jquery' ), '', false );
			
			if ( $gp_smooth_scrolling == 'gp-smooth-scrolling' ) { 
				wp_enqueue_script( 'gp-nicescroll', get_template_directory_uri() . '/lib/scripts/nicescroll.min.js', array( 'jquery' ), '', true );
			}

			wp_enqueue_script( 'gp-selectivizr', get_template_directory_uri() . '/lib/scripts/selectivizr.min.js', array( 'jquery' ), '', true );

			wp_enqueue_script( 'gp-placeholder', get_template_directory_uri() . '/lib/scripts/placeholders.min.js', array( 'jquery' ), '', true );
										
			wp_enqueue_script( 'gp-prettyphoto', get_template_directory_uri() . '/lib/scripts/prettyPhoto/js/jquery.prettyPhoto.js', array( 'jquery' ), '', true );

			if ( $gp_back_to_top == 'gp-back-to-top' ) { 
				wp_enqueue_script( 'gp-back-to-top', get_template_directory_uri() . '/lib/scripts/jquery.ui.totop.min.js', array( 'jquery' ), '', true );
			}
			
			if ( !function_exists( 'vc_set_as_theme' ) ) {
				wp_enqueue_script( 'gp-flexslider', get_template_directory_uri() . '/lib/scripts/jquery.flexslider-min.js', array( 'jquery' ), '', true );
			} else {
				wp_enqueue_script( 'flexslider' );
			}			
									
			if ( !function_exists( 'vc_set_as_theme' ) ) {
				wp_enqueue_script( 'gp-isotope', get_template_directory_uri() . '/lib/scripts/jquery.isotope.min.js', array( 'jquery' ), '', true );
			} else {
				wp_enqueue_script( 'isotope' );
			}
			
			wp_enqueue_script( 'gp-images-loaded', get_template_directory_uri() . '/lib/scripts/imagesLoaded.min.js', array( 'jquery' ), '', true );
															
			//wp_enqueue_script( 'gp-fixed-fixed', get_template_directory_uri() . '/lib/scripts/fixedfixed.js', array( 'jquery' ), '', true );

			wp_enqueue_script( 'gp-custom-js', get_template_directory_uri() . '/lib/scripts/custom.js', array( 'jquery' ), '', true );
	
			wp_localize_script( 'gp-custom-js', 'gp_script', array(
				'headerHeight' => ( $gp_logo_height + $gp_logo_top + $gp_logo_bottom ),
				'logoHeight' => $gp_logo_height,
				'logoMarginTop' => $gp_logo_top,
				'logoMarginBottom' => $gp_logo_bottom,
				'navLineHeight' => $gp_nav_line_height,
				'headerSizeReduction' => $gp_header_size_reduction,
				'emptySearchText' => __( 'Please enter something in the search box!', 'gp_lang' ),
			) );	
				
		}
	}
	
	add_action( 'wp_enqueue_scripts', 'gp_enqueue_scripts' );
	
}


/////////////////////////////////////// WP Header Hooks ///////////////////////////////////////


if ( ! function_exists( 'gp_wp_header' ) ) {

	function gp_wp_header() {
	
		require( gp_inc . 'options.php' );
	
		if ( $gp_favicon_ico ) {
			echo '<link rel="shortcut icon" href="' . $gp_favicon_ico . '" /><link rel="icon" href="' . $gp_favicon_ico . '" type="image/vnd.microsoft.icon" />'; 
		}
				
		if ( $gp_favicon_png ) {
			echo '<link rel="icon" type="image/png" href="' . $gp_favicon_png . '" />';
		}
				
		if ( $gp_apple_icon ) {
			echo '<link rel="apple-touch-icon" href="' . $gp_apple_icon . '" />';
		}

		require_once(gp_inc . 'style-settings.php' );
	
		if ( $gp_retina == 'enable' ) {
			echo '<script>jQuery(document).ready(function($){window.devicePixelRatio>=2&&$(".post-thumbnail img").each(function(){jQuery(this).attr({src:$(this).attr("data-rel")})})});</script>';
		}

		echo stripslashes( $gp_scripts );

	}
	
}

add_action( 'wp_head', 'gp_wp_header' );


/////////////////////////////////////// Navigation Menus ///////////////////////////////////////


if ( ! function_exists( 'gp_register_menus' ) ) {
	function gp_register_menus() {
		register_nav_menus(array(
			'header-nav' => __( 'Main Header Navigation', 'gp_lang' ),
			'top-nav'    => __( 'Top Header Navigation', 'gp_lang' ),
			'footer-nav' => __( 'Footer Navigation', 'gp_lang' ),
		) );
	}
}
add_action( 'init', 'gp_register_menus' );


/////////////////////////////////////// Excerpts ///////////////////////////////////////

// Character Length
if ( ! function_exists( 'gp_excerpt_length' ) ) {
	function gp_excerpt_length( $gp_length ) {
		return 10000;
	}
}
add_filter( 'excerpt_length', 'gp_excerpt_length' );

// Excerpt Output
if ( ! function_exists( 'gp_excerpt' ) ) {
	function gp_excerpt( $gp_count ) {
		global $gp_settings;
		if ( isset( $gp_settings['read_more'] ) && $gp_settings['read_more'] == 'enable' ) {
			$gp_more_text = ' ...<a href="' .get_permalink( get_the_ID() ) . '" class="read-more more-link" title="' . the_title_attribute( 'echo=0' ) . '">[' . __( 'Read More', 'gp_lang' ) . ']</a>';
		} else {
			$gp_more_text = ' ...';
		}	
		$gp_excerpt = get_the_excerpt();
		$gp_excerpt = strip_tags( $gp_excerpt );
		if ( function_exists( 'mb_strlen' ) && function_exists( 'mb_substr' ) ) { 
			if ( mb_strlen( $gp_excerpt ) > $gp_count ) {
				$gp_excerpt = mb_substr( $gp_excerpt, 0, $gp_count ) . $gp_more_text;
			}
		} else {
			if ( strlen( $gp_excerpt ) > $gp_count ) {
				$gp_excerpt = substr( $gp_excerpt, 0, $gp_count ) . $gp_more_text;
			}	
		}
		return $gp_excerpt;
	}
}


/////////////////////////////////////// Add Excerpt Support To Pages ///////////////////////////////////////

if ( ! function_exists( 'gp_add_excerpts_to_pages' ) ) {
	function gp_add_excerpts_to_pages() {
		 add_post_type_support( 'page', 'excerpt' );
	}
}
add_action( 'init', 'gp_add_excerpts_to_pages' );


/////////////////////////////////////// Page Header ///////////////////////////////////////

if ( ! function_exists( 'gp_page_header' ) ) {

	function gp_page_header( $gp_post_id = '' ) {
		
		global $gp_settings;
		
		if ( isset( $gp_settings['title_header'] ) && $gp_settings['title_header'] == 'enable' ) {
		
			if ( isset( $gp_settings['title_image'] ) && $gp_settings['title_image'] != '' ) { 
				$title_image = 'background-image: url(' . $gp_settings['title_image'] . ');';
				$title_class = ' special-header';
				if ( isset( $gp_settings['title_parallax'] ) && $gp_settings['title_parallax'] == 'enable' ) {
					$parse_parallax_scrolling = ' data-stellar-background-ratio="0.6"';
					$parallax_class = ' gp-parallax';
				} else {
					$parse_parallax_scrolling = '';
					$parallax_class = '';
				}
			} else {
				$title_image = '';
				$title_class = ' page-header';
				$parse_parallax_scrolling = '';
				$parallax_class = '';
			}

			if ( isset( $gp_settings['title_color'] ) && $gp_settings['title_color'] != '' ) {
				$color = 'color: ' . $gp_settings['title_color'] . ';';
			} else {
				$color = '';
			}

			if ( isset( $gp_settings['title_padding'] ) && $gp_settings['title_padding'] != '' ) { 
				$padding = 'padding: ' . $gp_settings['title_padding'] . ';';
			} else {
				$padding = '';
			}

			if ( function_exists( 'is_woocommerce' ) && is_shop() ) {
				$gp_post_id = get_option( 'woocommerce_shop_page_id' );
			}
		
			?>
		
			<header class="entry-header<?php echo $title_class . $parallax_class; ?>" style="<?php echo $padding . $title_image; ?>"<?php echo $parse_parallax_scrolling; ?>>
		
				<div class="container">
					
					<?php if ( is_page() OR ( function_exists( 'is_woocommerce' ) && is_shop() ) OR ( function_exists( 'bp_is_active' ) && ! bp_is_blog_page() ) OR ( function_exists( 'is_bbpress' ) && is_bbpress() ) ) { ?>

						<h1 class="entry-title" style="<?php echo $color; ?>"><?php if ( get_post_meta( $gp_post_id, '_gp_title', true ) != '' ) { echo get_post_meta( $gp_post_id, '_gp_title', true ); } else { echo get_the_title( $gp_post_id ); } ?></h1>

					<?php } elseif ( is_singular( 'gp_portfolio_item' ) ) { ?>
						
						<h1 class="entry-title" style="<?php echo $color; ?>"><?php echo get_the_title( $gp_post_id ); ?></h1>
																		
					<?php } elseif ( is_search() ) { global $wp_query, $s; ?>
						
						<h1 class="entry-title" style="<?php echo $color; ?>">
							<?php if ( isset( $_GET['s'] ) && ( $_GET['s'] != '' ) ) { ?>
								<?php echo $wp_query->found_posts; ?> <?php _e( 'search results for', 'gp_lang' ); ?> "<?php echo esc_html( $s ); ?>"
							<?php } else { ?>
								<?php _e( 'Search', 'gp_lang' ); ?>
							<?php } ?>	
						</h1>
						
					<?php } elseif ( is_category() OR is_tag() OR is_tax() ) { ?>
						
						<h1 class="entry-title" style="<?php echo $color; ?>"><?php single_cat_title(); ?></h1>
						
					<?php } elseif ( is_author() ) { ?>

						<?php echo get_avatar( get_the_author_meta( 'ID' ), 80 ); ?>
						<div class="author-meta">
							<h1 class="entry-title" style="<?php echo $color; ?>"><?php echo get_the_author(); ?></h1>
							<h2 class="subtitle" style="<?php echo $color; ?>"><?php the_author_meta( 'description' ); ?></h2>
						</div>
						
					<?php } elseif ( is_archive() ) { ?>
						
						<h1 class="entry-title" style="<?php echo $color; ?>"><?php _e( 'Archives', 'gp_lang' ); ?> <?php wp_title( ' / ' ); ?></h1>
								
					<?php } else { ?>
						
						<h1 class="entry-title" style="<?php echo $color; ?>"><?php bloginfo( 'name' ); ?></h1>
						
					<?php } ?>

					<?php if ( get_post_meta( $gp_post_id, '_gp_subtitle', true ) ) { ?>
						<h3 class="subtitle" style="<?php echo $color; ?>"><?php echo get_post_meta( $gp_post_id, '_gp_subtitle', true ); ?></h3>
					<?php } ?>
						
					<?php if ( is_singular( 'gp_portfolio_item' ) && get_post_meta( $gp_post_id, '_gp_link', true ) != 'http://' ) { ?>
						<a href="<?php echo get_post_meta( $gp_post_id, '_gp_link', true ); ?>" class="button portfolio-link" target="<?php echo $gp_settings['link_target']; ?>"><?php echo $gp_settings['link_text']; ?></a>
					<?php } ?>
								
				</div>
						
			</header>
			
		<?php }
								
	}

}


/////////////////////////////////////// Change Insert Into Post Text ///////////////////////////////////////	

if ( is_admin() && $pagenow == 'themes.php' ) {
	if ( ! function_exists( 'gp_change_image_button' ) ) {
		add_filter( 'gettext', 'gp_change_image_button', 10, 3);
		function gp_change_image_button( $gp_translation, $gp_text, $gp_domain ) {
			if ( 'default' == $gp_domain && 'Insert into post' == $gp_text ) {
				remove_filter( 'gettext', 'gp_change_image_button' );
				return __( 'Use Image', 'gp_lang' );
			}
			return $gp_translation;
		}
	}
}


/////////////////////////////////////// Change Password Protect Post Text ///////////////////////////////////////	

if ( ! function_exists( 'gp_password_form' ) ) {
	function gp_password_form() {
		global $post;
		$gp_label = 'pwbox-' .( empty( $post->ID ) ? rand() : $post->ID );
		$gp_o = '<form action="' . esc_url( site_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" method="post">
		<p>' . __( 'To view this protected post, enter the password below:', 'gp_lang' ) . '</p>
		<label for="' . $gp_label . '"><input name="post_password" id="' . $gp_label . '" type="password" size="20" maxlength="20" /></label> <input type="submit" class="pwsubmit" name="Submit" value="' . esc_attr__( 'Submit', 'gp_lang' ) . '" />
		</form>
		';
		return $gp_o;
	}
}
add_filter( 'the_password_form', 'gp_password_form' );


/////////////////////////////////////// Redirect Empty Search To Search Page ///////////////////////////////////////	

if ( ! function_exists( 'gp_empty_search' ) ) {
	function gp_empty_search( $gp_query ) {
		global $wp_query;
		if ( isset( $_GET['s'] ) && ( $_GET['s'] == '' ) ) {
			$wp_query->set( 's', ' ' );
			$wp_query->is_search = true;
		}
		return $gp_query;
	}
}
add_action( 'pre_get_posts', 'gp_empty_search' );


/////////////////////////////////////// Pagination ///////////////////////////////////////	


if ( !is_admin() ) {
	if ( ! function_exists( 'gp_pagination' ) ) {
		function gp_pagination( $gp_query ) {
			$gp_big = 999999999;
			if ( get_query_var('paged') ) {
				$paged = get_query_var('paged');
			} elseif ( get_query_var('page') ) {
				$paged = get_query_var('page');
			} else {
				$paged = 1;
			}
			echo paginate_links( array(
				'base'      => str_replace( $gp_big, '%#%', esc_url( get_pagenum_link( $gp_big ) ) ),
				'format'    => '?paged=%#%',
				'current'   => max(1, $paged ),
				'total'     => $gp_query,
				'type'      => 'list',
				'prev_text' => '&laquo;',
				'next_text' => '&raquo;',
			) );
		}
	}
}


/////////////////////////////////////// Hide Theme Options Tab ///////////////////////////////////////	

if ( ! function_exists( 'is_woocommerce' ) OR ( ! function_exists( 'bp_is_active' ) && ! function_exists( 'is_bbpress' ) ) ) {
	if ( ! function_exists( 'gp_hide_theme_option_tabs' ) ) { 
		function gp_hide_theme_option_tabs() {
			if ( ! function_exists( 'is_woocommerce' ) ) { 
				echo '<style>#gp-theme-options a[href="#9"] {display: none !important;}</style>';
			}
			if ( ! function_exists( 'bp_is_active' ) && ! function_exists( 'is_bbpress' ) ) { 
				echo '<style>#gp-theme-options a[href="#10"] {display: none !important;}</style>';
			}		
		}
	}	
	add_action( 'admin_head', 'gp_hide_theme_option_tabs' );
}	


/////////////////////////////////////// Disable LayerSlider Auto Updates ///////////////////////////////////////	

if ( ! function_exists( 'gp_layerslider_overrides' ) ) {  
	function gp_layerslider_overrides() {
		$GLOBALS['lsAutoUpdateBox'] = false;
	}
}
add_action('layerslider_ready', 'gp_layerslider_overrides');  


/////////////////////////////////////// Disable Visual Composer Design Tab & Auto Updates ///////////////////////////////////////	

if ( function_exists( 'vc_set_as_theme' ) ) {
	vc_set_as_theme($notifier = true);
}		

					
/////////////////////////////////////// TMG Plugin Activation ///////////////////////////////////////	

require_once( gp_admin . 'class-tgm-plugin-activation.php' );

if ( ! function_exists( 'gp_register_required_plugins' ) ) {
	
	function gp_register_required_plugins() {

		$plugins = array(

			array(
				'name'               => 'Vivacity Plugin',
				'slug'               => 'vivacity-plugin',
				'source'             => get_template_directory() . '/lib/plugins/vivacity-plugin.zip',
				'required'           => true,
				'version'            => '1.1',
				'force_activation'   => true,
				'force_deactivation' => true,
			),

			array(
				'name'               => 'WPBakery Visual Composer',
				'slug'               => 'js_composer',
				'source'             => get_template_directory() . '/lib/plugins/js_composer.zip',
				'required'           => false,
				'version'            => '4.1.3.1',
				'force_activation'	 => false,
				'force_deactivation' => false,
			),
        
			array(
				'name'               => 'LayerSlider WP',
				'slug'               => 'LayerSlider',
				'source'             => get_template_directory() . '/lib/plugins/layerslider.zip',
				'required'           => false,
				'version'            => '5.1.1',
				'force_activation'   => false,
				'force_deactivation' => false,
			),
		
			array(
				'name'      => 'Contact Form 7',
				'slug'      => 'contact-form-7',
				'required' 	=> false,
			),

			array(
				'name'      => 'Responsive Video Embeds',
				'slug'      => 'responsive-video-embeds',
				'required' 	=> false,
			),			
		
			array(
				'name'      => 'WooCommerce',
				'slug'      => 'woocommerce',
				'required' 	=> false,
			),

			array(
				'name' => 'BuddyPress',
				'slug' => 'buddypress',
				'required' 	=> false,
			),

			array(
				'name' => 'bbPress',
				'slug' => 'bbpress',
				'required' 	=> false,
			),
											
		);

		$config = array(
			'default_path' => '',                      // Default absolute path to pre-packaged plugins.
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => true,                   // Automatically activate plugins after installation or not.
			'message'      => '',                      // Message to output right before the plugins table.
		);
 
		tgmpa( $plugins, $config );

	}
	
}

add_action( 'tgmpa_register', 'gp_register_required_plugins' );


?>