<?php 

if ( ! class_exists( 'GP_Slides' ) ) {

	class GP_Slides {

		public function __construct() {
			add_action( 'init', array( &$this, 'gp_post_type_slides' ) );	
			add_action( 'manage_posts_custom_column',  array( &$this, 'gp_slides_custom_columns' ) );
		}

		public function gp_post_type_slides() {

			/*--------------------------------------------------------------
			Slide Post Type
			--------------------------------------------------------------*/	
	
			register_post_type( 'gp_slide', array( 
				'labels' => array( 
					'name' => __( 'Slides', 'gp_lang' ),
					'singular_name' => __( 'Slide', 'gp_lang' ),
					'menu_name' => __( 'Slides', 'gp_lang' ),
					'all_items' => __( 'All Slides', 'gp_lang' ),
					'add_new' => _x( 'Add New', 'portfolio', 'gp_lang' ),
					'add_new_item' => __( 'Add New Slide', 'gp_lang' ),
					'edit_item' => __( 'Edit Slide', 'gp_lang' ),
					'new_item' => __( 'New Slide', 'gp_lang' ),
					'view_item' => __( 'View Slide', 'gp_lang' ),
					'search_items' => __( 'Search Slides', 'gp_lang' ),
					'not_found' => __( 'No slides found', 'gp_lang' ),
					'not_found_in_trash' => __( 'No slides found in Trash', 'gp_lang' ),
				 ),
				'public' => true,
				'exclude_from_search' => false,
				'show_ui' => true,
				'show_in_nav_menus' => true,
				'_builtin' => false,
				'_edit_link' => 'post.php?post=%d',
				'capability_type' => 'post',
				'hierarchical' => false,
				'rewrite' => array( 'slug' => 'slide' ),
				'menu_position' => 20,
				'with_front' => true,
				'has_archive' => 'gp_slides',
				'supports' => array( 'title', 'thumbnail' )
			 ) );
	
	
			/*--------------------------------------------------------------
			Slide Categories Taxonomy
			--------------------------------------------------------------*/
			
			register_taxonomy( 'gp_slides', 'gp_slide', array( 
				'labels' => array( 
					'name' => __( 'Slide Categories', 'gp_lang' ),
					'singular_name' => __( 'Slide Category', 'gp_lang' ),
					'all_items' => __( 'All Slide Categories', 'gp_lang' ),
					'add_new' => _x( 'Add New', 'portfolio', 'gp_lang' ),
					'add_new_item' => __( 'Add New Slide Category', 'gp_lang' ),
					'edit_item' => __( 'Edit Slide Category', 'gp_lang' ),
					'new_item' => __( 'New Slide Category', 'gp_lang' ),
					'view_item' => __( 'View Slide Category', 'gp_lang' ),
					'search_items' => __( 'Search Slide Categories', 'gp_lang' ),
					'menu_name' => __( 'Slide Categories', 'gp_lang' )
				 ),
				'show_in_nav_menus' => true,
				'hierarchical' => true,
				'rewrite' => array( 'slug' => 'slides' )
			 ) );


			register_taxonomy_for_object_type( 'gp_slides', 'gp_slide' );


			/*--------------------------------------------------------------
			Slide Admin Columns
			--------------------------------------------------------------*/

			if ( ! function_exists( 'gp_slide_edit_columns' ) ) { 
				function gp_slides_edit_columns( $columns ) {
					$columns = array( 
					'cb'                   => '<input type="checkbox" />',
					'title'                => __( 'Title', 'gp_lang' ),	
					'slide_categories' => __( 'Categories', 'gp_lang' ),
					'slide_image'      => __( 'Image', 'gp_lang' ),				
					'date'                 => __( 'Date', 'gp_lang' )
					 );
					return $columns;
				}	
			}
			add_filter( 'manage_edit-gp_slide_columns', 'gp_slides_edit_columns' );
		
		}

		public function gp_slides_custom_columns( $column ) {
			switch ( $column ) {
				case 'slide_categories':
					echo get_the_term_list( get_the_ID(), 'gp_slides', '', ', ', '' );
				break;
				case 'slide_image':
					if ( has_post_thumbnail() ) {
						the_post_thumbnail( array( 50, 50 ) );
					}
				break;					
			}
		}
		
		
	}

}

?>